<?php
/**
 * Filename:       includes/lang/svenska-utf8.inc.php
 * Function:       Swedish language file
 * Encoding:       UTF-8
 * Author:         Pontus Ågren (Pont) & Johnny Chadda
 * Date:           2007-05-13
 * Version:        0.9.6
 * MODx version:   0.9.6
*/

$_lang["about_msg"] = 'MODx är ett <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP applikationsramverk och system för innehållshantering</a> och är licensierat under <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'Om MODx';
$_lang["access_permission_denied"] = 'Du har inte behörighet för detta dokument.';
$_lang["access_permission_parent_denied"] = 'Du har inte behörighet att skapa ett dokument här eller att flytta ett hit! Välj en annan plats.';
$_lang["access_permissions"] = 'Åtkomstinställningar';
$_lang["access_permissions_add_document_group"] = 'Skapa en ny dokumentgrupp';
$_lang["access_permissions_add_user_group"] = 'Skapa en ny användargrupp';
$_lang["access_permissions_docs_message"] = 'Här kan du välja vilka dokumentgrupper detta dokument ska tillhöra:';
$_lang["access_permissions_document_groups"] = 'Dokumentgrupper';
$_lang["access_permissions_documents_in_group"] = '<b>Dokument i gruppen:</b> ';
$_lang["access_permissions_documents_tab"] = 'Här kan du se vilka dokumentgrupper som har blivit konfigurereade. Du kan även skapa nya och byta namn på grupper samt se vilka dokument som tillhör en specifik grupp (håll musen över dokumentets ID för att se dess namn). För att lägga till eller ta bort ett dokument från en grupp, redigera dokumentet direkt.';
$_lang["access_permissions_introtext"] = 'Här kan du hantera de användargrupper och dokumentgrupper som används för åtkomstkontroll. För att lägga till en användare i en grupp, redigera användaren och välj de grupper som han/hon ska vara medlem i. För att lägga till ett dokument till en användargrupp, redigera dokumentet och välj de grupper som det ska tillhöra.';
$_lang["access_permissions_links"] = 'Användar/dokumentgruppslänkar';
$_lang["access_permissions_links_tab"] = 'Här specificerar du vilka användargrupper som har behörighet för de olika dokumentgrupperna (dvs kan redigera eller skapa underdokument). För att länka en dokumentgrupp till en användargrupp, välj gruppen från menyn och klicka på "Länka". För att ta bort länken för en grupp, klicka på "Ta bort ->". Detta tar genast bort länken.';
$_lang["access_permissions_no_documents_in_group"] = 'Inga.';
$_lang["access_permissions_no_users_in_group"] = 'Inga.';
$_lang["access_permissions_off"] = '<span class="warning">Åtkomstinställningar är inte aktiverade.</span> Detta betyder att förändringar som görs här inte kommer att ha någon effekt förrän åtkomstinställningarna är aktiverade.';
$_lang["access_permissions_user_group"] = 'Användargrupp:';
$_lang["access_permissions_user_group_access"] = 'Dokumentgrupper som denna användargrupp har behörighet för:';
$_lang["access_permissions_user_groups"] = 'Användargrupper';
$_lang["access_permissions_user_message"] = 'Här kan du välja vilka användargrupper denna anvädare ska tillhöra:';
$_lang["access_permissions_users_in_group"] = '<b>Användare i gruppen:</b> ';
$_lang["access_permissions_users_tab"] = 'Här kan du se vilka användargrupper som har blivit konfigurerade. Du kan också skapa nya, byta namn på och ta bort grupper samt se vilka användare som är medlemmar i en specifik grupp. För att lägga till eller ta bort en användare från en grupp, redigera användaren direkt. Administratörer (som har roll-ID 1) har alltid tillgång till alla dokument, så de behöver inte läggas till i några grupper.';
$_lang["account_email"] = 'Kontots epost';
$_lang["actioncomplete"] = '<b>Händelsen har utförts!</b><br /> - Vänta medan MODx rensar upp.';
$_lang["activity_message"] = 'Denna lista visar de senaste dokumenten som du skapat eller redigerat:';
$_lang["activity_title"] = 'Nyligen skapade/redigerade dokument';
$_lang["add"] = 'Lägg till';
$_lang["add_chunk"] = 'Lägg till chunk';
$_lang["add_doc"] = 'Lägg till dokument';
$_lang["add_document"] = 'Nytt dokument';
$_lang["add_folder"] = 'Ny mapp';
$_lang["add_plugin"] = 'Lägg till plugin';
$_lang["add_snippet"] = 'Lägg till snippet';
$_lang["add_tag"] = 'Lägg till tagg';
$_lang["add_template"] = 'Lägg till mall';
$_lang["add_tv"] = 'Lägg till mallvariabel';
$_lang["add_weblink"] = 'Ny webblänk';
$_lang["administrator_role_message"] = 'Denna roll kan inte redigeras eller tas bort.';
$_lang["after_saving"] = 'Efter sparande';
$_lang["alert_delete_self"] = 'Du kan inte ta bort dig själv!';
$_lang["alias"] = 'Alias';
$_lang["all_doc_groups"] = 'Alla dokumentgrupper (Offentlig)';
$_lang["all_events"] = 'Alla händelser';
$_lang["all_usr_groups"] = 'Alla användargrupper (Offentlig)';
$_lang["allow_mgr_access"] = 'Åtkomst till hanterarens gränssnitt';
$_lang["allow_mgr_access_message"] = 'Använd den här inställningen för att tillåta eller förbjuda åtkomst till hanterarens gränssnitt.<br /><b>Notera: Om den här inställningen är satt till "Nej" kommer användaren att omdirigeras till inloggningssidan eller webbplatsens startsida.</b>';
$_lang["already_deleted"] = 'har redan tagits bort.';
$_lang["attachment"] = 'Bifogad fil';
$_lang["automatic_alias_message"] = 'Välj "Ja" för att låta systemet automatiskt skapa ett alias baserat på dokumentets titel när det sparas.';
$_lang["automatic_alias_title"] = 'Generera alias automatiskt';
$_lang["backup"] = 'Säkerhetskopia';
$_lang["bk_manager"] = 'Säkerhetskopiering';
$_lang["block_message"] = 'Denna användare kommer att blockeras när användarens data sparats!';
$_lang["blocked_minutes_message"] = 'Här kan du ange hur många minuter en användare blir blockerad efter att ha gjort för många misslyckade inloggningsförsök. Ange värdet som ett tal (inga kommatecken, mellanslag etc).';
$_lang["blocked_minutes_title"] = 'Blockeringstid:';
$_lang["cache_files_deleted"] = 'Följande filer togs bort:';
$_lang["cancel"] = 'Avbryt';
$_lang["captcha_code"] = 'Säkerhetskod';
$_lang["captcha_message"] = 'Använd detta för att stärka säkerheten genom att låta användare skriva in en säkerhetskod som är oläsbar för maskiner (och scriptkidsens hackingscript).';
$_lang["captcha_title"] = 'Använd CAPTCHA-koder';
$_lang["captcha_words_message"] = 'Här kan du skriva en lista på CAPTCHA-ord som används om CAPTCHA är påslaget. Separera orden med kommatecken. Detta textfält är begränsat till 255 tecken.';
$_lang["captcha_words_title"] = 'CAPTCHA-ord';
$_lang["category_heading"] = 'Kategori';
$_lang["category_msg"] = 'Här kan du visa och redigera alla resurser som gruperats i kategorier.';
$_lang["change_name"] = 'Ändra namn';
$_lang["change_password"] = 'Byt lösenord';
$_lang["change_password_confirm"] = 'Bekräfta lösenord';
$_lang["change_password_message"] = 'Skriv in ditt nya lösenord, och gör det sedan en gång till för att bekräfta. Ditt lösenord måste vara mellan 6 och 15 tecken långt.';
$_lang["change_password_new"] = 'Nytt lösenord';
$_lang["charset_message"] = 'Välj den teckenkodning du vill använda i sidhanteraren.<br /><b>Notera: MODx har testats med ett antal av dessa kodningar, men inte alla. För de flesta språk är standardalternativet UTF-8 att föredra.</b>';
$_lang["charset_title"] = 'Teckenkodning';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk-kod (html)';
$_lang["cleaningup"] = 'Rensar upp';
$_lang["clear_log"] = 'Rensa logg';
$_lang["click_to_context"] = 'Klicka för att komma åt snabbmenyn';
$_lang["click_to_edit_title"] = 'Klicka här för att redigera den här posten';
$_lang["click_to_view_details"] = 'Klicka här för att se detaljer';
$_lang["close"] = 'Stäng';
$_lang["collapse_tree"] = 'Fäll ihop träd';
$_lang["comment"] = 'Kommentar';
$_lang["configcheck_admin"] = 'Kontakta en systemadministratör och varna om detta meddelande!';
$_lang["configcheck_cache"] = 'cache-katalogen inte skrivbar';
$_lang["configcheck_cache_msg"] = 'MODx kan inte skriva till cache-katalogen. MODx kommer fortfarande att fungera som väntat, men inga dokument kommer att cachas. För att rätta till det här, gör /_cache/-katalogen skrivbar.';
$_lang["configcheck_configinc"] = 'Konfigurationsfilen är fortfarande skrivbar';
$_lang["configcheck_configinc_msg"] = 'Elaka människor kan orsaka stora skador på din webbplats och allt som hör till den. <strong>På riktigt.</strong> Se till att konfigurationsfilen (/manager/includes/config.inc.php) blir skrivskyddad!';
$_lang["configcheck_default_msg"] = 'En ospecificerad varning hittades, vilket är konstigt.';
$_lang["configcheck_errorpage_unavailable"] = 'Felsidan för din webbplats är inte tillgänglig';
$_lang["configcheck_errorpage_unavailable_msg"] = 'Detta betyder att din felsida inte är tillgänglig för vanliga användare eller att den inte existerar. Det här kan leda till att ett tillstånd med upprepande loopar skapas och ger upphov till att många fel rapporteras i webbplatsens loggar. Kontrollera att inga webbanvändargrupper är anslutna till sidan.';
$_lang["configcheck_errorpage_unpublished"] = 'Felsidan för din webbplats är inte publicerad eller existerar inte.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'Detta betyder att din felsida inte är tillgänglig för allmänheten. Publicera sidan eller kontrollera under Verktyg &gt; Konfiguration att den refererade sidan är ett existerande dokument i webbplatsens dokumentträd.';
$_lang["configcheck_images"] = 'Bildkatalogen är inte skrivbar';
$_lang["configcheck_images_msg"] = 'Bildkatalogen är inte skrivbar eller finns inte. Detta betyder att bildhanteringsfunktionerna i editorn inte kommer att fungera!';
$_lang["configcheck_installer"] = 'Installationsprogrammet är fortfarande kvar';
$_lang["configcheck_installer_msg"] = 'Katalogen install/ innehåller installationsprogrammet för MODx. Tänk vad som kan hända om en elak människa hittar katalogen och kör installationen! Han kommer förhoppningsvis inte så långt, eftersom databasen kräver inloggningsuppgifter, men det är ändå bäst att ta bort katalogen från servern.';
$_lang["configcheck_lang_difference"] = 'Fel antal fraser i språkfilen';
$_lang["configcheck_lang_difference_msg"] = 'Språket som för närvarande är valt har ett annat antal fraser än standardspråket. Detta behöver inte vara ett problem, men kan betyda att språkfilen behöver uppdateras.';
$_lang["configcheck_notok"] = 'En eller flera konfigurationsdetaljer är inte korrekta: ';
$_lang["configcheck_ok"] = 'Kontrollen utförd OK - Inga varningar att rapportera.';
$_lang["configcheck_register_globals"] = 'register_globals är satt till ON i din php.ini konfigurationsfil';
$_lang["configcheck_register_globals_msg"] = 'Denna konfiguration gör din webbplats betydligt mer sårbar för så kallade serveröverskridande scriptattacker (Cross Site Scripting eller XSS). Du bör ta kontakt med din webbhost och ta reda på vad du kan göra för att stänga av den här inställningen.';
$_lang["configcheck_title"] = 'Konfigurationskontroll';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Din webbplats otillåten-sida är inte publicerad eller existerar inte.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'Detta betyder att din otillåten-sida inte är tillgänglig eller att den inte existerar. Det här kan leda till att ett tillstånd med upprepande loopar skapas och ger upphov till att många fel rapporteras i webbplatsens loggar. Kontrollera att inga webbanvändargrupper är anslutna till sidan.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'Den otillåten-sida som angetts i inställningarna är inte publicerad.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'Detta betyder att din otillåten-sida är oåtkomlig för allmänheten. Publicera sidan eller kontrollera under Verktyg &gt; Konfiguration att den refererade sidan är ett existerande dokument i webbplatsens dokumentträd.';
$_lang["configcheck_warning"] = 'Konfigurationsvarning:';
$_lang["configcheck_what"] = 'Vad betyder det här?';
$_lang["confirm_block"] = 'Är du säker på att du vill blockera denna användare?';
$_lang["confirm_delete_document"] = 'Är du säker på att du vill ta bort detta dokument?\nEventuella underdokument kommer också att tas bort.';
$_lang["confirm_delete_eventlog"] = 'Är du säker på att du vill ta bort den här händelseloggen?';
$_lang["confirm_delete_file"] = 'Är du säker på att du vill ta bort filen?\n\nDetta kan göra att din webbplats slutar fungera! Ta endast bort denna fil om du vet säkert att du inte förstör något.';
$_lang["confirm_delete_htmlsnippet"] = 'Är du säker på att du vill ta bort denna chunk?';
$_lang["confirm_delete_keywords"] = 'Är du säker på att du vill ta bort dessa nyckelord?';
$_lang["confirm_delete_module"] = 'Är du säker på att du vill ta bort den här modulen?';
$_lang["confirm_delete_plugin"] = 'Är du säker på att du vill ta bort denna plugin?';
$_lang["confirm_delete_record"] = 'Är du säker på att du vill ta bort de valda posterna?';
$_lang["confirm_delete_role"] = 'Är du säker på att du vill ta bort denna roll?';
$_lang["confirm_delete_snippet"] = 'Är du säker på att du vill ta bort denna snippet?';
$_lang["confirm_delete_tags"] = 'Är du säker på att du vill ta bort de valda META-taggarna?';
$_lang["confirm_delete_template"] = 'Vill du verkligen ta bort mallen?';
$_lang["confirm_delete_tmplvars"] = 'Är du säker på att du vill ta bort denna mallvariabel och alla dess lagrade värden?';
$_lang["confirm_delete_user"] = 'Vill du verkligen ta bort denna användare?';
$_lang["confirm_duplicate_document"] = 'Är du säker på att du vill duplicera detta dokument?\nEventuella underdokument som det innehåller kommer också att dupliceras.';
$_lang["confirm_duplicate_record"] = 'Är du säker på att du vill duplicera denna post?';
$_lang["confirm_empty_trash"] = 'Detta kommer att permanent radera ALLA borttagna dokument!\n\nFortsätt?';
$_lang["confirm_load_depends"] = 'Är du säker på att du vill ladda skärmen \'Hantera beroenden\' utan att spara dina ändringar?';
$_lang["confirm_name_change"] = 'Ändring av användarnamnet kan påverka andra program som är länkade till innehållshanteraren. \n\n Är du säker på att du vill ändra detta användarnamnet?';
$_lang["confirm_publish"] = '\n\nOm du publicerar detta dokument nu, kommer alla eventuella (av)publiceringsdatum att tas bort. Om du vill behålla eller ändra (av)publiceringsdatum, välj att \'redigera\' dokumentet istället.\n\nFortsätt?';
$_lang["confirm_remove_locks"] = 'Ibland stänger användare sin webbläsare medan de redigerar dokument, mallar, snippets eller tolkar, vilket kan lämna dokumentet i fråga i ett låst tillstånd. Genom att trycka OK, tar du bort ALLA nuvarande låsningar.\n\nFortsätt?';
$_lang["confirm_unblock"] = 'Är du säker på att du vill avblockera denna användare?';
$_lang["confirm_undelete"] = '\n\nEventuella underdokument som togs bort samtidigt som detta dokument kommer också att återställas, men underdokument som tagits bort tidigare kommer fortfarande att vara borttagna.';
$_lang["confirm_unpublish"] = '\n\nOm du avpublicerar detta dokument nu, kommer alla eventuella (av)publiceringsdatum att tas bort. Om du vill behålla eller ändra (av)publiceringsdatum, välj att \'redigera\' dokumentet istället.\n\nFortsätt?';
$_lang["confirm_unzip_file"] = 'Är du säker på att du vill zippa upp denna fil?\n\nExisterande filer kommer att skrivas över.';
$_lang["could_not_find_user"] = 'Kunde inte hitta användaren';
$_lang["create_document_here"] = 'Skapa dokument här';
$_lang["create_folder_here"] = 'Skapa mapp här';
$_lang["create_weblink_here"] = 'Skapa webblänk här';
$_lang["createdon"] = 'Skapat datum';
$_lang["credits"] = 'Erkännanden';
$_lang["credits_dTree"] = 'MODx använder det utmärkta dTree-scriptet från DestroyDrop.com!';
$_lang["credits_everaldo"] = 'MODx använder ett antal ikoner från Everaldos Crystal-samling. Toppenikoner!';
$_lang["credits_mysql"] = 'MODx använder MySQL!';
$_lang["credits_php"] = 'MODx använder PHP!';
$_lang["credits_shouts_msg"] = '<ul><li><b>Raymond Irving, Ryan Thrash</b> - Projektets grundare</li><li><b>Jason Coward, Victor Brilon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</b> - Inre arkitektur &amp; Design</li></ul>';
$_lang["credits_shouts_title"] = '<b>Stort tack till:</b>';
$_lang["credits_webfx"] = 'MODx använder ett antal javascript från Webfx. Fina grejer!';
$_lang["custom_contenttype_message"] = 'Här kan du lägga till egna innehållstyper som kan användas i dina dokument. Skriv in innehållstypen i det övre fältet och klicka på "Lägg till" för att lägga till en ny. Markera den innehållstyp i det nedre fältet som du vill ta bort och klicka på "Ta bort".';
$_lang["custom_contenttype_title"] = 'Egna innehållstyper';
$_lang["database_name"] = 'Databasens namn'; 
$_lang["database_overhead"] = '<b style=\'color:#990033\'>Notera:</b><br />"Overhead" är oanvänt utrymme reserverat av MySQL. Klicka på ett overhead-belopp för att frigöra utrymmet.';
$_lang["database_server"] = 'Databasens server';
$_lang["database_table_clickhere"] = 'Klicka här';
$_lang["database_table_clickbackup"] = 'för att säkerhetskopiera och ladda ner de valda tabellerna.';
$_lang["database_table_datasize"] = 'Datastorlek';
$_lang["database_table_droptablestatements"] = 'Generera DROP TABLE kommando.';
$_lang["database_table_effectivesize"] = 'Effektiv storlek';
$_lang["database_table_indexsize"] = 'Indexstorlek';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Poster';
$_lang["database_table_tablename"] = 'Tabellnamn';
$_lang["database_table_totalsize"] = 'Total storlek';
$_lang["database_table_totals"] = 'Totalt:';
$_lang["database_tables"] = 'Databasens tabeller';
$_lang["date"] = 'Datum';
$_lang["datechanged"] = 'Ändrat datum';
$_lang["defaultcache_message"] = 'Välj "Ja" för att göra alla nya dokument cachebara som standard.';
$_lang["defaultcache_title"] = 'Cachebara som standard';
$_lang["defaultmenuindex_message"] = 'Välj "Ja" för att aktivera automatisk ökning av menyindex som standard.';
$_lang["defaultmenuindex_title"] = 'Standardvärde för menyindexering';
$_lang["defaultpublish_message"] = 'Välj "Ja" för att göra alla nya dokument publicerade som standard.';
$_lang["defaultpublish_title"] = 'Publicerade som standard';
$_lang["defaultsearch_message"] = 'Välj "Ja" för att göra alla nya dokument sökbara som standard.';
$_lang["defaultsearch_title"] = 'Sökbara som standard';
$_lang["defaulttemplate_message"] = 'Välj den standarmall du vill använda för nya dokument. Du kan fortfarande välja en annan mall när du redigerar dokumentet. Denna inställning är bara förvalet.';
$_lang["defaulttemplate_title"] = 'Standardmall';
$_lang["delete"] = 'Ta bort';
$_lang["delete_document"] = 'Ta bort dokument';
$_lang["delete_tags"] = 'Ta bort taggar';
$_lang["deleting_file"] = 'Tar bort filen `%s`: ';
$_lang["description"] = 'Beskrivning';
$_lang["deselect_keywords"] = 'Rensa nyckelord';
$_lang["deselect_metatags"] = 'Rensa META-taggar';
$_lang["disabled"] = 'Avstängd';
$_lang["doc_data_title"] = 'Visa dokumentdata';
$_lang["document"] = 'Dokument';
$_lang["document_alias"] = 'Dokumentets&nbsp;alias';
$_lang["document_alias_help"] = 'Här kan du ange ett alias för dokumentet. Detta gör dokumentet nåbart genom: \n\nhttp://dinserver/alias\n\nDetta fungerar endast om du använder vänliga adresser.';
$_lang["document_content"] = 'Dokumentinnehåll';
$_lang["document_description"] = 'Beskrivning';
$_lang["document_description_help"] = 'Du kan skriva en valfri beskrivning av dokumentet här.';
$_lang["document_long_title_help"] = 'Här kan du skriva in en längre titel för ditt dokument. Detta är bra för sökmotorer, och kan bättre beskriva ditt dokumentet.';
$_lang["document_metatag_help"] = 'Välj de META-taggar och nyckelord som du vill knyta till det här dokumentet. Håll ner Ctrl för att välja flera nyckelord eller META-taggar.';
$_lang["document_opt_contentdispo"] = 'Innehållsdisposition';
$_lang["document_opt_contentdispo_help"] = 'Använd innehållsdispositionsfältet för att specificera hur det här dokumentet ska hanteras av webbläsaren. För filnedladdningar väljer du inställningen \'Bifogad fil\'.';
$_lang["document_opt_emptycache"] = 'Töm cachen';
$_lang["document_opt_emptycache_help"] = 'Lämnar du detta fält markerat, kommer MODx att tömma sin cache när du sparar dokumentet. Det gör att dina besökare inte kommer att se en gammal version av dokumentet.';
$_lang["document_opt_folder"] = 'Behållare?';
$_lang["document_opt_folder_help"] = 'Markera här om dokumentet ska agera behållare till andra dokument. En \'behållare\' är som en mapp, men den kan också själv ha ett innehåll.';
$_lang["document_opt_menu_index"] = 'Menyindex';
$_lang["document_opt_menu_index_help"] = 'Menyindex är ett fält du kan använda för att sortera dokument i din snippet som bygger menyn. Du kan också använda det för andra ändamål i dina snippets.';
$_lang["document_opt_menu_title"] = 'Menytitel';
$_lang["document_opt_menu_title_help"] = 'Menytitel är ett fält du kan använda för att visa en kort titel för dokumentet i dina menysnippets eller moduler.';
$_lang["document_opt_published"] = 'Publicerad';
$_lang["document_opt_published_help"] = 'Markera detta fält om dokumentet ska publiceras direkt när det sparas.';
$_lang["document_opt_richtext"] = 'Richtext';
$_lang["document_opt_richtext_help"] = 'Lämna denna ikryssad för att använda en richtext-editor till dokumentredigering. Om dina dokument innehåller javascript eller formulär, avmarkera denna för att redigera i HTML-läge så editorn inte stökar till i dina dokument.';
$_lang["document_opt_show_menu"] = 'Visa i meny';
$_lang["document_opt_show_menu_help"] = 'Välj den här inställningen för att visa dokumentet i en webbmeny. Notera att vissa menybyggarprogram kan välja att strunta i den här inställningen.';
$_lang["document_opt_trackvisit_help"] = 'Logga varje besökares besök på den här sidan';
$_lang["document_overview"] = 'Dokumentöversikt';
$_lang["document_parent"] = 'Dokumentförälder';
$_lang["document_parent_help"] = 'Klicka på ovanstående ikon för att sätta på (eller stänga av) föräldraval för detta dokument. Klicka sedan på ett dokument i dokumentträdet för att sätta det som ny förälder.';
$_lang["document_setting"] = 'Dokumentinställningar';
$_lang["document_summary"] = 'Sammanfattning';
$_lang["document_summary_help"] = 'Skriv en kort sammanfattning av dokumentet';
$_lang["document_title"] = 'Titel';
$_lang["document_title_help"] = 'Skriv namnet/titeln på dokumentet här. Försök att undvika omvända snedstreck i namnet!';
$_lang["document_to_be_moved"] = 'Dokumentet som ska flyttas';
$_lang["document_weblink_help"] = 'Ange adressen till objektet du vill referera till med denna webblänk.';
$_lang["documents_in_container"] = "dokument i den här behållaren";
$_lang["documents_in_container_no"] = "Den här behållaren har inga underdokument.";
$_lang["duplicate"] = 'Duplicera';
$_lang["duplicate_alias_found"] = 'Dokumentet \'%s\' använder redan aliaset \'%s\'. Ange ett unikt alias.';
$_lang["duplicate_alias_message"] = 'Här kan du välja "Ja" för att tillåta att aliasdubletter sparas.<br /><b>Notera: Den här inställningen bör användas med "Vänliga aliassökvägar" satt till "Ja" för att undvika problem med refereringen av dokument.</b>';
$_lang["duplicate_alias_title"] = 'Tillåt aliasdubletter';
$_lang["duplicate_document"] = 'Duplicera dokument';
$_lang["edit"] = 'Redigera';
$_lang["edit_document"] = 'Redigera dokument';
$_lang["edit_document_title"] = 'Skapa/redigera dokument';
$_lang["edit_settings"] = 'Konfiguration';
$_lang["editedon"] = 'Redigerat datum';
$_lang["editing_file"] = 'Redigerar fil: ';
$_lang["editor_css_path_message"] = 'Skriv in sökvägen till den CSS-fil du vill använda i editorn. Det bästa sättet att ange sökvägen är att göra det från serverns rot, tex /assets/site/style.css. Lämna fältet tomt om du inte vill ladda en stilmall i editorn.';
$_lang["editor_css_path_title"] = 'Sökväg till CSS-fil';
$_lang["email"] = 'Epost';
$_lang["email_sent"] = 'Epost skickad';
$_lang["emailsender_message"] = 'Här kan du ange epostadressen som används för att skicka användarnamn och lösenord till en användare.';
$_lang["emailsender_title"] = 'Epostadress';
$_lang["emailsubject_message"] = 'Här kan du ange ämnet för eposten som skickas.';
$_lang["emailsubject_title"] = 'Ämne för epost';
$_lang["empty_folder"] = 'Denna mapp är tom';
$_lang["empty_recycle_bin"] = 'Radera borttagna dokument';
$_lang["empty_recycle_bin_empty"] = 'Det finns inga borttagna dokument att radera.';
$_lang["enabled"] = 'Aktiverad';
$_lang["enable_resource"] = 'Använd resursfil.';
$_lang["enable_sharedparams"] = 'Använd parameterdelning';
$_lang["enable_sharedparams_msg"] = '<b>Notera:</b> Ovanstående globalt unika ID (GUID) kommer att användas för att unikt identifiera denna modul och dess delade parametrar. GUIDet används också för att länka mellan modulen och de plugins eller snippets som använder dess delade parametrar.';
$_lang["error"] = 'Fel';
$_lang["error_sending_email"] = 'Fel vid utskick av epost';
$_lang["errorpage_message"] = 'Skriv in ID till den sida du vill skicka användare till om de försöker komma åt ett dokument som inte finns.<br /><b>OBS: Se till att detta ID tillhör ett existerande dokument, och att det har blivit publicerat!</b>';
$_lang["errorpage_title"] = 'Felsida';
$_lang["event_id"] = 'Händelse-ID';
$_lang["eventlog"] = 'Händelselogg';
$_lang["eventlog_msg"] = 'Händelseloggen används för att visa informations-, varnings- och felmeddelanden genererade av informationshanteraren. Källkolumnen visar i vilken del av informationshanteraren händelsen inträffade.';
$_lang["eventlog_viewer"] = 'Systemhändelser';
$_lang["existing_category"] = 'Existerande kategori';
$_lang["expand_tree"] = 'Veckla ut träd';
$_lang["export_site"] = 'Exportera statisk HTML';
$_lang["export_site_cacheable"] = 'Inkludera&nbsp;icke<br />cachebara&nbsp;filer';
$_lang["export_site_exporting_document"] = 'Exporterar fil <b>%s</b> av <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style="color:#990000">Misslyckades!</span>';
$_lang["export_site_html"] = 'Exportera webbplatsen till HTML';
$_lang["export_site_maxtime"] = 'Max exporttid';
$_lang["export_site_maxtime_message"] = 'Här kan du specificera antal sekunder som MODx har på sig att exportera webbplatsen (åsidosätter PHPs inställningar). Skriv 0 för obegränsad tid. Notera att om 0 eller ett väldigt högt nummer skrivs, kan det få din server att göra konstiga saker och rekommenderas därför inte.';
$_lang["export_site_message"] = 'Med denna funktion kan du exportera hela webbplatsen till HTML-filer. Kom ihåg att du förlorar stora delar av funktionaliteten i MODx om du gör det:<p /><ul><li>Sidläsningar på exporterade filer kommer inte att lagras.</li><li>Interaktiva snippets kommer inte att fungera i exporterade filer</li><li>Endast vanliga dokument kommer att exporteras. Webblänkar blir alltså inte exporterade.</li><li>Exportprocessen kan misslyckas om dina dokument innehåller snippets som skickar omdirigeringsanvisningar.</li><li>Beroende på hur du skrivit dina dokument, kan bilder och stilmallar få fel sökvägar. För att fixa detta, kan du spara eller flytta dina exporterade filer till samma katalog som index.php för MODx befinner sig i.</li></ul><p />Fyll i formuläret och tryck på "Starta export" för att starta exportprocessen. Filerna som skapas kommer att sparas där du specificerat, och när det är möjligt, används dokumentets alias som filnamn. När du ska exporterar din webbplats är det bäst att ha MODx  konfigurationsinställning "Vänliga alias" satt till "Ja". Beroende på storleken på din webbplats, kan exporten ta en del tid.<p /><b>Redan existerande filer kommer att skrivas över om de har samma namn som en exporterad fil!</b><p />';
$_lang["export_site_numberdocs"] = '<b>Hittade %s dokument att exportera...</b><p/>';
$_lang["export_site_prefix"] = 'Filprefix';
$_lang["export_site_start"] = 'Starta export';
$_lang["export_site_success"] = '<span style="color:#009900">Klart!</span>';
$_lang["export_site_suffix"] = 'Filsuffix';
$_lang["export_site_target_unwritable"] = 'Målkatalogen är inte skrivbar. Se till att katalogen är skrivbar och försök igen.';
$_lang["export_site_time"] = 'Exporten avklarad. Exporten tog %s sekunder att göra.';
$_lang["failed_login_message"] = 'Här kan du ange hur många misslyckade inloggningsförsök som är tillåtet innan användaren blockeras.';
$_lang["failed_login_title"] = 'Misslyckade inloggningsförsök';
$_lang["fe_editor_lang_message"] = 'Här kan du ange språk för editorn som används.';
$_lang["fe_editor_lang_title"] = 'Editorns språk';
$_lang["file_delete_file"] = 'Ta bort fil';
$_lang["file_delete_folder"] = 'Ta bort mapp';
$_lang["file_deleted"] = 'Klart!';
$_lang["file_download_file"] = 'Ladda ner fil';
$_lang["file_download_unzip"] = 'Zippa upp fil';
$_lang["file_folder_chmod_error"] = 'Kunde inte ändra behörigheterna. Du måste själv ändra behörigheterna utanför MODx.';
$_lang["file_folder_created"] = 'Katalog skapad!';
$_lang["file_folder_deleted"] = 'Katalogen togs bort utan problem!';
$_lang["file_folder_not_created"] = 'Kunde inte skapa katalog';
$_lang["file_folder_not_deleted"] = 'Kunde inte ta bort katalogen. Se till att den är tom innan borttagning sker!';
$_lang["file_not_deleted"] = 'Misslyckades!';
$_lang["file_not_saved"] = 'Kan inte spara filen. Kontrollera att målkatalogen är skrivbar!';
$_lang["file_saved"] = 'Filen uppdaterades utan problem!';
$_lang["file_unzip"] = 'Uppzippningen klar!';
$_lang["file_unzip_fail"] = 'Uppzippningen misslyckades!';
$_lang["filemanager_path_message"] = 'IIS fyller oftast inte i inställningarna för document_root ordentligt, vilket används av filhanteraren för att bestämma vad du får se. Om du har problem med filhanteraren, se till så att denna katalog pekar till roten på din installation av MODx.';
$_lang["filemanager_path_title"] = 'Sökväg till filhanteraren';
$_lang["files_access_denied"] = 'Åtkomst nekad!';
$_lang["files_data"] = 'Data';
$_lang["files_dir_listing"] = 'Kataloglista för: ';
$_lang["files_directories"] = 'Kataloger';
$_lang["files_dirwritable"] = 'Är katalogen skrivbar?';
$_lang["files_editfile"] = 'Redigera fil';
$_lang["files_file_type"] = 'Filtyp: ';
$_lang["files_filename"] = 'Filnamn';
$_lang["files_fileoptions"] = 'Alternativ';
$_lang["files_files"] = 'Filer';
$_lang["files_filesize"] = 'Filstorlek';
$_lang["files_filetype_notok"] = 'Det är inte tillåtet att ladda upp denna typ av fil!';
$_lang["files_modified"] = 'Ändrad';
$_lang["files_title"] = 'Filhanterare';
$_lang["files_top_level"] = 'Till toppnivån';
$_lang["files_up_level"] = 'Upp en nivå';
$_lang["files_upload_copyfailed"] = 'Kunde inte kopiera filen till målkatalogen - uppladdningen misslyckades!';
$_lang["files_upload_error"] = 'Fel';
$_lang["files_upload_error0"] = 'Ett fel uppstod med din uppladdning.';
$_lang["files_upload_error1"] = 'Filen du försöker ladda upp är för stor.';
$_lang["files_upload_error2"] = 'Filen du försöker ladda upp är för stor.';
$_lang["files_upload_error3"] = 'Filen du försöker ladda upp blev endast delvis uppladdad.';
$_lang["files_upload_error4"] = 'Du måste välja en fil att ladda upp.';
$_lang["files_upload_error5"] = 'Ett fel uppstod med din uppladdning.';
$_lang["files_upload_inhibited_msg"] = '<b>Uppladdning nekad</b> - se till att uppladdningar stöds och att PHP har skrivrättigheter i den aktuella katalogen.<br />';
$_lang["files_upload_ok"] = 'Filen laddades upp korrekt!';
$_lang["files_uploadfile"] = 'Ladda upp fil';
$_lang["files_uploadfile_msg"] = 'Välj en fil att ladda upp:';
$_lang["files_uploading"] = 'Laddar upp <b>%s</b> till <b>%s/</b><br />';
$_lang["files_viewfile"] = 'Visa fil';
$_lang["folder"] = 'Mapp';
$_lang["forgot_password_email_fine_print"] = '* URLen ovan upphör att fungera när du ändrat ditt lösenord eller när denna dag är slut.';
$_lang["forgot_password_email_instructions"] = 'Härifrån kommer du att kunna ändra ditt lösenord via menyn Mitt konto.';
$_lang["forgot_password_email_intro"] = 'En förfrågan om att ändra ditt kontos lösenord har gjorts.';
$_lang["forgot_password_email_link"] = 'Klicka här för att fullborda processen.';
$_lang["forgot_your_password"] = 'Glömt ditt lösenord?';
$_lang["friday"] = 'Fredag';
$_lang["friendly_alias_message"] = 'Om du använder vänliga adresser och dokumentet har ett alias, kommer aliaset alltid att prioriteras i den vänliga adressen. Genom att sätta detta alternativ till "Ja", kommer den vänliga adressens prefix och suffix att läggas till aliaset.<br />Exempel: om ditt dokument med ID 1 har aliaset "introduktion", prefixet är satt till "", suffixet till ".html" och du sätter denna inställning till "Ja", så kommer "introduktion.html" att visas. Om det inte finns något alias, kommer MODx att generera länken "1.html".';
$_lang["friendly_alias_title"] = 'Använd vänliga alias';
$_lang["friendlyurls_message"] = 'Detta låter dig använda adresser som är vänliga mot sökmotorer. Notera att detta endast fungerar när MODx körs på Apache, och du måste skriva en .htaccess-fil för att det ska fungera. Se .htaccess-filen som följde med i distributionen för mer information.';
$_lang["friendlyurls_title"] = 'Använd vänliga adresser';
$_lang["friendlyurlsprefix_message"] = 'Här specificerar du prefixet som ska användas för vänliga adresser. Om exempelvis prefixet "sida" sätts, kommer adressen /index.php?id=2 att konverteras till /sida2.html (om suffixet är satt till .html). På detta sätt kan du specificera vad dina användare (och sökmotorerna) ser för länkar på din sida.';
$_lang["friendlyurlsprefix_title"] = 'Prefix för vänliga adresser';
$_lang["friendlyurlsuffix_message"] = 'Här anger du suffix för vänliga adresser. Specificerar du ".html" kommer .html att läggas till på alla dina vänliga adresser.';
$_lang["friendlyurlsuffix_title"] = 'Suffix för vänliga adresser';
$_lang["functionnotimpl"] = 'Ursäkta!';
$_lang["functionnotimpl_message"] = 'Denna funktion har inte implementerats än.';
$_lang["go"] = 'Utför';
$_lang["group_access_permissions"] = 'Användargruppsåtkomst';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Hjälp';
$_lang["help_msg"] = '<p>Besök <a href="http://modxcms.com/forums/" target="_blank">MODx Forum</a> om du behöver hjälp med MODx. Där finns också en växande mängd <a href="http://modxcms.com/documentation" target="blank">dokumentation och guider</a> som berör i stort sett alla aspekter av MODx.</p><p>Vi planerar också att erbjuda kommersiella supporttjänster. Sänd oss ett <a href="mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry">epostmeddelande om du är intresserad</a>.</p>';
$_lang["help_title"] = 'Hjälp';
$_lang["hide_tree"] = 'Dölj träd';
$_lang["home"] = 'Hem';
$_lang["htmlsnippet_desc"] = 'Beskrivning';
$_lang["htmlsnippet_management_msg"] = 'Här kan du skapa nya chunks eller välja en redan befintlig för redigering.';
$_lang["htmlsnippet_msg"] = 'Här kan du skapa och redigera chunks. Kom ihåg att chunks är "rå" HTML-kod, så ingen PHP-kod kommer att tolkas.';
$_lang["htmlsnippet_name"] = 'Namn på chunk';
$_lang["htmlsnippet_title"] = 'Skapa/redigera chunk';
$_lang["icon"] = 'Ikon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Föräldratilldelning:\n\nDokumentet är ett barn till det valda dokumentet.';
$_lang["illegal_parent_self"] = 'Föräldratilldelning:\n\nDet valda dokumentet kan inte bli tilldelat sig själv.';
$_lang["import_files_found"] = '<b>Hittade %s dokument för import...</b><p/>';
$_lang["import_params"] = 'Importera en moduls delade parametrar';
$_lang["import_params_msg"] = 'Du kan importera parametrarna eller inställningarna av en modul genom att välja modulens namn i ovanstående meny.<br /><b>Notera:</b> För att moduler ska synas i menyn måste denna plugin/snippeten vara med i modulens beroendelista och modulen måste vara inställd för parameterdelning.';
$_lang["import_parent_document"] = 'Föräldrardokument';
$_lang["import_site"] = 'Importera HTML';
$_lang["import_site_failed"] = '<span style="color:#990000">Misslyckades!</span>';
$_lang["import_site_html"] = 'Importera webbplats från HTML';
$_lang["import_site_importing_document"] = 'Importerar fil <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Max importtid';
$_lang["import_site_maxtime_message"] = 'Här kan du specificera antal sekunder som innehållshanteraren får ta i anspråk när den importerar sidan (åsidosätter PHPs inställningar). Skriv 0 för obegränsad tid. Notera att om 0 eller ett väldigt stort nummer används, kan skumma saker hända din server, och rekommenderas därför inte.';
$_lang["import_site_message"] = 'Med denna funktion kan du importera en hel HTML-webbplats till databasen. Notera att du måste kopiera dina html-filer och kataloger till assets/import-katalogen.<p />Fyll i formuläret och klicka på "Starta import" för att starta importprocessen. Filerna som importeras kommer att sparas till den valda platsen, och där det är möjligt kommer filnamnet att användas som dokumentets alias, och sidtiteln som dokumentets titel.';
$_lang["import_site_skip"] = '<span style="color:#990000">Hoppade över!</span>';
$_lang["import_site_start"] = 'Starta import';
$_lang["import_site_success"] = '<span style="color:#009900">Klart!</span>';
$_lang["import_site_time"] = 'Importen avklarad. Importen tog %s sekunder att göra.';
$_lang["inbox"] = 'Inkorg';
$_lang["info"] = 'Information';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Inline';
$_lang["insert"] = 'Infoga';
$_lang["insert_snippet"] = 'Infoga snippeten i dokumentet';
$_lang["keyword"] = 'Nyckelord';
$_lang["keywords"] = 'Nyckelord';
$_lang["keywords_intro"] = 'För att ändra ett nyckelord skriver du helt enkelt in det nya nyckelordet i fältet bredvid nyckelordet du vill ändra. Bocka för "Ta bort" för det nyckelord du vill ta bort. Om du bockar för "Ta bort" och dessutom ändrar nyckelordets namn, så kommer namnändringen inte att ske eftersom nyckelordet tas bort!';
$_lang["language_message"] = 'Välj vilket språket du vill använda i MODx publiceringshanterare.';
$_lang["language_title"] = 'Språk';
$_lang["launch_site"] = 'Visa webbplatsen';
$_lang["link_attributes"] = 'Länkattribut';
$_lang["link_attributes_help"] = 'Här kan du ange attribut för denna sidas länk, t.ex. target= eller rel=.';
$_lang["list_mode"] = 'Sätt på/av listläget - används för att lista alla poster i tabellen.';
$_lang["loading_doc_tree"] = 'Laddar dokumentträd...';
$_lang["loading_menu"] = 'Laddar meny...';
$_lang["loading_page"] = 'Vänta medan MODx laddar sidan...';
$_lang["lock_htmlsnippet"] = 'Lås chunk för redigering';
$_lang["lock_htmlsnippet_msg"] = 'Endast administratörer (roll-ID 1) kan redigera denna chunk.';
$_lang["lock_module"] = 'Lås modulen för redigering';
$_lang["lock_module_msg"] = 'Endast administratörer (roll-ID 1) kan redigera den här modulen.';
$_lang["lock_msg"] = '%s redigerar just nu den/det här %s. Vänta tills han eller hon är klar och försök sedan igen.';
$_lang["lock_plugin"] = 'Lås plugin för redigering';
$_lang["lock_plugin_msg"] = 'Endast administratörer (roll-ID 1) kan redigera denna plugin.';
$_lang["lock_settings_msg"] = '%s redigerar just nu de här inställningarna. Vänta tills han eller hon är klar och försök sedan igen.';
$_lang["lock_snippet"] = 'Lås snippeten för redigering';
$_lang["lock_snippet_msg"] = 'Endast administratörer (roll-ID 1) kan redigera denna snippet.';
$_lang["lock_template"] = 'Lås mall för redigering';
$_lang["lock_template_msg"] = 'Endast administratörer (roll-ID 1) kan redigera denna mall.';
$_lang["lock_tmplvars"] = 'Lås variabel för redigering';
$_lang["lock_tmplvars_msg"] = 'Endast administratörer (roll-ID 1) kan redigera denna variabel.';
$_lang["localtime"] = 'Lokal tid';
$_lang["locked"] = 'Låst';
$_lang["login_allowed_days"] = 'Tillåtna dagar';
$_lang["login_allowed_days_message"] = 'Välj de dagar som den här användaren får logga in.';
$_lang["login_allowed_ip"] = 'Tillåten IP-adress';
$_lang["login_allowed_ip_message"] = 'Ange de IP-adresser som den här användaren får logga in från.<br /><b>Notera: Separera flera IP-adresser med kommatecken (,)</b>';
$_lang["login_button"] = 'Logga in';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">Installation/uppdatering av den här webbplatsen pågår.<br />Försök igen om ett par minuter!</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">Installationen/uppdateringen av den här webbplatsen är klar. Nu kan du logga in igen!</span><br />';
$_lang["login_captcha_message"] = 'Skriv in säkerhetskoden som visas i bilden. Om du har problem att läsa koden, så kan du klicka på bilden för att generera en ny kod eller kontakta din webmaster.';
$_lang["login_homepage"] = 'Startsida efter inloggning';
$_lang["login_homepage_message"] = 'Ange ID till det dokument du vill skicka användaren till efter den har loggat in.<br /><b>OBS: Se till att det ID du skrivit in tillhör ett existerande dokument, att det har blivit publicerat och kan kommas åt av användaren!</b>';
$_lang["login_message"] = 'Fyll i dina inloggningsuppgifter för att starta din session. Det är skillnad mellan stora och små bokstäver i ditt användarnamn och lösenord.';
$_lang["logo_slogan"] = 'Skapa och gör mer med mindre - \nMODx innehållshanterare';
$_lang["logout"] = 'Logga ut';
$_lang["long_title"] = 'Lång titel';
$_lang["mail_check_timeperiod_message"] = 'Anger hur ofta systemet kontrollerar om ny epost inkommit till hanteraren, i sekunder.';
$_lang["mail_check_timeperiod_title"] = 'Periodicitet för kontroll av inkorg';
$_lang["manage_depends"] = 'Hantera beroenden';
$_lang["manage_files"] = 'Hantera filer';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manage_metatags"] = 'Hantera META-taggar och nyckelord';
$_lang["manage_modules"] = 'Hantera moduler';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Mallar';
$_lang["manager"] = 'Hanterare';
$_lang["manager_direction_message"] = 'Välj textriktning i hanteraren: antingen vänster-till-höger eller höger-till-vänster.';
$_lang["manager_direction_title"] = 'Textriktning i hanteraren';
$_lang["manager_lang_attribute_message"] = 'Ange den språkkod som bäst överensstämmer med din språkinställning för hanteraren. Det här säkerställer att webbläsare kan presentera innehållet i det bästa formatet för dig.';
$_lang["manager_lang_attribute_title"] = 'Hanterarens språkattribut<br />för HTML och XML';
$_lang["manager_lockout_message"] = 'Du är för närvarande inloggad i innehållshanteraren. Klicka på "Logga ut" om du vill stänga din session. <p />Klicka på "Hem"-knappen om du vill gå till din start eller hemsida.';
$_lang["manager_permissions"] = 'Rättigheter för hanteraren';
$_lang["manager_theme"] = 'Tema för hanteraren';
$_lang["manager_theme_message"] = 'Välj tema för innehållshanteraren.';
$_lang["messages"] = 'Meddelanden';
$_lang["messages_all"] = 'Alla';
$_lang["messages_compose"] = 'Skapa ett meddelande';
$_lang["messages_forward"] = 'Vidarebefordra';
$_lang["messages_from"] = 'Från';
$_lang["messages_group"] = 'En grupp';
$_lang["messages_inbox"] = 'Inkorg';
$_lang["messages_message"] = 'Meddelande';
$_lang["messages_no_messages"] = 'Inga meddelanden i Inkorgen.';
$_lang["messages_not_allowed_to_read"] = 'Du har inte behörighet att läsa detta meddelande!';
$_lang["messages_private"] = 'Privat';
$_lang["messages_read_message"] = 'Läs meddelande';
$_lang["messages_reply"] = 'Svara';
$_lang["messages_select_group"] = 'Välj en grupp';
$_lang["messages_select_user"] = 'Välj en användare';
$_lang["messages_send"] = 'Skicka';
$_lang["messages_send_to"] = 'Skicka till';
$_lang["messages_sent"] = 'Skickat';
$_lang["messages_subject"] = 'Ämne';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Meddelanden';
$_lang["messages_user"] = 'En användare';
$_lang["meta_keywords"] = 'META-nyckelord';
$_lang["metatag_intro"] = 'På den här sidan kan du skapa, redigera eller ta bort META-taggar. För att länka META-taggar till dokument klickar du på fliken för META-nyckelord när du redigerar dokumentet och väljer de önskade META-taggarna och nyckelorden. Om du vill lägga in en ny tagg skriver du in namnet och värdet och klickar på "Lägg till tagg". Klicka på taggens namn i tabellen för att redigera den.';
$_lang["metatag_notice"] = 'Använd <a href="http://www.html-reference.com/META.htm" target="_blank">HTML-referensguiden</a> för att få mer information. Det här är inte en komplett lista med möjliga META-taggar.';
$_lang["metatags"] = 'META-taggar';
$_lang["metatags_and_keywords"] = 'META-taggar och nyckelord';
$_lang["mgr_access_permissions"] = 'Åtkomsträttigheter i hanteraren';
$_lang["mgr_login_start"] = 'Startsida efter inloggning i hanteraren';
$_lang["mgr_login_start_message"] = 'Ange ID för det dokument du vill att användaren ska komma till när den loggat in i hanteraren.<br /><b>Notera: Kontrollera att det ID du valt hör till ett existerande dokument, att det är publicerat och att användaren har behörighet för det!</b>';
$_lang["mgrlog_action"] = 'Händelse';
$_lang["mgrlog_actionid"] = 'Händelse-ID';
$_lang["mgrlog_anyall"] = 'Alla';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() returnerade false.';
$_lang["mgrlog_datefr"] = 'Datum fr o m';
$_lang["mgrlog_dateinvalid"] = 'Ogiltigt datumformat.';
$_lang["mgrlog_dateto"] = 'Datum t o m';
$_lang["mgrlog_emptysrch"] = 'Din sökning gav inga träffar (dvs inga matchande loggdata hittades).';
$_lang["mgrlog_field"] = 'Fält';
$_lang["mgrlog_itemid"] = 'Objekt-ID';
$_lang["mgrlog_itemname"] = 'Objektnamn';
$_lang["mgrlog_msg"] = 'Meddelande';
$_lang["mgrlog_noquery"] = 'Du har inte angivit någon sökfras.';
$_lang["mgrlog_query_msg"] = 'Välj ut vad du vill läsa i loggen. Du kan välja loggposter efter datum, men var medveten om att datumen du anger inte är inkluderande - för att välja alla loggposter för 01-01-2006 så anger du "Datum fr&nbsp;o&nbsp;m" till 01-01-2006 och "Datum t&nbsp;o&nbsp;m" till 02-01-2006.<br /><br />Meddelande och händelse är vanligen samma sak. Om du söker efter ett specifikt meddelande är det bäst att ange händelsen till "Alla".';
$_lang["mgrlog_results"] = 'Antal träffar';
$_lang["mgrlog_qresults"] = 'Sökresultat';
$_lang["mgrlog_searchlogs"] = 'Sök i loggen';
$_lang["mgrlog_sortinst"] = 'Du kan sortera tabellen genom att klicka på kolumnrubrikerna. Om loggen börjar bli för stor kan du <a href="index.php?a=55">tömma</a> den. Detta kommer att ta bort alla loggposter fram till nu och kan inte ångras.';
$_lang["mgrlog_query"] = 'Sök i loggen';
$_lang["mgrlog_time"] = 'Tid';
$_lang["mgrlog_user"] = 'Användare';
$_lang["mgrlog_username"] = 'Användarnamn';
$_lang["mgrlog_value"] = 'Värde';
$_lang["mgrlog_view"] = 'Visa loggen för hanteraren';
$_lang["module_code"] = 'Modul-kod (php)';
$_lang["module_config"] = 'Modulinställningar';
$_lang["module_desc"] = 'Beskrivning';
$_lang["module_disabled"] = 'Modulen avstängd';
$_lang["module_edit_click_title"] = 'Klicka här för att redigera den här modulen';
$_lang["module_group_access_msg"] = 'Välj de användargrupper som har tillstånd att köra den här modulen innifrån innehållshanteraren.';
$_lang["module_management"] = 'Hantera moduler';
$_lang["module_management_msg"] = 'Här kan du välja den modul du vill köra eller ändra. Klicka på ikonen i tabellen för att köra modulen. Klicka på modulnamnet för att redigera modulen.';
$_lang["module_msg"] = 'Här kan du lägga till och redigera moduler. En modul är en samling resurser (dvs plugins, snippets etc).';
$_lang["module_name"] = 'Modulnamn';
$_lang["module_resource_msg"] = 'Här kan du lägga till eller ta bort resurser som den här modulen är beroende av. Klicka på en av \'Lägg till\'-knapparna nedan för att lägga till en ny resurs.';
$_lang["module_resource_title"] = 'Modulberoenden';
$_lang["module_title"] = 'Skapa/redigera modul';
$_lang["module_viewdepend_msg"] = 'Här kan du se vilka resurser modulen är beroende av. Klicka på knappen "Hantera beroenden" för att ändra beroendena.';
$_lang["modules"] = 'Moduler';
$_lang["modx_version"] = 'MODx-version';
$_lang["monday"] = 'Måndag';
$_lang["move"] = 'Flytta';
$_lang["move_document"] = 'Flytta dokument';
$_lang["move_document_message"] = 'Du kan flytta ett dokument och alla dess underdokument genom att välja en ny förälder i trädet. Om du väljer ett dokument som inte redan är en behållare, kommer det att ändras till en. Klicka på den nya föräldern i trädet.';
$_lang["move_document_new_parent"] = 'Välj en ny förälder i dokumentträdet.';
$_lang["move_document_title"] = 'Flytta dokument';
$_lang["name"] = 'Namn';
$_lang["new_category"] = 'Ny kategori';
$_lang["new_file_permissions_message"] = 'När en ny fil laddas upp med Filhanteraren, kommer Filhanteraren att försöka ändra filbehörigheterna till dom som anges i denna inställning. Det här kanske inte fungerar på alla system, t&nbsp;ex IIS, i vilket fall du blir tvungen att ändra behörigheterna manuellt.';
$_lang["new_file_permissions_title"] = 'Behörigheter för nya filer';
$_lang["new_folder_permissions_message"] = 'När en ny mapp skapas i Filhanteraren, kommer Filhanteraren att försöka ändra mappbehörigheterna till dom som anges i denna inställning. Det här kanske inte fungerar på alla system, t&nbsp;ex IIS, i vilket fall du blir tvungen att ändra behörigheterna manuellt.';
$_lang["new_folder_permissions_title"] = 'Behörigheter för nya mappar';
$_lang["new_htmlsnippet"] = 'Ny chunk';
$_lang["new_keyword"] = 'Lägg till nytt nyckelord:';
$_lang["new_module"] = 'Ny modul';
$_lang["new_parent"] = 'Ny förälder';
$_lang["new_plugin"] = 'Ny plugin';
$_lang["new_role"] = 'Skapa en ny roll';
$_lang["new_snippet"] = 'Ny snippet';
$_lang["new_template"] = 'Ny mall';
$_lang["new_tmplvars"] = 'Ny mallvariabel';
$_lang["new_user"] = 'Ny användare';
$_lang["new_web_user"] = 'Ny webbanvändare';
$_lang["no"] = 'Nej';
$_lang["no_activity_message"] = 'Du har ännu inte skapat eller redigerat några dokument.';
$_lang["no_category"] = 'okategoriserade';
$_lang["no_docs_pending_publishing"] = 'Inga dokument väntar på publicering.';
$_lang["no_docs_pending_pubunpub"] = 'Inga händelser funna';
$_lang["no_docs_pending_unpublishing"] = 'Inga dokument väntar på avpublicering.';
$_lang["no_groups_found"] = 'Inga grupper hittade.';
$_lang["no_keywords_found"] = 'Det finns inga nyckelord än.';
$_lang["no_records_found"] = 'Inga poster funna.';
$_lang["no_results"] = 'Inga resultat hittade';
$_lang["nologentries_message"] = 'Ange hur många loggposter som visas per sida när du utforskar granskningsloggen.';
$_lang["nologentries_title"] = 'Antal loggposter';
$_lang["nomessages_message"] = 'Ange hur många meddelanden som visas i inkorgen när meddelanden visas.';
$_lang["nomessages_title"] = 'Antal meddelanden';
$_lang["none"] = 'Ingen';
$_lang["noresults_message"] = 'Ange antalet resultat som visas när listningar och sökresultat presenteras.';
$_lang["noresults_title"] = 'Antal resultat';
$_lang["not_deleted"] = 'har inte tagits bort.';
$_lang["not_set"] = 'Inte satt';
$_lang["notset"] = 'Ej satt';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Handling';
$_lang["onlineusers_actionid"] = 'Handlings-ID';
$_lang["onlineusers_ipaddress"] = 'Användarens IP-adress';
$_lang["onlineusers_lasthit"] = 'Senaste träff';
$_lang["onlineusers_message"] = 'Denna lista visar alla användare som varit aktiva de senaste 20 minuterna (nuvarande tid är ';
$_lang["onlineusers_title"] = 'Inloggade användare';
$_lang["onlineusers_user"] = 'Användare';
$_lang["onlineusers_userid"] = 'Användarens ID';
$_lang["optimize_table"] = 'Klicka här för att optimera den här tabellen';
$_lang["page_data_cacheable"] = 'Cachebar';
$_lang["page_data_cacheable_help"] = 'Om detta fält lämnas markerat, kommer dokumentet att sparas i cachen. Se till att fältet är avmarkerat om ditt dokument innehåller snippets.';
$_lang["page_data_cached"] = '<b>Källa hämtad från cache:</b>';
$_lang["page_data_changes"] = 'Ändringar';
$_lang["page_data_contentType"] = 'Innehållstyp';
$_lang["page_data_contentType_help"] = 'Välj innehållstypen för detta dokument. Om du inte är säker på vilken innehållstyp dokumentet ska ha, låt den stå som text/html.';
$_lang["page_data_created"] = 'Skapad';
$_lang["page_data_edited"] = 'Redigerad';
$_lang["page_data_editor"] = 'Redigera med en richtext-editor';
$_lang["page_data_folder"] = 'Dokumentet är en behållare';
$_lang["page_data_general"] = 'Allmänt';
$_lang["page_data_markup"] = 'Uppmärkning/struktur';
$_lang["page_data_mgr_access"] = 'Åtkomst till hanteraren';
$_lang["page_data_notcached"] = 'Dokumentet har (ännu) inte blivit cachat.';
$_lang["page_data_publishdate"] = 'Publiceringsdatum';
$_lang["page_data_publishdate_help"] = 'Om du sätter ett publiceringsdatum, kommer dokumentet publiceras så snart som datumet är nått. Klicka på kalenderikonen för att välja ett datum, eller ikonen bredvid för att ta bort det. Om datumet tas bort, kommer dokumentet aldrig att publiceras automatiskt.';
$_lang["page_data_published"] = 'Publicerad';
$_lang["page_data_searchable"] = 'Sökbar';
$_lang["page_data_searchable_help"] = 'Om detta fält markeras, kommer dokumentet att bli sökbart. Du kan också använda det för andra ändamål i dina snippets.';
$_lang["page_data_source"] = 'Källa';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Använder mall';
$_lang["page_data_template_help"] = 'Här kan du välja vilken mall dokumentet ska använda.';
$_lang["page_data_title"] = 'Siddata';
$_lang["page_data_unpublishdate"] = 'Avpubliceringsdatum';
$_lang["page_data_unpublishdate_help"] = 'Om du sätter ett avpubliceringsdatum, kommer dokumentet avpubliceras så snart som datumet är nått. Klicka på kalenderikonen för att välja ett datum, eller ikonen bredvid för att ta bort det. Om datumet tas bort, kommer dokumentet aldrig att avpubliceras automatiskt.';
$_lang["page_data_unpublished"] = 'Avpublicerad';
$_lang["page_data_web_access"] = 'Webbåtkomst';
$_lang["pagination_table_first"] = "Första";
$_lang["pagination_table_last"] = "Sista";
$_lang["pagination_table_gotopage"] = "Gå till sidan";
$_lang["paging_first"] = 'första';
$_lang["paging_last"] = 'sista';
$_lang["paging_next"] = 'nästa';
$_lang["paging_prev"] = 'föregående';
$_lang["paging_showing"] = 'Visar';
$_lang["paging_to"] = 'till';
$_lang["paging_total"] = 'totalt';
$_lang["pagetitle"] = 'Dokumentets titel';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Lösenord';
$_lang["password_change_request"] = 'Förfrågan om ändrat lösenord';
$_lang["password_gen_gen"] = 'Låt MODx generera ett lösenord';
$_lang["password_gen_length"] = 'Lösenordet du specificerar måste vara minst 6 tecken långt.';
$_lang["password_gen_method"] = 'Ny lösenordsmetod';
$_lang["password_gen_specify"] = 'Låt mig specificera ett lösenord:';
$_lang["password_method"] = 'Metod för tillkännagivande av lösenord';
$_lang["password_method_email"] = 'Skicka det nya lösenordet med epost.';
$_lang["password_method_screen"] = 'Visa det nya lösenordet på skärmen.';
$_lang["password_msg"] = 'Det nya lösenordet för <b>%s</b> är <b>%s</b>.';
$_lang["php_version_check"] = 'MODx är kompatibelt med PHP version 4.0.3 eller högre. Du behöver uppgradera din installation av PHP!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Plugin-kod (php)';
$_lang["plugin_config"] = 'Konfigurera plugin';
$_lang["plugin_desc"] = 'Beskrivning';
$_lang["plugin_disabled"] = 'Pluginen avstängd';
$_lang["plugin_event_msg"] = 'Välj de händelser som pluginen ska lyssna till.';
$_lang["plugin_locked_message"] = 'Denna plugin är låst.';
$_lang["plugin_management_msg"] = 'Här kan du skapa en ny plugin eller välja en redan befintlig för redigering.';
$_lang["plugin_msg"] = 'Här kan du skapa och redigera plugins. Plugins är "rå" PHP-kod som körs när de valda systemhändelserna anropas.';
$_lang["plugin_name"] = 'Pluginnamn';
$_lang["plugin_priority"] = 'Redigera körordningen för plugins efter händelse';
$_lang["plugin_title"] = 'Skapa/redigera plugin';
$_lang["preview"] = 'Förhandsgranska';
$_lang["preview_document"] = 'Förhandsgranska';
$_lang["preview_msg"] = 'Detta är en förhandsgranskning av dina senast sparade ändringar. Klicka här för att <a href="#" onclick="saveRefreshPreview();">spara och ladda om</a> dina nuvarande ändringar';
$_lang["private"] = 'Privat';
$_lang["public"] = 'Offentlig';
$_lang["publish_date"] = 'Publiseringsdatum';
$_lang["publish_document"] = 'Publicera dokument';
$_lang["publish_events"] = 'Publicera händelser';
$_lang["rb_base_dir_message"] = 'Ange den fysiska sökvägen till resursens katalog. Den här inställningen görs vanligen automatiskt, men om du använder IIS är det möjligt att MODx inte kan räkna ut sökvägen själv, vilket orsakar ett felmeddelande i resursläsaren. I så fall kan du skriva in sökvägen till bildkatalogen här (sökvägen som den visas i Utforskaren).<br /><b>OBS: Resurskatalogen måste innehålla underkatalogerna images, files, flash och media för att resursläsaren ska fungera korrekt.</b>';
$_lang["rb_base_dir_title"] = 'Sökväg till resurs';
$_lang["rb_base_url_message"] = 'Ange den virtuella sökvägen till resurskatalogen. Den här inställningen görs vanligen automatiskt, men om du använder IIS är det möjligt att MODx inte kan räkna ut adressen på egen hand, vilket orsakar ett felmeddelande i resursläsaren. I så fall kan du skriva in adressen till bildkatalogen här (adressen som du skulle skriva den i Internet Explorer).';
$_lang["rb_base_url_title"] = 'Resursens adress';
$_lang["rb_message"] = 'Välj "Ja" för att använda resursläsaren. Detta låter dina användare läsa och ladda upp resurser såsom bilder, flash- och mediafiler till servern.';
$_lang["rb_title"] = 'Använd resursläsare';
$_lang["recent_docs"] = 'Senaste dokument';
$_lang["refresh_cache"] = 'Cache: Hittade <b>%s</b> filer i cachekatalogen, och tog bort <b>%d</b> cachefiler. <p>Nya cachefiler kommer automatiskt att skapas när sidorna hämtas';
$_lang["refresh_published"] = '<b>%s</b> dokument publicerades.';
$_lang["refresh_site"] = 'Rensa cachen';
$_lang["refresh_title"] = 'Uppdatera webbplatsen';
$_lang["refresh_tree"] = 'Uppdatera träd';
$_lang["refresh_unpublished"] = '<b>%s</b> dokument avpublicerades.';
$_lang["remember_username"] = 'Kom ihåg mig';
$_lang["remove"] = 'Ta bort';
$_lang["remove_date"] = 'Ta bort datum';
$_lang["remove_locks"] = 'Ta bort lås';
$_lang["rename"] = 'Byt namn';
$_lang["reports"] = 'Rapporter';
$_lang["require_tagname"] = 'Ett namn på taggen krävs';
$_lang["require_tagvalue"] = 'Ett värde på taggen krävs';
$_lang["reset"] = 'Återställ';
$_lang["reset_failedlogins"] = 'nollställ';
$_lang["resolve_hostnames_message"] = 'Vill du att MODx ska försöka göra namnuppslag på dina besökares värddatornamn när de besöker din webbplats? Namnuppslag kan skapa extra belastning för servern, men dina besökare kommer inte att märka av det på något sätt.';
$_lang["resolve_hostnames_title"] = 'Gör namnuppslag';
$_lang["resource"] = 'Resurs';
$_lang["resource_categories"] = 'Kombinerad vy';
$_lang["resource_management"] = 'Hantera resurser';
$_lang["resource_name"] = 'Resursnamn';
$_lang["resource_selector_msg"] = 'Välj resurser i nedanstående lista och klicka på \'Lägg till\'.';
$_lang["resource_selector_title"] = 'Resursväljare';
$_lang["resources"] = 'Resurser';
$_lang["role_about"] = 'Visa Om-sidan';
$_lang["role_access_persmissions"] = 'Åtkomsträttigheter';
$_lang["role_actionok"] = 'Visa \'Handling utförd\'-sidan';
$_lang["role_bk_manager"] = 'Använd hanteraren för säkerhetskopiering';
$_lang["role_cache_refresh"] = 'Töm webbplatsens cache';
$_lang["role_change_password"] = 'Byta lösenord';
$_lang["role_chunk_management"] = 'Chunk-hantering';
$_lang["role_config_management"] = 'Konfigurationshantering';
$_lang["role_content_management"] = 'Innehållshantering';
$_lang["role_create_chunk"] = 'Skapa nya chunks';
$_lang["role_create_doc"] = 'Skapa nya dokument';
$_lang["role_create_plugin"] = 'Skapa nya plugins';
$_lang["role_create_snippet"] = 'Skapa nya snippets';
$_lang["role_create_template"] = 'Skapa nya mallar';
$_lang["role_credits"] = 'Visa erkännandesidan';
$_lang["role_delete_chunk"] = 'Ta bort chunks';
$_lang["role_delete_doc"] = 'Ta bort dokument';
$_lang["role_delete_eventlog"] = 'Ta bort händelselogg';
$_lang["role_delete_module"] = 'Ta bort modul';
$_lang["role_delete_plugin"] = 'Ta bort plugin';
$_lang["role_delete_role"] = 'Ta bort roller';
$_lang["role_delete_snippet"] = 'Ta bort snippets';
$_lang["role_delete_template"] = 'Ta bort mallar';
$_lang["role_delete_user"] = 'Ta bort användare';
$_lang["role_delete_web_user"] = 'Ta bort webbanvändare';
$_lang["role_edit_chunk"] = 'Redigera chunks';
$_lang["role_edit_doc"] = 'Redigera dokument';
$_lang["role_edit_doc_metatags"] = 'Redigera dokumentets META-taggar och nyckelord';
$_lang["role_edit_module"] = 'Redigera modul';
$_lang["role_edit_plugin"] = 'Redigera plugin';
$_lang["role_edit_role"] = 'Redigera roller';
$_lang["role_edit_settings"] = 'Ändra webbplatsens inställningar';
$_lang["role_edit_snippet"] = 'Redigera snippets';
$_lang["role_edit_template"] = 'Redigera mallar';
$_lang["role_edit_user"] = 'Redigera användare';
$_lang["role_edit_web_user"] = 'Redigera webbanvändare';
$_lang["role_errors"] = 'Visa feldialog';
$_lang["role_eventlog_management"] = 'Hantera händelseloggar';
$_lang['role_export_static'] = 'Exportera statisk HTML';
$_lang["role_file_manager"] = 'Använda filhanteraren';
$_lang["role_frames"] = 'Ladda sidhanteraren';
$_lang["role_help"] = 'Visa hjälpsidor';
$_lang["role_home"] = 'Ladda introduktionssidan';
$_lang['role_import_static'] = 'Importera HTML';
$_lang["role_logout"] = 'Logga ut från sidhanteraren';
$_lang["role_manage_metatags"] = 'Hantera webbplatsens META-taggar och nyckelord';
$_lang["role_management_msg"] = 'Här kan du skapa en ny roll eller välja en redan befintlig för redigering.';
$_lang["role_management_title"] = 'Roller';
$_lang["role_messages"] = 'Läsa och skicka meddelanden';
$_lang["role_module_management"] = 'Hantera moduler';
$_lang["role_name"] = 'Rollnamn';
$_lang["role_new_module"] = 'Skapa ny modul';
$_lang["role_new_role"] = 'Skapa nya roller';
$_lang["role_new_user"] = 'Skapa nya användare';
$_lang["role_new_web_user"] = 'Skapa nya webbanvändare';
$_lang["role_plugin_management"] = 'Hantera plugins';
$_lang["role_publish_doc"] = 'Publicera dokument';
$_lang["role_role_management"] = 'Roller';
$_lang["role_run_module"] = 'Kör modul';
$_lang["role_save_chunk"] = 'Spara chunks';
$_lang["role_save_doc"] = 'Spara dokument';
$_lang["role_save_module"] = 'Spara modul';
$_lang["role_save_password"] = 'Spara lösenord';
$_lang["role_save_plugin"] = 'Spara plugin';
$_lang["role_save_role"] = 'Spara roller';
$_lang["role_save_snippet"] = 'Spara snippets';
$_lang["role_save_template"] = 'Spara mallar';
$_lang["role_save_user"] = 'Spara användare';
$_lang["role_save_web_user"] = 'Spara webbanvändare';
$_lang["role_snippet_management"] = 'Snippethantering';
$_lang["role_template_management"] = 'Mallhantering';
$_lang["role_title"] = 'Skapa/redigera roll';
$_lang["role_udperms"] = 'Behörighetshantering';
$_lang["role_user_management"] = 'Användarhantering';
$_lang["role_view_docdata"] = 'Visa dokumentdata';
$_lang["role_view_eventlog"] = 'Visa händelselogg';
$_lang["role_view_logs"] = 'Visa systemloggar';
$_lang["role_view_unpublished"] = 'Visa opublicerade dokument';
$_lang["role_web_access_persmissions"] = 'Rättigheter för webbåtkomst';
$_lang["role_web_user_management"] = 'Hantera webbanvändare';
$_lang["run_module"] = 'Kör modul';
$_lang["saturday"] = 'Lördag';
$_lang["save"] = 'Spara';
$_lang["save_all_changes"] = 'Spara alla ändringar';
$_lang["save_tag"] = 'Spara tagg';
$_lang["saving"] = 'Sparar, vänta...';
$_lang["scroll_dn"] = 'Rulla ner';
$_lang["scroll_up"] = 'Rulla upp';
$_lang["search"] = 'Sök';
$_lang["search_criteria"] = 'Sökkriterier';
$_lang["search_criteria_content"] = 'Sök efter innehåll';
$_lang["search_criteria_content_msg"] = 'Hitta samtliga dokument med söktexten i innehållet.';
$_lang["search_criteria_id"] = 'Sök efter ID';
$_lang["search_criteria_id_msg"] = 'Skriv dokumentets ID för att snabbt lokalisera dokumentet.';
$_lang["search_criteria_longtitle"] = 'Sök efter lång titel';
$_lang["search_criteria_longtitle_msg"] = 'Hitta alla dokument med söktexten i den långa titeln.';
$_lang["search_criteria_title"] = 'Sök efter titel';
$_lang["search_criteria_title_msg"] = 'Hitta samtliga dokument med söktexten i titeln.';
$_lang["search_empty"] = 'Din sökning gav inga resultat. Bredda dina sökkriterier och försök igen';
$_lang["search_item_deleted"] = 'Denna post har tagits bort';
$_lang["search_results"] = 'Sökresultat';
$_lang["search_results_returned_desc"] = 'Beskrivning';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Din sökning returnerade <b>%s</b> dokument. Försök att skriva en mer specifik sökning om du får många träffar. De två kolumnerna längst till vänster låter dig hitta dokumentet i trädet eller visa dokumentet. De två kolumnerna till höger visar om dokumentet har tagits bort och vilken publiceringsstatus det har.<p />';
$_lang["search_results_returned_title"] = 'Titel';
$_lang["search_view_docdata"] = 'Visa denna post';
$_lang["security"] = 'Säkerhet';
$_lang["select_date"] = 'Välj ett datum';
$_lang["send"] = 'Skicka';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'Specificera här om din sida använder en http- eller en https-anslutning.';
$_lang["server_protocol_title"] = 'Servertyp';
$_lang["serveroffset"] = 'Serverns tidsskillnad';
$_lang["serveroffset_message"] = 'Välj det antal timmar som skiljer mellan dig och servern. Nuvarande tid på servern är <b>[%s]</b>, och den nuvarande tiden med modifieraren är <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Serverns tidsförskjutning';
$_lang["servertime"] = 'Serverns tid';
$_lang["settings_after_install"] = 'Eftersom detta är en ny installation, måste du gå igenom dessa inställningar och ändra det du vill. När du är klar med kontrollen av alla inställningar, klicka på \'Spara\' för att uppdatera inställningsdatabasen.<br /><br />';
$_lang["settings_config"] = 'Konfiguration';
$_lang["settings_dependencies"] = 'Beroenden';
$_lang["settings_events"] = 'Systemhändelse';
$_lang["settings_furls"] = 'Vänliga adresser';
$_lang["settings_general"] = 'Allmänt';
$_lang["settings_misc"] = 'Övrigt';
$_lang["settings_page_settings"] = 'Sidinställningar';
$_lang["settings_photo"] = 'Foto';
$_lang["settings_properties"] = 'Egenskaper';
$_lang["settings_site"] = 'Webbplatsen';
$_lang["settings_snippets"] = 'Snippets';
$_lang["settings_strip_image_paths_message"] = 'Om denna inställning sätts till "Nej", så kommer MODx att skriva sökvägarna till resurser i filhanteraren (bilder, filer, flash etc.) som absoluta URLer. Relativa URLer är användbara om du ska flytta din MODX-installation, tex från en testserver till en produktionsserver. Om du inte har någon aning om vad det här betyder, så är det bäst att lämna inställningen satt till "Ja".';
$_lang["settings_strip_image_paths_title"] = 'Skriv om sökvägar till resurser?';
$_lang["settings_templvars"] = 'Mallvariabler';
$_lang["settings_title"] = 'Systeminställningar';
$_lang["settings_ui"] = 'Gränssnitt &amp; funktioner';
$_lang["settings_users"] = 'Användare';
$_lang["show_preview"] = 'Visa förhandsgranskningsfönster';
$_lang["show_tree"] = 'Visa träd';
$_lang["showing"] = 'Visande';
$_lang["signupemail_message"] = 'Här kan du ange det meddelande som skickas till användare när du skapar ett konto för dem och låta MODx skicka epost till dom med deras användarnamn och lösenord.<br /><b>Notera:</b> Följande begrepp ersätts av innehållshanteraren när meddelandet sänds:<br /><br />[+sname+] - Namnet på din webbplats<br />[+saddr+] - Webbplatsens epostadress<br />[+surl+] - Webbplatsens adress<br />[+uid+] - Användarens login eller ID<br />[+pwd+] - Användarens lösenord<br />[+ufn+] - Användarens namn<br /><br /><b>Låt [+uid+] och [+pwd+] stå kvar i meddelandet, annars innehåller mailet inte användarnamn och lösenord, vilket gör att dina användare inte kan logga in!</b>';
$_lang["signupemail_title"] = 'Registreringsmeddelande';
$_lang["site"] = 'Webbplats';
$_lang["site_schedule"] = 'Schema';
$_lang["sitename_message"] = 'Skriv in namnet på din webbplats här.';
$_lang["sitename_title"] = 'Webbplatsens namn';
$_lang["sitestart_message"] = 'Skriv in ID till dokumentet du vill ha som startsida här.<br /><b>OBS: Se till att detta ID tillhör ett existerande dokument, och att det har blivit publicerat!</b>';
$_lang["sitestart_title"] = 'Startsida';
$_lang["sitestatus_message"] = 'Välj "Online" för att publicera din webbplats. Väljer du "Offline", kommer dina besökare att se meddelandet för "Webbplatsen inte tillgänglig" och kommer inte att kunna besöka sidan.';
$_lang["sitestatus_title"] = 'Webbplatsens status';
$_lang["siteunavailable_message"] = 'Meddelandet som visas när webbplatsen är offline, eller när något fel har inträffat.<br /><b>OBS: Detta meddelande visas bara om ingen "Webbplatsen inte tillgänglig"-sida bestämts.</b>';
$_lang["siteunavailable_page_message"] = 'Ange ID för det dokument du vill använda som en offline-sida här. <br /><b>OBS: Kontrollera att detta ID hör till ett existerande dokument och att det blivit publicerat!</b>';
$_lang["siteunavailable_page_title"] = 'Sida för<br />"Webbplatsen inte tillgänglig"';
$_lang["siteunavailable_title"] = 'Meddelande för<br />"Webbplatsen inte tillgänglig"';
$_lang["snippet"] = 'Snippet';
$_lang["snippet_code"] = 'Snippet-kod (php)';
$_lang["snippet_desc"] = 'Beskrivning';
$_lang["snippet_execonsave"] = 'Kör snippeten efter att den sparats.';
$_lang["snippet_management_msg"] = 'Här kan du skapa nya snippets eller välja en redan befintlig för redigering.';
$_lang["snippet_msg"] = 'Här kan du skapa och redigera snippets. Kom ihåg att snippets är "rå" PHP-kod, och om du förväntar dig att snippeten ska skriva något i mallen, så måste du ange ett returvärde i snippeten.';
$_lang["snippet_name"] = 'Namn på snippeten';
$_lang["snippet_properties"] = 'Standardegenskaper';
$_lang["snippet_title"] = 'Skapa/redigera snippet';
$_lang["snippets_availabe"] = 'Snippets som är tillgängliga för dig att inkludera i dina sidor';
$_lang["sort_asc"] = 'Stigande';
$_lang["sort_desc"] = 'Fallande';
$_lang["sort_tree"] = 'Sortera trädet';
$_lang["source"] = 'Källa';
$_lang["stay"] = 'Fortsätt redigera';
$_lang["stay_new"] = 'Lägg till en till';
$_lang["submit"] = 'Skicka';
$_lang["sunday"] = 'Söndag';
$_lang["sys_alert"] = 'Systemlarm';
$_lang["sysinfo_activity_message"] = 'Denna lista visar vilka dokument som nyligen redigerats av dina användare.';
$_lang["sysinfo_userid"] = 'Användare';
$_lang["system_email_signup"] = 'Hej [+uid+] \n\nHär kommer dina inloggningsuppgifter för [+sname+] ([+surl+]) innehållshanterare:\n\nAnvändarnamn: [+uid+]\nLösenord: [+pwd+]\n\nDu kan ändra ditt lösenord när du loggat in i innehålshanteraren.\n\nVänliga hälsningar\nWebmastern';
$_lang["system_email_webreminder"] = 'Hej [+uid+]\n\nKlicka på följande länk för att aktivera ditt nya lösenord:\n\n[+surl+]\n\nOm allt går bra använder du följande lösenord för att logga in:\n\nLösenord:[+pwd+]\n\nOm du inte har bett om det här brevet så kan du strunta i det.\n\nVänliga hälsningar\nWebmastern';
$_lang["system_email_websignup"] = 'Hej [+uid+] \n\nHär kommer dina inloggningsuppgifter för [+sname+] ([+surl+]):\n\nAnvändarnamn: [+uid+]\nLösenord: [+pwd+]\n\nDu kan ändra ditt lösenord när du loggat in i [+sname+].\n\nVänliga hälsningar\nWebmastern';
$_lang["table_hoverinfo"] = 'Placera markören över ett tabellnamn för att se en kort beskrivning av tabellens funktion (gäller dock inte alla tabellnamn).'; 
$_lang["table_prefix"] = 'Tabellprefix';
$_lang["tag"] = 'Tagg';
$_lang["template"] = 'Mall';
$_lang["template_assignedtv_tab"] = 'Tilldelade mallvariabler';
$_lang["template_code"] = 'Mall-kod (html)';
$_lang["template_desc"] = 'Beskrivnig';
$_lang["template_edit_tab"] = 'Redigera mall';
$_lang["template_locked_message"] = 'Denna mall är låst.';
$_lang["template_management_msg"] = 'Här kan du skapa en ny mall eller välja en redan befintlig för redigering.';
$_lang["template_msg"] = 'Skapa och redigera mallar här. Ändrade eller nya mallar kommer inte att synas på din webbplats cachade sidor, förrän cachen har tömts. Du kan däremot använda förhandsgranskningen för att se hur den uppdaterade mallen kommer att se ut.';
$_lang["template_name"] = 'Namn på mall';
$_lang["template_no_tv"] = 'Inga mallvariabler har tilldelats den här mallen än.';
$_lang["template_reset_all"] = 'Återställ alla sidor så de använder standardmallen';
$_lang["template_reset_specific"] = 'Återställ endast "%s" sidor';
$_lang["template_title"] = 'Skapa/redigera mallar';
$_lang["template_tv_edit"] = 'Redigera mallvariablernas sorteringsordning';
$_lang["template_tv_msg"] = 'Mallvariablerna som tilldelats den här mallen visas nedan.';
$_lang["thursday"] = 'Torsdag';
$_lang["tmplvar_access_msg"] = 'Välj de dokumentgrupper som ska kunna modifiera innehållet eller värdet av denna variabel';
$_lang["tmplvar_change_template_msg"] = 'Ändrar du denna mall, kommer sidan att ladda om alla mallvariabler. Alla icke sparade ändringar kommer att förloras.\n\nÄr du säker på att du vill ändra denna mall?';
$_lang["tmplvar_inuse"] = 'Följande dokument använder för närvarande denna mallvariabel. För att fortsätta med denna borttagningsoperation, klicka på knappen \'Ta bort\'. Klicka på knappen \'Avbryt\' för att avbryta.';
$_lang["tmplvar_tmpl_access"] = 'Mallåtkomst';
$_lang["tmplvar_tmpl_access_msg"] = 'Välj de mallar som har behörighet att använda denna variabel';
$_lang["tmplvars"] = 'Mallvariabler';
$_lang["tmplvars_binding_msg"] = 'Detta fält tillåter bindning av datakällor med @-kommandon';
$_lang["tmplvars_caption"] = 'Rubrik';
$_lang["tmplvars_default"] = 'Standardvärde';
$_lang["tmplvars_description"] = 'Beskrivning';
$_lang["tmplvars_elements"] = 'Inmatningsvärden';
$_lang["tmplvars_management_msg"] = 'Här kan du hantera ytterligare innehållsfält (mallvariabler) för dina dokument.';
$_lang["tmplvars_msg"] = 'Lägga till och redigera mallvariabler här. Mallvariablerna måste vara tilldelade till mallar för att de ska kunna kommas åt från snippets och dokument.';
$_lang["tmplvars_name"] = 'Variabelnamn';
$_lang["tmplvars_novars"] = 'Ingen mallvariabel hittad';
$_lang["tmplvars_rank"] = 'Sorteringsordning';
$_lang["tmplvars_reset_params"] = 'Återställ parametrar';
$_lang["tmplvars_type"] = 'Inmatningstyp';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget-inställningar';
$_lang["to"] = 'till';
$_lang["tools"] = 'Verktyg';
$_lang["top_howmany_message"] = 'När rapporter visas, hur långa ska "Topp..."-listorna vara?';
$_lang["top_howmany_title"] = 'Hur många i toppen';
$_lang["total"] = 'totalt';
$_lang['track_visitors_message'] = 'Den här inställningen har ingen effekt om du inte har en besöksräknare eller ett statistikprogram installerat som stödjer den här inställningen. Genom att logga besök kan du få fram statistik på hur din webbplats används.';
$_lang['track_visitors_title'] = 'Logga besök (statistik)';
$_lang["tree_show_protected"] = 'Visa skyddade dokument';
$_lang["tree_show_protected_message"] = 'När den här inställningen är satt till "Nej" visas inte skyddade dokument (och deras underdokument) i dokumentträdet. "Nej" är den traditionella inställningen för MODx.';
$_lang["truncate_table"] = 'Klicka här för att trunkera den här tabellen';
$_lang["tuesday"] = 'Tisdag';
$_lang["tv"] = 'Mallvariabel';
$_lang["type"] = 'Typ';
$_lang["udperms_allowroot_message"] = 'Vill du tillåta dina användare att skapa nya dokument i roten på webbplatsen? ';
$_lang["udperms_allowroot_title"] = 'Tillåt rot:';
$_lang["udperms_message"] = 'Åtkomsträttigheter tillåter dig att specificera vilka sidor dina användare har behörighet att redigera. Du måste tilldela användargrupper till dina användare, gruppera dokumenten i dokumentgrupper och till sist specificera vilka användargrupper som har behörighet att komma åt vilka dokumentgrupper. När du först slår på detta, kommer endast administratörer att kunna redigera dokument.';
$_lang["udperms_title"] = 'Använd åtkomsträttigheter';
$_lang["unable_set_link"] = 'Kunde inte ange länken!';
$_lang["unable_set_parent"] = 'Kunde inte skapa ny förälder!';
$_lang["unauthorizedpage_message"] = 'Ange ID till det dokument som du vill skicka användare till om de har frågat efter ett säkert eller otillåtet dokument.<br /><b>OBS: Se till att det ID du skrivt in tillhör ett existerande dokument, att det har blivit publicerat och kan kommas åt av alla!</b>';
$_lang["unauthorizedpage_title"] = 'Otillåten-sida';
$_lang["unblock_message"] = 'Denna användare kommer inte längre att blockeras när användarens data sparats.';
$_lang["undelete_document"] = 'Återställ dokument';
$_lang["unpublish_date"] = 'Avpubliceringsdatum';
$_lang["unpublish_document"] = 'Avpublicera dokument';
$_lang["unpublish_events"] = 'Avpublicera händelser';
$_lang["untitled_document"] = 'Namnlöst dokument';
$_lang["untitled_weblink"] = 'Namnlös webblänk';
$_lang["update_params"] = 'Uppdatera parametervisningen';
$_lang["upload_maxsize_message"] = 'Skriv den största filstorleken som kan laddas upp via filhanteraren. Storleken måste anges i bytes.<br /><b>OBS: Stora filer kan ta väldigt lång tid att ladda upp!</b>';
$_lang["upload_maxsize_title"] = 'Största storlek för uppladdningar';
$_lang["uploadable_files_message"] = 'Här kan du skriva en lista med de typer av filer som kan laddas upp till "assets/files/" med filhanteraren. Skriv i suffixen för filtyperna, separerade med kommatecken.';
$_lang["uploadable_files_title"] = 'Uppladdningsbara filtyper';
$_lang["uploadable_flash_message"] = 'Här kan du skriva en lista med de typer av flashfiler som kan laddas upp till "assets/flash/" med filhanteraren. Skriv i suffixen för flashtyperna, separerade med kommatecken.';
$_lang["uploadable_flash_title"] = 'Uppladdningsbara flashtyper';
$_lang["uploadable_images_message"] = 'Här kan du skriva en lista med de typer av bildfiler som kan laddas upp till "assets/images/" med filhanteraren. Skriv i suffixen för bildfilerna, separerade med kommatecken.';
$_lang["uploadable_images_title"] = 'Uppladdningsbara bildtyper';
$_lang["uploadable_media_message"] = 'Här kan du skriva en lista med de typer av mediafiler som kan laddas upp till "assets/media/" med filhanteraren. Skriv i suffixen för mediatyperna, separerade med kommatecken.';
$_lang["uploadable_media_title"] = 'Uppladdningsbara mediatyper';
$_lang["use_alias_path_message"] = 'Sätts detta val till "Ja", kommer hela sökvägen till dokumentet att visas om dokumentet har ett alias. Till exempel, om ett dokument med aliaset "barn" befinner sig i en behållare med aliaset "foralder", kommer hela sökvägen att visas som "/foralder/barn.html".<br /><b>Notera: När detta sätts till "Ja" (slår på aliassökvägar), måste du referera objekt (som bilder, css, javascript etc) med en absolut sökväg. Exempel: "/assets/images" istället för "assets/images". Genom att göra så förhindrar du att webbläsaren (eller webbservern) lägger till den relativa sökvägen till aliassökvägen.</b>';
$_lang["use_alias_path_title"] = 'Använd vänliga aliassökvägar';
$_lang["use_editor_message"] = 'Vill du aktivera en richtext-editor? Om du trivs bättre med att skriva HTML, kan du stänga av editorn genom att ändra denna inställning.<br /><b>OBS: Denna inställning gäller för samtliga dokument och alla användare!</b>';
$_lang["use_editor_title"] = 'Aktivera editor';
$_lang["user"] = 'Användare';
$_lang["user_block"] = 'Blockerad';
$_lang["user_blockedafter"] = 'Blockerad efter';
$_lang["user_blockeduntil"] = 'Blockerad till';
$_lang["user_changeddata"] = 'Dina användardata har ändrats. Var snäll och logga in igen.';
$_lang["user_country"] = 'Land';
$_lang["user_dob"] = 'Födelsedatum';
$_lang["user_doesnt_exist"] = 'Användaren finns inte';
$_lang["user_edit_self_msg"] = 'Efter att ha sparat kan du behöva logga ut och sedan logga in igen för att dina inställningar ska uppdateras fullständigt</b><br />Om du väljer att generera ett nytt lösenord till dig själv, kommer det att skickas till din epostadress.';
$_lang["user_email"] = 'Epostadress';
$_lang["user_failedlogincount"] = 'Misslyckade inloggningar';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Kvinna';
$_lang["user_full_name"] = 'Fullständigt namn';
$_lang["user_gender"] = 'Kön';
$_lang["user_is_blocked"] = 'Denna användare är blockerad!';
$_lang["user_logincount"] = 'Antal inloggningar';
$_lang["user_male"] = 'Man';
$_lang["user_management_msg"] = 'Här kan du skapa nya användare av innehållshanteraren eller välja en redan befintlig för redigering. Dessa användare kan logga in i innehållshanteraren.';
$_lang["user_management_title"] = 'Användare av hanteraren';
$_lang["user_mobile"] = 'Mobilnummer';
$_lang["user_phone"] = 'Telefonnummer';
$_lang["user_photo"] = 'Användarfoto';
$_lang["user_photo_message"] = 'Skriv in sökvägen till bilden för den här användaren, eller använd "Infoga"-knappen för att öppna ett nytt fönster där du kan välja en bild och ladda upp den till servern.';
$_lang["user_prevlogin"] = 'Senaste inloggning';
$_lang["user_role"] = 'Användarens roll';
$_lang["user_state"] = 'Kommun';
$_lang["user_title"] = 'Skapa/redigera användare';
$_lang["user_upload_message"] = ' Om du vill hindra denna användare från att ladda upp några filtyper i den här kategorin, se då till att "Använd systemets konfigurationsinställning" inte är förbockad och lämna fältet blankt.';
$_lang["user_use_config"] = 'Använd systemets konfigurationsinställning';
$_lang["user_zip"] = 'Postnummer';
$_lang["username"] = 'Användarnamn';
$_lang["users"] = 'Säkerhet';
$_lang["value"] = 'Värde';
$_lang["version_codename"] = 'Versionens kodnamn'; 
$_lang["view"] = 'Visa';
$_lang["view_child_documents_in_container"] = 'Underdokument';
$_lang["view_document"] = 'Visa dokument';
$_lang["view_log"] = 'Visa logg';
$_lang["view_logging"] = 'Aktiviteter i hanteraren';
$_lang["view_sysinfo"] = 'Systeminformation';
$_lang["warning"] = 'Varning!';
$_lang["warning_not_saved"] = 'De ändringar du gjort har ännu inte sparats. Du kan välja att stanna kvar på den nuvarande sidan och spara ändringarna (\'Avbryt\'), eller så kan du lämna sidan, och förlora alla ändringar du gjort (\'OK\').';
$_lang["web_access_permissions"] = 'Rättigheter för webbåtkomst';
$_lang["web_access_permissions_user_group"] = 'Webbanvändargrupp:';
$_lang["web_access_permissions_user_group_access"] = 'Dokumentgrupper som den här användargruppen har tillgång till:';
$_lang["web_access_permissions_user_groups"] = 'Webbanvändargrupper';
$_lang["web_permissions"] = 'Rättigheter för webbåtkomst';
$_lang["web_user_management_msg"] = 'Här kan du skapa nya webbanvändare eller välja en redan befintlig för redigering. Webbanvändare är de som endast kan logga in till webbplatsen';
$_lang["web_user_management_title"] = 'Webbanvändare';
$_lang["web_user_title"] = 'Skapa/redigera webbanvändare';
$_lang["web_users"] = 'Webbanvändare';
$_lang["weblink"] = 'Webblänk';
$_lang["weblink_message"] = 'En webblänk är en referens till ett objekt på Internet. Detta kan vara ett dokument i MODx, en sida på en annan webbserver, en bild, eller en annan typ av fil på Internet.<p>';
$_lang["webpwdreminder_message"] = 'Skriv ett meddelande som skickas till dina webbanvändare när de begärt ett nytt lösenord via epost. Innehållshanteraren kommer att skicka ett epostmeddelande med deras nya lösenord och aktiveringsinformation.<br /><b>Notera:</b> Följande platshållare ersätts av innehållshanteraren när ett meddelande skickas:<br /><br />[+sname+] - Namnet på din webbplats<br />[+saddr+] - Epostadressen till din webbplats<br />[+surl+] - Adressen till din webbplats<br />[+uid+] - Användarens inloggningsnamn eller ID<br />[+pwd+] - Användarens lösenord<br />[+ufn+] - Användarens namn<br /><br /><b>Lämna [+uid+] och [+pwd+] i meddelandet, annars får inte mottagaren av eposten reda på sitt nya användarnamn och lösenord!</b>';
$_lang["webpwdreminder_title"] = 'Epost för webbpåminnelse';
$_lang["websignupemail_message"] = 'Här kan du ange det meddelande som skickas till dina webbanvändare när du skapar ett webbkonto för dem, och låter innehållshanteraren skicka ett epostmeddelande med användarnamn och lösenord.<br /><b>Notera:</b> Följande platshållare ersätts av innehållshanteraren när meddelandet skickas:<br /><br />[+sname+] - Namnet på din webbplats<br />[+saddr+] - Epostadressen till din webbplats<br />[+surl+] - Adressen till din webbplats<br />[+uid+] - Användarens inloggningsnamn eller ID<br />[+pwd+] - Användarens lösenord<br />[+ufn+] - Användarens namn<br /><br /><b>Lämna [+uid+] och [+pwd+] i meddelandet, annars får inte mottagaren av eposten reda på sitt användarnamn och lösenord!</b>';
$_lang["websignupemail_title"] = 'Epost för webbregistreringar';
$_lang["wednesday"] = 'Onsdag';
$_lang["welcome_messages"] = 'Din Inkorg innehåller <b>%d</b> meddelande(n), av vilka <b>%s</b> är olästa.';
$_lang["welcome_title"] = 'Välkommen till webbpubliceringsverktyget MODx';
$_lang["which_editor_message"] = 'Här kan du välja vilken richtext-editor du vill använda. Du kan ladda ner och installera fler richtext-editorer från MODx nedladdningssida.';
$_lang["which_editor_title"] = 'Editor att använda';
$_lang["working"] = 'Arbetar...';
$_lang["wrap_lines"] = 'Radbryt';
$_lang["xhtml_urls_title"] = 'XHTML-URLer';
$_lang["xhtml_urls_message"] = 'Ersätter et-tecken (&amp;) i URLer som genereras av MODx med den validerande &amp;<!-- -->amp; html-entiteten.';
$_lang["yes"] = 'Ja';
$_lang["you_got_mail"] = 'Du har fått epost';
$_lang["yourinfo_message"] = 'Denna sektion visar information om dig:';
$_lang["yourinfo_previous_login"] = 'Din senaste inloggning:';
$_lang["yourinfo_role"] = 'Din roll är:';
$_lang["yourinfo_title"] = 'Din information';
$_lang["yourinfo_total_logins"] = 'Totalt antal inloggningar:';
$_lang["yourinfo_username"] = 'Du är inloggad som:';

?>
