<?php
/**
* Filename:       includes/lang/japanese-utf8.inc.php
* Function:       Language file.
* Encoding:       UTF-8
* Author:         Japanese community Translated by eastbind
* Date:           2007/04/25
* Version:        2.12
* MODx version:   0.9.6 RC3
*/

/* Set locale to Japanese */
setlocale (LC_ALL, 'ja_JP');
include_once(dirname(__FILE__).'/english.inc.php'); // fall back to English defaults if needed

// NOTE: アルファベット順に並んでいます
$_lang["about_msg"] = 'MODx は <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP アプリケーション フレームワークであるコンテント管理システム</a>です。<a href=\"../assets/docs/license.txt\">GNU GPL</a>に基づいて使用を許諾しています。';
$_lang["about_title"] = 'MODx について';
$_lang["access_permissions"] = 'アクセス許可';
$_lang["access_permissions_add_document_group"] = 'ドキュメントグループの作成';
$_lang["access_permissions_add_user_group"] = 'ユーザグループの作成';
$_lang["access_permissions_docs_message"] = 'このドキュメントを所属させたいドキュメントグループを選択してください';
$_lang["access_permissions_documents_in_group"] = '<b>グループ内ドキュメント:</b> ';
$_lang["access_permissions_documents_tab"] = 'ドキュメントグループの設定を一覧することができます。グループの作成、リネーム、削除もここで操作します。 また、ドキュメントがどのグループに属しているかを閲覧することもできます(ドキュメント名を表示するには、idの上にマウスポインタを乗せてください)。 ドキュメントをグループに追加したり、グループから削除するには、ドキュメントを直接編集してください。';
$_lang["access_permissions_document_groups"] = 'ドキュメントグループ';
$_lang["access_permissions_introtext"] = 'ここでアクセスパーミッションのためのユーザグループとドキュメントグループを管理することができます。ユーザをグループに追加するには、ユーザ編集の画面でメンバーとして追加するグループを選択してください。ドキュメントをユーザグループに追加するには、ドキュメント編集の画面で属させたいドキュメントグループを選択してください。';
$_lang["access_permissions_links"] = 'ユーザ/ドキュメントグループ リンク';
$_lang["access_permissions_links_tab"] = 'どのユーザグループがドキュメントグループにアクセス(例 編集、子ドキュメントの作成)できるかを指定します。ドキュメントグループをユーザグループに関連付けるには、ドロップダウンメニューよりドキュメントグループを選択して「グループの追加」をクリックしてください。ドキュメントグループとの関連付けを削除するには、「削除 ->」をクリックしてください。この作業を行うことにより、すぐに関連付けが解除されます。';
$_lang["access_permissions_no_documents_in_group"] = '無し';
$_lang["access_permissions_no_users_in_group"] = '無し';
$_lang["access_permissions_off"] = '<span class="warning">アクセス許可機能が停止されています。</span> This means any changes made here will not have any effect until Access Permissions are activated.';
$_lang["access_permissions_users_in_group"] = '<b>グループ内ユーザ:</b> ';
$_lang["access_permissions_users_tab"] = 'ユーザグループの設定一覧を表示します。グループの作成、リネーム、削除もここで操作します。また、ユーザがどのグループのメンバーになっているかを閲覧することができます。ユーザをグループに追加したり、グループから削除するには、ユーザを直接編集してください。管理者(権限ID 1が割り当てられているユーザ)は、常に全てのドキュメントにアクセスすることができます。ですから、管理者をグループに追加する必要はありません。';
$_lang["access_permissions_user_group"] = 'ユーザグループ:';
$_lang["access_permissions_user_groups"] = 'ユーザグループ';
$_lang["access_permissions_user_group_access"] = 'このユーザグループがアクセス可能なドキュメントグループ:';
$_lang["access_permissions_user_message"] = 'このユーザを所属させたいユーザグループを選択してください:';
$_lang["access_permission_denied"] = 'このドキュメントにアクセスする権限がありません。';
$_lang["access_permission_parent_denied"] = 'ここにドキュメントを作成する権限がありません!';
$_lang["account_email"] = 'アカウントメール';
$_lang["actioncomplete"] = '<b>処理が正常に完了しました!</b><br /> - クリーンアップ処理中です。お待ちください。';
$_lang["activity_message"] = '最近作成または編集したドキュメント一覧を表示しています:';
$_lang["activity_title"] = '最近編集/作成されたドキュメント';
$_lang["add"] = '追加';
$_lang["add_chunk"] = 'チャンクの追加';
$_lang["add_doc"] = 'ドキュメントの追加';
$_lang["add_document"] = 'ドキュメントの作成';
$_lang["add_folder"] = 'フォルダの作成';
$_lang["add_plugin"] = 'プラグインの追加';
$_lang["add_snippet"] = 'スニペットの追加';
$_lang["add_tag"] = 'タグ追加';
$_lang["add_template"] = 'テンプレートの追加';
$_lang["add_tv"] = 'テンプレート変数の追加';
$_lang["add_weblink"] = 'ウェブリンクの作成';
$_lang["administrator_role_message"] = 'この権限は編集、削除できません。';
$_lang["after_saving"] = '保存後は';
$_lang["alert_delete_self"] = '自分自身を削除することはできません!';
$_lang["alias"] = 'エイリアス';
$_lang["allow_mgr_access"] = 'マネージャへのアクセス';
$_lang["allow_mgr_access_message"] = 'このオプションはマネージャへのアクセスをユーザに許すか、拒否するかを選択するものです。<b>注意: このオプションを「No」に設定すると、ユーザは上記の「マネージャログイン開始ページ」か、空白ならサイトスタートのページへリダイレクトされます。</b>';
$_lang["all_doc_groups"] = '全ドキュメントグループ (Public)';
$_lang["all_events"] = '全てのイベント';
$_lang["all_usr_groups"] = '全ユーザグループ(Public)';
$_lang["already_deleted"] = 'は既に削除されています';
$_lang["attachment"] = 'Attachment';
$_lang["automatic_alias_message"] = '「Yes」を選択すると、ドキュメントの保存のときドキュメントタイトルを元にシステムが自動的にエイリアスを作成します。';
$_lang["automatic_alias_title"] = '自動エイリアス生成:';
$_lang["backup"] = 'バックアップ';
$_lang["bk_manager"] = 'バックアップマネージャ';
$_lang["blocked_minutes_message"] = '上記の「ログイン失敗の回数」で指定した回数ログインに失敗したユーザのアカウントをロックする期間を分単位で指定します。必ず数字のみを入力してください。（カンマやスペースも駄目です。）';
$_lang["blocked_minutes_title"] = 'アカウントロックの時間:';
$_lang["block_message"] = 'データを保存した後、このユーザのアクセスは拒否されます!';
$_lang["cache_files_deleted"] = '次のファイルが削除されました:';
$_lang["cancel"] = 'キャンセル';
$_lang["captcha_code"] = 'セキュリティコード';
$_lang["captcha_message"] = 'この設定を行うと、機械的(およびscriptkiddyなハッキングスクリプト)に読み取ることのできないコードをユーザに入力させることで、セキュリティを強化することができます。';
$_lang["captcha_title"] = 'CAPTCHAコードの使用:';
$_lang["captcha_words_message"] = '「CAPTCHAコードの使用」を「Yes」にした場合に使用されるCAPTCHAワードリストを入力してください。CAPTCHAワードはカンマで区切ってください。このフィールドには、255文字まで入力することができます。';
$_lang["captcha_words_title"] = 'CAPTCHAワード';
$_lang["category_heading"] = 'カテゴリ';
$_lang["category_msg"] = '<h3 style="font-weight:bold;">全リソースの一覧</h3><p>このページではカテゴリでグループ化したリソースを一覧・編集できます。</p>';
$_lang["change_name"] = '名前の変更';
$_lang["change_password"] = 'パスワードの変更';
$_lang["change_password_confirm"] = 'パスワードをもう一度';
$_lang["change_password_message"] = '新しいパスワードを入力した後、確認のためパスワードをもう一度入力してください。パスワードの長さは6～15文字の間にしてください。';
$_lang["change_password_new"] = '新しいパスワード';
$_lang["charset_message"] = 'マネージャで使用したいエンコードを選択してください。日本語も含め、ほとんどの言語ではデフォルト設定のUTF-8が利用できます。EUCを選択する場合はEUC版のlangファイルをインストールする必要があります。ShiftJISなど日本語対応の他エンコードは十分に検証されてないため、ご注意ください。';
$_lang["charset_title"] = 'エンコード:';
$_lang["chunk"] = 'チャンク';
$_lang["chunk_code"] = 'チャンク コード (html)';
$_lang["cleaningup"] = 'クリーンアップ処理中';
$_lang["clear_log"] = 'ログをクリア';
$_lang["click_to_context"] = 'クリックするとコンテキストメニュー';
$_lang["click_to_edit_title"] = '編集はここをクリック';
$_lang["click_to_view_details"] = '詳細を見る';
$_lang["close"] = '閉じる';
$_lang["collapse_tree"] = 'ツリーの縮小';
$_lang["comment"] = 'コメント';
$_lang["configcheck_admin"] = 'システム管理者に連絡をとり、このメッセージを報告してください!';
$_lang["configcheck_cache"] = 'キャッシュディレクトリに書き込みができません';
$_lang["configcheck_cache_msg"] = 'MODxは、キャッシュディレクトリにキャッシュファイルを書き込みことができませんでした。MODxは動作しますが、キャッシュファイルは保存されません。この問題を解消するには、 /_cache/ ディレクトリを書き込み可能にしてください。';
$_lang["configcheck_configinc"] = '設定ファイルがまだ書き込み可能になっています';
$_lang["configcheck_configinc_msg"] = '悪意ある人たちはあなたのサイトや関連するあらゆるものを壊すことができてしまいます。<strong>本当です！</strong> 設定ファイル (/manager/includes/config.inc.php) を書込み不可にしてください！';
$_lang["configcheck_default_msg"] = '不明な警告が見つかりました。';
$_lang["configcheck_errorpage_unavailable"] = 'あなたが設定した「エラーページ」は利用できません';
$_lang["configcheck_errorpage_unavailable_msg"] = 'これは、あなたが設定した「エラーページ」が一般的なエンドユーザからアクセスできないページ（private）かあるいは存在しないことを意味しています。これはシステムがループ状態を陥り、多くのエラーメッセージをエラーログに刻むでしょう。「エラーページ」には存在するページでかつ、公開ページ、かつ「public」なページを指定してください。';
$_lang["configcheck_errorpage_unpublished"] = 'MODx設定で設定されたエラーページは公開されていません。';
$_lang["configcheck_errorpage_unpublished_msg"] = 'これはあなたが設定したエラーページが誰でも見られるようにはなっていないことを意味します。エラーページは全ての人(Public)に公開するようにしてください。';
$_lang["configcheck_images"] = 'イメージディレクトリに書き込みができません';
$_lang["configcheck_images_msg"] = 'イメージディレクトリが書き込み可能でないか、またはイメージディレクトリが存在していません。エディタのイメージマネージャ機能が動作しません!';
$_lang["configcheck_installer"] = 'インストーラが残されています';
$_lang["configcheck_installer_msg"] = 'install/ ディレクトリにMODxインストーラが残されています。悪意を持った人がインストーラを動かしたら何が起きるか想像してください! データベースのユーザ情報を入力する必要がありますので、恐らくその先には行けませんが、サーバよりこのフォルダを削除されることをお勧めします。';
$_lang["configcheck_lang_difference"] = '言語ファイルのエントリ数が異なります';
$_lang["configcheck_lang_difference_msg"] = '現在選択されている言語ファイルのエントリ数がデフォルト言語ファイルのエントリと異なります。特に問題ではありませんが、言語ファイルをアップデートする必要があります。';
$_lang["configcheck_notok"] = '一つまたはそれ以上の設定に問題があります: ';
$_lang["configcheck_ok"] = '確認OK - 警告はありません。';
$_lang["configcheck_register_globals"] = '現在の環境では php.ini でregister_globals が ON になっています。';
$_lang["configcheck_register_globals_msg"] = 'この設定ではサイトがクロスサイトスクリプティング攻撃（略してXSS）に対してより脆弱になります。この設定を無効にするよう自分で設定ファイルを変更するか、管理者に依頼するかすべきです。';
$_lang["configcheck_title"] = '設定チェック';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'あなたのサイトの「権限外告知のページ」は公開されていないか、存在しません';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'これは、あなたが設定した「権限外告知のページ」が一般的なエンドユーザからアクセスできないページ（private）かあるいは存在しないことを意味しています。システムがループ状態に陥り、多くのエラーメッセージをエラーログに刻むでしょう。「権限外告知のページ」には存在するページでかつ、公開ページ、かつ「public」なページを指定してください。';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'MODx設定で設定された権限外告知のページは公開されていません。';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = '設定した権限外告知のページが誰でも見られるようにはなっていない事を意味します。権限外告知ページは全ての人「Public」に公開するようにしてください。';
$_lang["configcheck_warning"] = '設定警告:';
$_lang["configcheck_what"] = 'どういう意味ですか?';
$_lang["confirm_block"] = '本当にこのユーザをアクセス拒否してもよろしいですか?';
$_lang["confirm_delete_document"] = '本当にこのドキュメントを削除してもよろしいですか?\n全ての子ドキュメントも同時に削除されます。';
$_lang["confirm_delete_eventlog"] = '本当にこのログエントリを削除してもよろしいですか?';
$_lang["confirm_delete_file"] = '本当にこのファイルを削除してもよろしいですか?\n\n削除することでサイトが正常に動作しない場合もあります! 他に影響を及ぼさないことを理解している場合のみ削除してください。';
$_lang["confirm_delete_htmlsnippet"] = '本当にこのチャンクを削除してもよろしいですか?';
$_lang["confirm_delete_keywords"] = '本当にこれらのキーワードを削除してもよろしいですか?';
$_lang["confirm_delete_module"] = '本当にこのモジュールを削除してもよろしいですか?';
$_lang["confirm_delete_plugin"] = '本当にこのプラグインを削除してもよろしいですか?';
$_lang["confirm_delete_record"] = '本当にこのレコードを削除してもよろしいですか?';
$_lang["confirm_delete_role"] = '本当にこの権限を削除してもよろしいですか?';
$_lang["confirm_delete_snippet"] = '本当にこのスニペットを削除してもよろしいですか?';
$_lang["confirm_delete_tags"] = '本当にこのMETAタグを削除してもよろしいですか?';
$_lang["confirm_delete_template"] = '本当にこのテンプレートを削除してもよろしいですか?';
$_lang["confirm_delete_tmplvars"] = '本当にこのテンプレート変数と格納されている値を全て削除してもよろしいですか?';
$_lang["confirm_delete_user"] = '本当にこのユーザを削除してもよろしいですか?';
$_lang["confirm_duplicate_document"] = '本当にこのドキュメントを複製してもよろしいですか？配下のフォルダやドキュメントも複製されます。';
$_lang["confirm_duplicate_record"] = '本当にこのレコードを複製してもよろしいですか?';
$_lang["confirm_empty_trash"] = '全ての削除済みドキュメントを完全に消去しますか?\n\n続けますか?';
$_lang["confirm_load_depends"] = '本当に変更を保存せずに「依存性の管理」画面をロードしてもよろしいですか?';
$_lang["confirm_name_change"] = 'ユーザ名を変更するとMODxにリンクする他のアプリケーションに影響が及ぶ場合があります。 \n\n ほんとうにユーザ名を変更してよろしいですか?';
$_lang["confirm_publish"] = '\n\nこのドキュメントを公開することで、設定された公開/公開取消日時は上書きされます。公開・公開取消日時をそのままにしたい場合は代わりに「ドキュメントの編集」を選択してください。\n\n続けますか?';
$_lang["confirm_remove_locks"] = '他ユーザが編集操作を正常に終了しなかったため残されたロックを全て解除します。\n\n続けますか?';
$_lang["confirm_unblock"] = '本当にこのユーザのアクセス拒否を解除してもよろしいですか?';
$_lang["confirm_undelete"] = '\n\nこのドキュメントと同時に削除された子ドキュメントの削除が取り消されます。このドキュメントの削除以前に削除された子ドキュメントは削除されたままです。';
$_lang["confirm_unpublish"] = '\n\nこのドキュメントの公開を取り消すことで、設定された公開/公開取消日時は上書きされます。公開・公開取消日時をそのままにしたい場合は「ドキュメントの編集」を選択してください。\n\n続けますか?';
$_lang["confirm_unzip_file"] = 'このファイルを解凍してよろしいですか?\n\n既にあるファイルは上書きされます。';
$_lang["could_not_find_user"] = 'ユーザが見つかりません';
$_lang["createdon"] = '作成日時';
$_lang["create_document_here"] = 'ドキュメントの作成';
$_lang["create_folder_here"] = 'フォルダの作成';
$_lang["create_weblink_here"] = 'ウェブリンクの作成';
$_lang["credits"] = '著作権表示/謝辞';
$_lang["credits_dTree"] = 'MODxは、DestroyDrop.com のすばらしい dTree script を利用しています!';
$_lang["credits_everaldo"] = 'MODxは、Everaldo のクリスタルアイコン・セットを多く利用しています。すばらしいアイコンです!';
$_lang["credits_mysql"] = 'MODx は MySQL によって動作しています!';
$_lang["credits_php"] = 'MODx は PHP によって動作しています!';
$_lang["credits_shouts_msg"] = '
<ul>
<li><b>Raymond Irving, Ryan Thrash</b> - プロジェクト創始者</li>
<li><b>Jason Coward, Victor Brilon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</b> - コアアーキテクチャ &amp; デザイン</li>
</ul>';
$_lang["credits_shouts_title"] = '<b>さらなる感謝:</b>';
$_lang["credits_webfx"] = 'MODx は Webfx の JavaScripts を多く利用しています。すばらしいスクリプトです!';
$_lang["custom_contenttype_message"] = 'ドキュメントが使用するコンテントタイプに独自のものを追加できます。新しいタイプを追加するにはテキストボックスに入力して「追加」ボタンをクリックします。';
$_lang["custom_contenttype_title"] = 'カスタムコンテントタイプ:';
$_lang["database_name"] = 'データベース名';
$_lang["database_server"] = 'データベースサーバ';
$_lang["database_tables"] = 'テーブル一覧';
$_lang["database_overhead"] = '<b style=\'color:#990033\'>注:</b>オーバーヘッドはMySQLが確保しているけれど使用はしていない領域を言います。この領域を開放するにはオーバーヘッドの数字をクリックしてください。';
$_lang["database_table_clickhere"] = 'ここをクリック';
$_lang["database_table_clickbackup"] = '選択したテーブルをバックアップ・ダウンロード';
$_lang["database_table_datasize"] = 'データサイズ';
$_lang["database_table_droptablestatements"] = 'DROP文を生成';
$_lang["database_table_effectivesize"] = '有効サイズ';
$_lang["database_table_indexsize"] = 'インデックス';
$_lang["database_table_overhead"] = 'オーバヘッド';
$_lang["database_table_records"] = '件数';
$_lang["database_table_tablename"] = 'テーブル名';
$_lang["database_table_totalsize"] = '合計サイズ';
$_lang["database_table_totals"] = '総計:';
$_lang["date"] = '日付';
$_lang["datechanged"] = '編集日時';
$_lang["defaultcache_message"] = '全ての新しいドキュメントをデフォルトでキャッシュ可能にする場合は「Yes」を選択してください。';
$_lang["defaultcache_title"] = 'キャッシュデフォルト';
$_lang["defaultmenuindex_message"] = 'メニューインデックスを自動的に増分する機能を有効にするには「Yes」を選択してください。';
$_lang["defaultmenuindex_title"] = 'メニューインデックス自動増分';
$_lang["defaultpublish_message"] = '全ての新しいドキュメントをデフォルトで公開する場合は「Yes」を選択してください。';
$_lang["defaultpublish_title"] = '公開デフォルト';
$_lang["defaultsearch_message"] = '全ての新しいドキュメントをデフォルトで検索可能にする場合は「Yes」を選択してください。';
$_lang["defaultsearch_title"] = '検索可能デフォルト';
$_lang["defaulttemplate_message"] = '新しいドキュメントに使用するデフォルトテンプレートを選択してください。ドキュメントエディタで別途異なるテンプレートを選択することもできます。この設定はテンプレートの中から既定にするものを選択するのみです。';
$_lang["defaulttemplate_title"] = 'デフォルトテンプレート';
$_lang["delete"] = '削除';
$_lang["delete_document"] = 'ドキュメントの削除';
$_lang["delete_tags"] = 'タグの削除';
$_lang["deleting_file"] = '「 %s 」の削除: ';
$_lang["description"] = '説明';
$_lang["deselect_keywords"] = 'キーワードの選択解除';
$_lang["deselect_metatags"] = 'METAタグのクリア';
$_lang["disabled"] = '停止';
$_lang["document"] = 'ドキュメント';
$_lang["document_alias"] = 'ドキュメントエイリアス';
$_lang["document_alias_help"] = 'このドキュメントのエイリアスを指定することができます。次のようにドキュメントにアクセスすることができます:\n\nhttp://yourserver/エイリアス\n\nエイリアスはフレンドリーURLを使用する場合のみ動作します。';
$_lang["document_content"] = '内容';
$_lang["document_description"] = '説明';
$_lang["document_description_help"] = 'ドキュメントに関する任意の説明をここに入力することができます';
$_lang["document_long_title_help"] = 'ドキュメントの長いタイトルを入力してください。これはサーチエンジンに対して効果があります。ドキュメントの詳細な情報を記述することができます。';
$_lang["document_metatag_help"] = 'このドキュメントに付加したいMETAタグやキーワードを選択してください。CTRLキーをクリックと同時に押す事で複数のタグやキーワードを選択できます。';
$_lang["document_opt_contentdispo"] = '内容の配置';
$_lang["document_opt_contentdispo_help"] = 'この内容の配置フィールドを用いてウェブブラウザがこのドキュメントをどう扱うか指定することができます。「Attachment」を選択するとウェブブラウザはドキュメントをダウンロードファイルとみなします。';
$_lang["document_opt_emptycache"] = 'キャッシュのクリア?';
$_lang["document_opt_emptycache_help"] = 'このオプションをチェックしておくと、MODxはドキュメントが保存された直後に自動的にキャッシュをクリアします。この設定をすることで、訪問者に古いバージョンのドキュメントが表示されません。';
$_lang["document_opt_folder"] = 'フォルダ?';
$_lang["document_opt_folder_help"] = 'ドキュメントをフォルダとしても扱いたい場合にチェックしてください。MODxがフォルダ設定を自動的に行いますので、あまり心配する必要はありません。';
$_lang["document_opt_menu_index"] = 'メニューインデックス';
$_lang["document_opt_menu_index_help"] = 'メニューインデックスは、メニュースニペット内でドキュメントを並び替えるために使用できます。また、スニペット内で他の目的に使用することもできます。';
$_lang["document_opt_menu_title"] = 'メニュータイトル';
$_lang["document_opt_menu_title_help"] = 'メニュータイトルは、メニュースニペットやモジュールで使用できるドキュメントの短いタイトルです。';
$_lang["document_opt_published"] = '公開?';
$_lang["document_opt_published_help"] = '保存後、すぐにドキュメントを公開する場合はチェックしてください。';
$_lang["document_opt_richtext"] = 'リッチテキスト?';
$_lang["document_opt_richtext_help"] = 'ドキュメントの編集にリッチテキストエディタを使用する場合は、チェックしたままにしてください。ドキュメントがJavaスクリプトやフォームを含んでいる場合は、エディタがドキュメントを壊さないように、チェックを外してHTMLモードによる編集を行ってください。';
$_lang["document_opt_show_menu"] = 'メニューに表示';
$_lang["document_opt_show_menu_help"] = 'メニューにこのドキュメントを表示するにはこのオプションをチェックしてください。メニュー作成スニペットにはこのオプションを無視するものもある事に注意してください。';
$_lang["document_opt_trackvisit_help"] = 'このページへの訪問者をログ';
$_lang["document_overview"] = 'ドキュメントの詳細';
$_lang["document_parent"] = '親ドキュメント';
$_lang["document_parent_help"] = '上のフォルダアイコンをクリックすると、このドキュメントの親を選択する状態になります（もう一度クリックすると元に戻ります）。次に新しい親ドキュメントをツリー内でクリックしてください。';
$_lang["document_setting"] = 'ドキュメント設定';
$_lang["document_summary"] = '要約（序説）';
$_lang["document_summary_help"] = 'ドキュメントの要約を簡潔に入力してください';
$_lang["document_title"] = 'タイトル';
$_lang["document_title_help"] = 'ドキュメントの名称/タイトルを入力してください。バックスラッシュは使用しないでください!';
$_lang["document_to_be_moved"] = '移動対象ドキュメント';
$_lang["document_weblink_help"] = 'ウェブリンクで参照したい対象のアドレスを入力してください。';
$_lang["documents_in_container"] = "つの子ドキュメントをこのドキュメントは持っています";
$_lang["documents_in_container_no"] = "このドキュメントは子ドキュメントを持っていません";
$_lang["doc_data_title"] = 'ドキュメントデータを見る';
$_lang["duplicate"] = '複製';
$_lang["duplicate_alias_found"] = '\'%s\'というドキュメントが\'%s\'というエイリアスを既に使用しています。別のエイリアスを入力してください。';
$_lang["duplicate_alias_message"] = '「Yes」を選択すると重複するエイリアスを保存できるようになります。<b>注意: このオプションは「フレンドリエイリアス」オプションとともに使用します。ドキュメント参照時に起きる問題を回避できます。</b>';
$_lang["duplicate_alias_title"] = '重複エイリアスを許可:';
$_lang["duplicate_document"] = 'ドキュメントの複製';
$_lang["edit"] = '編集';
$_lang["editedon"] = '編集日時';
$_lang["editing_file"] = 'ファイルの編集: ';
$_lang["editor_css_path_message"] = 'エディタ中で使用するCSSファイルへのパスを入力します。パスはサーバールートからの絶対パスを入力すべきです。例えば「/assets/site/style.css」という具合に。もしスタイルシートをロードする必要が無ければ、このフィールドは空白のままにして置きます。';
$_lang["editor_css_path_title"] = 'CSSファイルへのパス:';
$_lang["edit_document"] = 'ドキュメントの編集';
$_lang["edit_document_title"] = 'ドキュメントの作成/編集';
$_lang["edit_settings"] = 'MODx設定';
$_lang["email"] = 'Eメール';
$_lang["emailsender_message"] = 'ユーザにユーザ名とパスワードを送信時の送信元メールアドレスを指定してください。';
$_lang["emailsender_title"] = '送信者メールアドレス:';
$_lang["emailsubject_message"] = 'サインアップメールの件名を指定してください。';
$_lang["emailsubject_title"] = 'メール件名:';
$_lang["email_sent"] = 'メールを送信しました';
$_lang["empty_folder"] = 'フォルダは空です';
$_lang["empty_recycle_bin"] = '削除済みドキュメントを消去';
$_lang["empty_recycle_bin_empty"] = '消去するための削除済みドキュメントがありません。';
$_lang["enabled"] = '有効';
$_lang["enable_resource"] = 'リソースファイルを有効に';
$_lang["enable_sharedparams"] = '共有パラメータを使用';
$_lang["enable_sharedparams_msg"] = '<b>注意:</b> 上のglobally unique id (GUID)はこのモジュールとその共有パラメータを一意に識別するために用いられます。GUIDは、モジュールと、共有パラメータにアクセスするプラグインやスニペットとの間のリンクにも用いられます。';
$_lang["error"] = 'エラー';
$_lang["errorpage_message"] = 'ドキュメントが存在しない場合のエラーページとして表示するドキュメントのIDを入力してください。<b>注意: 既に存在するドキュメントのIDを入力してください。ドキュメントは公開されている必要があります!</b>';
$_lang["errorpage_title"] = 'エラーページ:';
$_lang["error_sending_email"] = 'メール送信中にエラー';
$_lang["eventlog"] = 'イベントログ';
$_lang["eventlog_msg"] = 'イベントログはMODxが作成する告知・警告・エラーの各メッセージを表示するものです。「元」列にはメッセージを発したマネージャの部分を表示します。';
$_lang["eventlog_viewer"] = 'イベントログ';
$_lang["event_id"] = 'イベントID';
$_lang["existing_category"] = '既存のカテゴリ';
$_lang["expand_tree"] = 'ツリーの展開';
$_lang["export_site"] = 'サイトのエクスポート';
$_lang["export_site_cacheable"] = '非キャッシュファイルを含む:';
$_lang["export_site_exporting_document"] = 'エクスポートファイル <b>%s</b> of <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style="color:#990000">失敗!</span>';
$_lang["export_site_html"] = 'サイト全体を静的HTMLとしてエクスポート';
$_lang["export_site_maxtime"] = '最大エクスポート時間:';
$_lang["export_site_maxtime_message"] = 'MODxがサイトのエクスポートに使用できる秒数を指定してください(PHPの設定を上書きします)。0の入力で時間無制限に設定します。0または非常に大きな数字を設定することで、サーバが正常に動作しない場合もありますのでお勧めしません。';
$_lang["export_site_message"] = '<p>この機能を使用することでサイト全体をHTMLファイルにエクスポートすることができます。しかし、下記の多くのMODxの機能を失うことになりますので注意してください:</p><p><ul><li>エクスポートファイルのページ閲覧はログに記録されません。</li><li>エクスポートファイルで動的なスニペットは動作しません。</li><li>通常のドキュメントのみエクスポートされ、ウェブリンクはエクスポートされません。</li><li>ドキュメントにリダイレクトヘッダを送信するスニペットが含まれている場合、エクスポートプロセスが失敗する場合があります。</li><li>ドキュメント、スタイルシート、イメージの記述方法により、サイトのデザインが崩れる場合があります。これを直すためには、MODxのindex.phpファイルが保存されている同じディレクトリに、エクスポートファイルを保存または移動してください。</li></ul></p><p>フォームに必要事項を入力して「エクスポートの開始」をクリックすると処理を開始します。作成されたファイルは、ドキュメントエイリアスをファイル名として、指定した場所に保存されます。サイトをエクスポートする場合、MODx設定で「フレンドリーエイリアス」を「Yes」にすることをお勧めします。サイトのサイズにより、エクスポートに暫く時間を要する場合もあります。</p><p><em>ファイル名が同じ場合、新しいファイルは既存のファイルに上書きされます!</em></p>';
$_lang["export_site_numberdocs"] = '<b>%s 個のエクスポート対象ドキュメントが見つかりました...</b><p/>';
$_lang["export_site_prefix"] = 'ファイル名の接頭辞:';
$_lang["export_site_start"] = 'エクスポートの開始';
$_lang["export_site_success"] = '<span style="color:#009900">成功!</span>';
$_lang["export_site_suffix"] = 'ファイル名の接尾辞:';
$_lang["export_site_target_unwritable"] = 'ターゲットディレクトリが書き込みができません。ディレクトリが書き込み可能であるか確認して、再度処理を行ってください。';
$_lang["export_site_time"] = 'エクスポートが完了しました。エクスポートに要した時間は %s 秒です。';
$_lang["failed_login_message"] = 'ユーザアカウントがロックされるまで何回ログイン失敗を許すか回数を入力します。';
$_lang["failed_login_title"] = 'ログイン失敗の回数:';
$_lang["fe_editor_lang_message"] = 'フロントエンドエディタとはQuickEditによる内容編集で用いるリッチテキストエディタです。使用するときの言語を選んでください。';
$_lang["fe_editor_lang_title"] = 'フロントエンドエディタの言語:';
$_lang["filemanager_path_message"] = '多くの場合IISではドキュメントルートの設定が適切に得られません。ドキュメントルート情報はファイルマネージャで扱える範囲を決定してしまいます。ファイルマネージャの使用で問題がある場合は、この項目がインストールしたMODxのルートディレクトリを指しているか確認してください。';
$_lang["filemanager_path_title"] = 'ファイルマネージャパス:';
$_lang["files_access_denied"] = 'アクセスが拒否されました!';
$_lang["files_data"] = 'データ';
$_lang["files_directories"] = 'ディレクトリ';
$_lang["files_dirwritable"] = 'ディレクトリ書き込み可?';
$_lang["files_dir_listing"] = 'ディレクトリ一覧:';
$_lang["files_editfile"] = 'ファイルの編集';
$_lang["files_filename"] = 'ファイル名';
$_lang["files_fileoptions"] = 'オプション';
$_lang["files_files"] = 'ファイル';
$_lang["files_filesize"] = 'ファイルサイズ';
$_lang["files_filetype_notok"] = 'この種類のファイルはアップロードできません!';
$_lang["files_file_type"] = 'ファイルタイプ: ';
$_lang["files_modified"] = '編集日時';
$_lang["files_title"] = 'ファイルブラウザ';
$_lang["files_top_level"] = 'トップレベルへ移動';
$_lang["files_uploadfile"] = 'ファイルのアップロード';
$_lang["files_uploadfile_msg"] = 'アップロードするファイルを選択してください:';
$_lang["files_uploading"] = '<b>%s</b>を<b>%s/</b>にアップロードしました。<br />';
$_lang["files_upload_copyfailed"] = 'コピー先ディレクトリへのファイルコピーが失敗しました - アップロード失敗!';
$_lang["files_upload_error"] = 'エラー';
$_lang["files_upload_error0"] = 'アップロードに問題が発生しました。';
$_lang["files_upload_error1"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error2"] = 'アップロードしようとしたファイルは大きすぎます。';
$_lang["files_upload_error3"] = 'アップロードしようとしたファイルは一部分のみアップロードされました。';
$_lang["files_upload_error4"] = 'アップロードするファイルを選択してください';
$_lang["files_upload_error5"] = 'アップロード中に問題が発生しました。';
$_lang["files_upload_inhibited_msg"] = '<b>アップロード機能が使用できません。</b> - アップロードがサポートされているか、PHPがディレクトリに書込権を有しているかを確認してください。<br />';
$_lang["files_upload_ok"] = 'ファイルのアップロードが完了しました!';
$_lang["files_up_level"] = '1レベル上へ移動';
$_lang["files_viewfile"] = 'ファイルの表示';
$_lang["file_deleted"] = '成功!';
$_lang["file_delete_file"] = 'ファイルの削除';
$_lang["file_delete_folder"] = 'フォルダの削除';
$_lang["file_download_file"] = 'ファイルのダウンロード';
$_lang["file_download_unzip"] = 'ファイルの解凍';
$_lang["file_folder_chmod_error"] = 'アクセス権の変更が出来ません。MODx 以外の方法でアクセス権を変更してください。';
$_lang["file_folder_created"] = 'フォルダを作成しました!';
$_lang["file_folder_deleted"] = 'フォルダを削除しました!';
$_lang["file_folder_not_created"] = 'フォルダを作成できません';
$_lang["file_folder_not_deleted"] = 'フォルダを削除できません。フォルダを削除する前に中身が空である事を確認してください!';
$_lang["file_not_deleted"] = '失敗!';
$_lang["file_not_saved"] = 'ファイルを保存できません、ターゲットディレクトリが書き込み可能か確認してください!';
$_lang["file_saved"] = 'ファイルが正常に保存されました!';
$_lang["file_unzip"] = '解凍に成功しました!';
$_lang["file_unzip_fail"] = '解凍に失敗しました!';
$_lang["folder"] = 'フォルダ';
$_lang["forgot_password_email_fine_print"] = '注意：上記のURLは明日あるいは一度パスワード変更をすると無効になります。';
$_lang["forgot_password_email_instructions"] = 'そのページの「私のアカウント」メニューからパスワードを変更することができます。';
$_lang["forgot_password_email_intro"] = 'アカウントへのパスワード変更リクエストを受け付けました。';
$_lang["forgot_password_email_link"] = '処理を完了するためここをクリックしてください。';
$_lang["forgot_your_password"] = 'パスワード紛失';
$_lang["friday"] = '金曜';
$_lang["friendlyurlsprefix_message"] = 'ユーザフレンドリーURLの接頭辞を指定してください。例えば接頭辞を「page」に設定した場合、URLの /index.php?id=2 は、 /page2.htmlというユーザフレンドリーURLに変換されます(接尾辞が .htmlに設定されていると仮定して)。このように、ユーザ(そしてサーチエンジン)が、サイトを閲覧するためのリンクを指定することができます。';
$_lang["friendlyurlsprefix_title"] = 'フレンドリーURLの接頭辞:';
$_lang["friendlyurlsuffix_message"] = 'ユーザフレンドリーURLの接尾辞を指定してください。例えば「.html」と指定すると、全てのユーザフレンドリーURLの末尾に .htmlを追加します。';
$_lang["friendlyurlsuffix_title"] = 'フレンドリーURLの接尾辞:';
$_lang["friendlyurls_message"] = 'MODx がSEOに有効な（フレンドリーな）URLを使用するか設定します。この機能はMODxがApache上で動作している時のみ有効です。この機能を動作させるために .htaccessファイルを用意する必要があります。詳細は一緒に配布されている .htaccessファイルをご覧ください。';
$_lang["friendlyurls_title"] = 'フレンドリーURLの使用:';
$_lang["friendly_alias_message"] = 'フレンドリーURLを使用して、かつドキュメントがエイリアスを持つ場合、エイリアスは常にフレンドリーURLに優先します。このオプションを「Yes」に設定することで、フレンドリーURLの接頭辞と接尾辞もエイリアスに適用されます。例えば、ドキュメントのIDが1、エイリアスが「introduction」、接頭辞が「」、接尾辞が「.html」の場合、このオプションを「Yes」にすると、URLは「introduction.html」となります。 エイリアスを設定していない場合は、MODxが「1.html」というリンクを生成します。';
$_lang["friendly_alias_title"] = 'フレンドリーエイリアス:';
$_lang["functionnotimpl"] = 'ごめんなさい!';
$_lang["functionnotimpl_message"] = 'この機能は、まだ実装されていません';
$_lang["go"] = 'Go';
$_lang["group_access_permissions"] = 'ユーザグループのアクセス';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'ヘルプ';
$_lang["help_msg"] = '<p><a href="http://modxcms.com/forums" target="_blank">MODx フォーラム</a>を訪れる事で、気軽にコミュニティからサポートを得られるでしょう。そこには、ますます成長しつつある<a href="http://modxcms.com/documentation" target="_blank">MODx マニュアルとガイド</a>があり、MODxのほとんどあらゆる面について記されています。</p><p>また、MODxの有償サポートサービスの提供が計画されています。興味がおありの方は<a href="mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry">eメール</a>にてお問い合わせください。</p>';
$_lang["help_title"] = 'ヘルプ';
$_lang["hide_tree"] = 'ツリーを非表示';
$_lang["home"] = 'ホーム';
$_lang["htmlsnippet_desc"] = 'チャンクの説明';
$_lang["htmlsnippet_management_msg"] = '<h3 style="font-weight:bold;">チャンクの管理</h3><p>編集したいチャンクを選択してください。チャンクは、パーツ感覚で利用できる「生の」HTMLコードです。ドキュメントやテンプレートから手軽に呼び出すことができます。PHPコードを記述する場合はスニペットを利用してください。</p>';
$_lang["htmlsnippet_msg"] = 'チャンクを追加・編集することができます。チャンクは、パーツ感覚で利用できる「生の」HTMLコードです。ドキュメントやテンプレートから手軽に呼び出すことができます。PHPコードを記述する場合はスニペットを利用してください。';
$_lang["htmlsnippet_name"] = 'チャンク名';
$_lang["htmlsnippet_title"] = 'チャンクの作成/編集';
$_lang["icon"] = 'アイコン';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = '親の指定:\n\nドキュメントは選択したドキュメントの子です。';
$_lang["illegal_parent_self"] = '親の指定:\n\n自分自身を親に割り当てる事はできません。';
$_lang["import_files_found"] = '<b>インポートする %s個のドキュメントを見つけました...</b><p/>';
$_lang["import_params"] = '共有パラメータのインポート';
$_lang["import_params_msg"] = '上のドロップダウンメニューからモジュール名を選択する事により、他のモジュールのパラメータや設定をインポートすることができます。 <b>注意:</b>メニューにモジュールが表示されるためには、このプラグインやスニペットがモジュール依存リストにありモジュールの共有パラメータ使用がONである必要があります。 ';
$_lang["import_parent_document"] = '親ドキュメント:';
$_lang["import_site"] = 'サイトのインポート';
$_lang["import_site_failed"] = '<span style="color:#990000">失敗です!</span>';
$_lang["import_site_html"] = 'HTMLからサイトをインポート';
$_lang["import_site_importing_document"] = 'インポート中のファイル <b>%s</b> ';
$_lang["import_site_maxtime"] = '最大インポート時間:';
$_lang["import_site_maxtime_message"] = 'MODxがサイトのインポート処理に使用できる最大秒数を指定します。（PHPの指定処理秒数を上書きします）0は処理時間の制限なしを意味します。0や大きな数字を指定する事はサーバに負荷をかけ問題を起こしやすくなります、お勧めできません。';
$_lang["import_site_message"] = 'この機能を使うと、HTMLで記述されたサイトを丸ごとデータベースにインポートすることができます。まずインポートするファイルやフォルダをassets/importフォルダにコピーして置きます。<p />そしてこのフォームに必要事項を入力して「インポート開始」ボタンをクリックすればスタートします。インポートしたファイルのデータはドキュメントツリーの選択した場所に格納されます。ファイル名はエイリアスになり、ページタイトルはドキュメントのタイトルになります。';
$_lang["import_site_skip"] = '<span style="color:#990000">処理をスキップしました</span>';
$_lang["import_site_start"] = 'インポート開始';
$_lang["import_site_success"] = '<span style="color:#009900">成功です!</span>';
$_lang["import_site_time"] = 'インポート終了。インポートには %s 秒かかりました。';
$_lang["inbox"] = '受信トレイ';
$_lang["info"] = '情報';
$_lang["information"] = '情報';
$_lang["inline"] = 'Inline';
$_lang["insert"] = '挿入';
$_lang["insert_snippet"] = 'スニペットをドキュメントに挿入';
$_lang["keyword"] = 'キーワード';
$_lang["keywords"] = 'キーワード';
$_lang["keywords_intro"] = 'キーワードを編集するには変更したいキーワードの隣のテキストエリアに新しいキーワードを入力するだけです。キーワードを削除するにはキーワードの削除チェックボックスをチェックします。削除ボックスをチェックしたうえキーワードの変更をしても単に削除されるだけです。他のキーワードには影響がありません!';
$_lang["language_message"] = 'MODxマネージャの使用言語を選択してください';
$_lang["language_title"] = '言語:';
$_lang["launch_site"] = 'サイトを表示';
$_lang["link_attributes"] = 'リンク属性';
$_lang["link_attributes_help"] = 'このページへのリンクに属性を付加することができます。\n\n例：target=&ldquo;_blank&rdquo;、rel=&ldquo;next&rdquo;';
$_lang["list_mode"] = 'リストモードのON/OFF - グリッドに全てのレコードをリストするために使われます。';
$_lang["loading_doc_tree"] = 'ツリーのローディング中 ...';
$_lang["loading_menu"] = 'メニューのローディング中 ...';
$_lang["loading_page"] = 'MODxはページをロードしています。お待ちください ...';
$_lang["localtime"] = 'ローカル時刻';
$_lang["locked"] = 'ロック';
$_lang["lock_htmlsnippet"] = 'チャンクの編集をロック';
$_lang["lock_htmlsnippet_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["lock_module"] = 'モジュールをロック';
$_lang["lock_module_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["lock_msg"] = '%s が %s を今編集中です。他のユーザが終了するまでしばらくお待ちの上再度操作願います。';
$_lang["lock_plugin"] = 'プラグインをロック';
$_lang["lock_plugin_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["lock_settings_msg"] = '%s が設定を編集中です。他のユーザが終了するまでしばらくお待ちの上再度操作願います。';
$_lang["lock_snippet"] = 'スニペットをロック';
$_lang["lock_snippet_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["lock_template"] = 'テンプレートの編集をロック';
$_lang["lock_template_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["lock_tmplvars"] = '変数をロック';
$_lang["lock_tmplvars_msg"] = '管理者(権限ID 1)のみ編集できます。';
$_lang["login_allowed_days"] = '曜日制限';
$_lang["login_allowed_days_message"] = 'このユーザがログインできる曜日を選択してください';
$_lang["login_allowed_ip"] = 'IPアドレス制限';
$_lang["login_allowed_ip_message"] = 'このユーザがログインできるIPアドレスを入力してください。 <b>注意: 複数のIPアドレスの場合はカンマ(,)で区切ってください</b>';
$_lang["login_button"] = 'ログイン';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">このサイトは、現在アップデートまたはインストール作業中です。<br />申し訳ありませんが、しばらく経ってからもう一度ログインしてください。</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">このサイトは、アップデートまたはインストールが実行されしまた。申し訳ありませんが、もう一度ログインし直してください。</span><br />';
$_lang["login_captcha_message"] = '画像で表示されるセキュリティコードを入力してください。セキュリティコードが読めない場合は画像をクリックすると画像は再生成されます。もしくはサイト管理者に連絡をお願います。';
$_lang["login_homepage"] = 'ログインするホームページ';
$_lang["login_homepage_message"] = 'ログインしたウェブユーザに対して表示するドキュメントのIDを入力してください。 <b>注意: 入力するIDは既に存在するドキュメントのものでないといけません。また公開中でしかもユーザがアクセス可能であるものに限ります!</b>';
$_lang["login_message"] = 'MODxマネージャを開始するには、ログインしてください。ユーザ名とパスワードは大文字小文字の区別をしますので、慎重に入力してください!';
$_lang["logout"] = 'ログアウト';
$_lang["logo_slogan"] = 'MODx Content Manager - \nCreate and do more with less';
$_lang["long_title"] = '長いタイトル';
$_lang["mail_check_timeperiod_title"] = 'メールチェックのタイミング:';
$_lang["mail_check_timeperiod_message"] = 'どれくらいの間隔でメールチェックをするか「秒」で指定します';
$_lang["manager"] = 'マネージャ';
$_lang["manager_direction_message"] = 'マネージャでのテキストの流れる方向を指定します。「ltr」は、左から右。「rtl」は、右から左です。主にアラビア語圏などで利用する設定です。';
$_lang["manager_direction_title"] = 'テキストの方向:';
$_lang['manager_lockout_message'] = 'MODxマネージャ(管理画面)にログインしています。セッションを閉じたいときは「ログアウト」ボタンをクリックしてください。<p />マネージャホームあるいはスタート画面に行きたいときは「ホーム」ボタンをクリックします。';
$_lang["manager_permissions"] = 'マネージャへのアクセス許可';
$_lang["manager_theme"] = 'マネージャのテーマ:';
$_lang["manager_theme_message"] = 'マネージャが使用するテーマを選択してください。';
$_lang["manage_depends"] = '依存性の管理';
$_lang["manage_files"] = 'ファイル管理';
$_lang["manage_htmlsnippets"] = 'チャンク';
$_lang["manager_lang_attribute_message"] = 'マネージャでの HTML 要素の lang属性、xml:lang 属性指定します。「言語」で選択した言語にマッチする言語コードを指定してください。通常、日本語環境では「ja」を指定します。この指定を的確に行うことで、ブラウザはコンテンツを最適なフォーマットであなたに提供するでしょう。';
$_lang["manager_lang_attribute_title"] = 'マネージャの言語コード:';
$_lang["manage_metatags"] = 'METAタグとキーワードの管理';
$_lang["manage_modules"] = 'モジュールの管理';
$_lang["manage_plugins"] = 'プラグイン';
$_lang["manage_snippets"] = 'スニペット';
$_lang["manage_templates"] = 'テンプレート';
$_lang["messages"] = 'メッセージ';
$_lang["messages_all"] = '全員';
$_lang["messages_compose"] = 'メッセージの作成';
$_lang["messages_forward"] = '転送';
$_lang["messages_from"] = 'From';
$_lang["messages_group"] = 'グループ';
$_lang["messages_inbox"] = '受信トレイ';
$_lang["messages_message"] = 'メッセージ';
$_lang["messages_not_allowed_to_read"] = 'このメッセージを読むことはできません!';
$_lang["messages_no_messages"] = '受信トレイにメッセージはありません。';
$_lang["messages_private"] = 'プライベート';
$_lang["messages_read_message"] = 'メッセージを読む';
$_lang["messages_reply"] = '返信';
$_lang["messages_select_group"] = 'グループを選択';
$_lang["messages_select_user"] = 'ユーザを選択';
$_lang["messages_send"] = '送信';
$_lang["messages_send_to"] = '送信先';
$_lang["messages_sent"] = '送信日時';
$_lang["messages_subject"] = '件名';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'メッセージ';
$_lang["messages_user"] = 'ユーザ';
$_lang["metatags"] = 'METAタグ';
$_lang["metatags_and_keywords"] = 'METAタグとキーワード';
$_lang["metatag_intro"] = 'ここでMETAタグの作成や削除、編集を行います。ドキュメントとMETAタグをリンクするにはドキュメントの編集中に「<u>META キーワード</u>」タブをクリックします。そして目的とするMETAタグとキーワードを選択します。新しいタグを追加するには、その名前と値を入力して「タグ追加」ボタンをクリックします。タグを編集するにはデータグリッド中のタグ名をクリックします。';
$_lang["metatag_notice"] = 'METAタグに関しての詳細は<a href="http://www.google.com/search?q=%22META%E3%82%BF%E3%82%B0%22" target="_blank">こちら</a>を参照してください。このリストは指定可能なMETAタグを網羅してはいません。';
$_lang["meta_keywords"] = 'META キーワード';
$_lang["mgr_access_permissions"] = 'マネージャアクセス許可';
$_lang["mgr_login_start"] = 'マネージャログイン開始ページ';
$_lang["mgr_login_start_message"] = 'ユーザがマネージャにログインしたとき、リダイレクトしたいドキュメントのIDを入力します。<b>注意: 入力するIDは、既に存在するドキュメントIDであり、ドキュメントは公開されていてこのユーザがアクセス可能である必要があります!</b>';
$_lang["mgrlog_action"] = 'アクション';
$_lang["mgrlog_actionid"] = 'ID';
$_lang["mgrlog_anyall"] = '全て';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() で誤りを検出しました。';
$_lang["mgrlog_datefr"] = 'この日付から';
$_lang["mgrlog_dateinvalid"] = '日付の形式が正しくありません。';
$_lang["mgrlog_dateto"] = 'この日付の前';
$_lang["mgrlog_emptysrch"] = 'この問合せの結果は空でした。（マッチするログエントリが無かったということです）';
$_lang["mgrlog_field"] = '分類';
$_lang["mgrlog_itemid"] = '対象ID';
$_lang["mgrlog_itemname"] = '対象名';
$_lang["mgrlog_msg"] = 'メッセージ';
$_lang["mgrlog_noquery"] = '検索されていません。';
$_lang["mgrlog_query_msg"] = 'マネージャのログに対する検索条件を指定します。日付でログエントリを選別することができますが、日付の条件指定は、「以上」「未満」です。例: 2004年1月1日のログを含めるには、 「この日付から」を 01-01-2004 に、「この日付の前」を 02-01-2004 にしてください。<br /><br />
メッセージとアクションはほぼ同じものです。何かのメッセージを探したいときは、まずはアクションを「全て」にしたままにしておくとよいでしょう。';
$_lang["mgrlog_results"] = '結果の件数';
$_lang["mgrlog_qresults"] = '結果';
$_lang["mgrlog_searchlogs"] = '検索の履歴';
$_lang["mgrlog_sortinst"] = '各欄のヘッダをクリックすることで表の表示順を変更できます。ログが溜まってきたときには、<a href="index.php?a=55">empty</a> をクリックすることでログを全部消去できます。 この操作は即実行され元に戻せません。';
$_lang["mgrlog_query"] = 'ログの検索';
$_lang["mgrlog_time"] = '時刻';
$_lang["mgrlog_user"] = 'ユーザ';
$_lang["mgrlog_username"] = 'ユーザ名';
$_lang["mgrlog_value"] = '値';
$_lang["mgrlog_view"] = 'マネージャログを見る';
$_lang["modules"] = 'モジュール';
$_lang["module_code"] = 'モジュール コード (php)';
$_lang["module_config"] = 'モジュール設定';
$_lang["module_desc"] = '説明';
$_lang["module_disabled"] = 'モジュールを停止';
$_lang["module_edit_click_title"] = 'このモジュールを編集';
$_lang["module_group_access_msg"] = 'MODxマネージャ内でこのモジュールを実行できるユーザグループを選択してください。';
$_lang["module_management"] = 'モジュール管理';
$_lang["module_management_msg"] = '実行や変更をしたいモジュールを選択します。モジュールを実行するにはグリッドの中のアイコンをクリックしてください。モジュールを変更するにはモジュール名をクリックしてください。';
$_lang["module_msg"] = 'ここでモジュールの追加・編集ができます。モジュールはリソース(プラグインやスニペットなど）)の集合体です。';
$_lang["module_name"] = 'モジュール名';
$_lang["module_resource_msg"] = 'このモジュールが依存するリソースを追加・削除することができます。新しいリソースを追加するには下のボタンのひとつをクリックします。';
$_lang["module_resource_title"] = 'モジュール依存';
$_lang["module_title"] = 'モジュールの作成/編集';
$_lang["module_viewdepend_msg"] = 'モジュールが依存するリソースの状況を見ることができます。依存性を変更するには「依存性の管理」ボタンをクリックします';
$_lang["modx_version"] = "MODxバージョン";
$_lang["monday"] = '月曜';
$_lang["move"] = '移動';
$_lang["move_document"] = 'ドキュメントの移動';
$_lang["move_document_message"] = 'ツリー内の新しい親ドキュメントを選択して、ドキュメントおよび子ドキュメントを移動することができます。フォルダではないドキュメントを親ドキュメントとして選択した場合、ドキュメントはフォルダに変更されます。 ツリー内の新しい親ドキュメントをクリックしてください。';
$_lang["move_document_new_parent"] = '新しい親ドキュメントをツリーから選択してください';
$_lang["move_document_title"] = 'ドキュメントの移動';
$_lang["name"] = '名前';
$_lang["new_category"] = 'カテゴリ作成';
$_lang["new_file_permissions_message"] = 'ファイルマネージャで新しいファイルをアップロードしたとき、ファイルマネージャは新ファイルをここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。その場合はFTPなどを通じてパーミッションを変更してください。';
$_lang["new_file_permissions_title"] = '新ファイルのアクセス許可';
$_lang["new_folder_permissions_message"] = 'ファイルマネージャで新しいフォルダをを作成したとき、ファイルマネージャは新フォルダをここで設定したパーミッションに変更します。この機能はIIS上など一部の環境では動作しません。その場合はFTPなどを通じてパーミッションを変更してください。';
$_lang["new_folder_permissions_title"] = '新フォルダのアクセス許可';
$_lang["new_htmlsnippet"] = 'チャンクの作成';
$_lang["new_keyword"] = 'キーワードの追加:';
$_lang["new_module"] = 'モジュールの作成';
$_lang["new_parent"] = '新しい親ドキュメント';
$_lang["new_plugin"] = 'プラグインの作成';
$_lang["new_role"] = '権限の作成';
$_lang["new_snippet"] = 'スニペットの作成';
$_lang["new_template"] = 'テンプレートの作成';
$_lang["new_tmplvars"] = 'テンプレート変数の作成';
$_lang["new_user"] = 'ユーザの作成';
$_lang["new_web_user"] = 'ウェブユーザの作成';
$_lang["no"] = 'No';
$_lang["nologentries_message"] = '監査ログ閲覧時、1ページあたりに表示されるログエントリ数を入力してください。';
$_lang["nologentries_title"] = 'ログエントリ数:';
$_lang["nomessages_message"] = 'メッセージ閲覧時、受信ボックスに表示されるメッセージ数を入力してください。';
$_lang["nomessages_title"] = 'メッセージ数:';
$_lang["none"] = 'なし';
$_lang["noresults_message"] = 'リスト表示や検索結果の表示の際にデータグリッドに何件表示するかここにその数を入力してください。';
$_lang["noresults_title"] = '結果の件数:';
$_lang["notset"] = '設定なし';
$_lang["not_deleted"] = 'は削除されていません';
$_lang["not_set"] = '設定なし';
$_lang["no_activity_message"] = 'まだドキュメントを作成または編集していません。';
$_lang["no_category"] = 'カテゴリなし';
$_lang["no_docs_pending_publishing"] = '公開予定のドキュメントはありません。';
$_lang["no_docs_pending_pubunpub"] = 'イベントはありません';
$_lang["no_docs_pending_unpublishing"] = '公開取り消しを予定しているドキュメントはありません。';
$_lang["no_groups_found"] = 'グループが見つかりません。';
$_lang["no_keywords_found"] = 'キーワードはありません';
$_lang["no_records_found"] = 'レコードはありません。';
$_lang["no_results"] = '結果がありません';
$_lang["offline"] = 'オフライン';
$_lang["online"] = 'オンライン';
$_lang["onlineusers_action"] = 'アクション';
$_lang["onlineusers_actionid"] = 'ID';
$_lang["onlineusers_ipaddress"] = 'ユーザIPアドレス';
$_lang["onlineusers_lasthit"] = '最終アクセス';
$_lang["onlineusers_message"] = '直近20分以内のアクティブなユーザ一覧を表示しています。(現在時刻 ';
$_lang["onlineusers_title"] = 'オンラインユーザ';
$_lang["onlineusers_user"] = 'ユーザ';
$_lang["onlineusers_userid"] = 'ユーザID';
$_lang["optimize_table"] = 'このテーブルを最適化するにはここをクリック';
$_lang["pagetitle"] = 'ドキュメントタイトル';
$_lang["page_data_cacheable"] = 'キャッシュ可';
$_lang["page_data_cacheable_help"] = 'このフィールドをチェックすることにより、ドキュメントがキャッシュに保存されることを許可します。ドキュメントにスニペットが含まれている場合は、必ずチェックを外してください。';
$_lang["page_data_cached"] = '<b>キャッシュより抽出したソース:</b>';
$_lang["page_data_changes"] = '編集履歴';
$_lang["page_data_contentType"] = 'コンテンツタイプ';
$_lang["page_data_contentType_help"] = 'このドキュメントのコンテントタイプを選択してください。コンテントタイプが分からない場合は、text/htmlのままにしてください。';
$_lang["page_data_created"] = '作成日時';
$_lang["page_data_edited"] = '編集日時';
$_lang["page_data_editor"] = 'リッチテキストエディタを使用';
$_lang["page_data_folder"] = 'フォルダ';
$_lang["page_data_general"] = '概要';
$_lang["page_data_markup"] = 'マークアップ/構造';
$_lang["page_data_mgr_access"] = 'マネージャからアクセス';
$_lang["page_data_notcached"] = 'このドキュメントは、まだキャッシュされていません。';
$_lang["page_data_publishdate"] = '公開日時';
$_lang["page_data_publishdate_help"] = '公開日時を設定した場合、ドキュメントは公開日時の到来と共に公開されます。カレンダーアイコンをクリックして公開日時を選択するか、カレンダーアイコンの隣のアイコンをクリックして公開日時を削除してください。公開日時を削除するとドキュメントは自動的には公開されません。';
$_lang["page_data_published"] = '公開';
$_lang["page_data_searchable"] = '検索対象';
$_lang["page_data_searchable_help"] = 'このフィールドをチェックすることにより、ドキュメントを検索対象にします。このフィールドをスニペット内で別の目的に使用することもできます。';
$_lang["page_data_source"] = 'ソース';
$_lang["page_data_status"] = 'ステータス';
$_lang["page_data_template"] = '使用テンプレート';
$_lang["page_data_template_help"] = 'ドキュメントが使用するテンプレートを選択してください。';
$_lang["page_data_title"] = 'ページデータ';
$_lang["page_data_unpublishdate"] = '非公開日時';
$_lang["page_data_unpublishdate_help"] = '非公開日時を設定した場合、非公開日時の到来と共にドキュメントの公開が取り消されます。カレンダーアイコンをクリックして非公開日時を選択するか、カレンダーアイコンの隣のアイコンをクリックして非公開日時を削除してください。非公開日時を削除すると、ドキュメントの公開取消は自動的には行われません。';
$_lang["page_data_unpublished"] = '非公開';
$_lang["page_data_web_access"] = 'ウェブからアクセス';
$_lang["pagination_table_first"] = "First";
$_lang["pagination_table_last"] = "Last";
$_lang["pagination_table_gotopage"] = "Go to page";
$_lang["paging_first"] = '先頭';
$_lang["paging_last"] = '最後';
$_lang["paging_next"] = '次へ';
$_lang["paging_prev"] = '前へ';
$_lang["paging_showing"] = '表示対象：';
$_lang["paging_to"] = 'から';
$_lang["paging_total"] = '(トータル)';
$_lang["parameter"] = 'パラメータ';
$_lang["password"] = 'パスワード';
$_lang["password_change_request"] = 'パスワード変更リクエスト';
$_lang["password_gen_gen"] = 'MODxにパスワードを生成させる。';
$_lang["password_gen_length"] = 'パスワードは少なくとも6文字以上の長さにしてください。';
$_lang["password_gen_method"] = 'どのようにパスワードを作成しますか?';
$_lang["password_gen_specify"] = 'パスワードを指定する:';
$_lang["password_method"] = 'どのようにパスワードを通知しますか?';
$_lang["password_method_email"] = '新しいパスワードをメールで通知する。';
$_lang["password_method_screen"] = '新しいパスワードを画面に表示する。';
$_lang["password_msg"] = '<b>%s</b>の新しいパスワードは<b>%s</b>です。';
$_lang["php_version_check"] = 'MODxはPHPバージョン4.0.3またはそれ以上で動作します。インストールしてあるPHPをアップグレードしてください!';
$_lang["plugin"] = 'プラグイン';
$_lang["plugin_code"] = 'プラグイン コード (php)';
$_lang["plugin_config"] = 'プラグイン設定';
$_lang["plugin_desc"] = '説明';
$_lang["plugin_disabled"] = 'プラグインの停止';
$_lang["plugin_event_msg"] = 'このプラグインが使用するイベントを選択してください。';
$_lang["plugin_locked_message"] = 'このプラグインはロックされてます。';
$_lang["plugin_management_msg"] = '<h3 style="font-weight:bold;">プラグインの管理</h3><p>編集したいプラグインを選択します。</p>';
$_lang["plugin_msg"] = 'プラグインの追加や編集をすることができます。プラグインは選択したシステムイベントの発生時に実行されるPHPのコード群です。';
$_lang["plugin_name"] = 'プラグイン名';
$_lang["plugin_priority"] = 'イベント発生時のプラグインの実行順を編集';
$_lang["plugin_title"] = 'プラグインの作成/編集';
$_lang["preview"] = 'プレビュー';
$_lang["preview_document"] = 'プレビュー';
$_lang["preview_msg"] = 'ここには最後に保存した内容をプレビューしています。<a href="#" onclick="saveRefreshPreview();"><img src="media/images/icons/save.gif" align="absmiddle" height="12"> 保存と再描画</a>を行うにはここをクリックしてください。';
$_lang["private"] = 'Private';
$_lang["public"] = 'Public';
$_lang["publish_date"] = '公開日付';
$_lang["publish_document"] = 'ドキュメントの公開';
$_lang["publish_events"] = '公開予定のドキュメント一覧';
$_lang["rb_base_dir_message"] = 'リソースディレクトリへの物理パスを入力してください。通常、この設定は自動的に生成されます。IISを使用していると、MODxが自分自身のパスを判別できない事があるためリソースブラウザがエラーを表示する事があります。この場合、イメージディレクトリなどのパスをここに入力することができます（パスはWindowsのエクスプローラで見るものです）。 <b>注意:</b> リソースブラウザが全てを扱えるようにするためには、リソースディレクトリにイメージや文書、フラッシュ他のメディアを格納するサブフォルダを含むべきです。';
$_lang["rb_base_dir_title"] = 'リソースパス:';
$_lang["rb_base_url_message"] = 'リソースディレクトリへの仮想パスを入力してください。通常、この設定は自動的に生成されます。もしIISを使用していると、MODxがURLを判別できないことがあるため、リソースブラウザがエラーを表示することがあります。この場合、イメージディレクトリのURLをここに入力することができます(URLはInternet Explorerに表示されるものを参考にしてください)。';
$_lang["rb_base_url_title"] = 'リソースURL:';
$_lang["rb_message"] = '「Yes」を選択するとリソースブラウザを使用できます。これによりユーザはサーバ上の画像やフラッシュなどのメディアファイルをブラウズしたり、ファイルをサーバにアップロードする事がきるようになります。';
$_lang["rb_title"] = 'リソースブラウザを使用:';
$_lang["recent_docs"] = '最近のドキュメント';
$_lang["refresh_cache"] = 'キャッシュ: キャシュディレクトリに <b>%s</b>個のキャッシュファイルが見つかりました。<b>%d</b>個のキャッシュファイルが削除されました。<p>ページがリクエストされた時点で、新しいキャッシュファイルが生成されます。';
$_lang["refresh_published"] = '<b>%s</b>件のドキュメントが公開されました。';
$_lang["refresh_site"] = 'キャッシュのクリア';
$_lang["refresh_title"] = 'サイトのリフレッシュ';
$_lang["refresh_tree"] = 'ツリーの再描画';
$_lang["refresh_unpublished"] = '<b>%s</b>件のドキュメントの公開が取り消されました。';
$_lang["remember_username"] = 'ログイン情報を記憶する';
$_lang["remove"] = '削除';
$_lang["remove_date"] = '日付を削除';
$_lang["remove_locks"] = 'ロックの解除';
$_lang["rename"] = 'リネーム';
$_lang["reports"] = 'レポート';
$_lang["require_tagname"] = 'タグ名が必要です。';
$_lang["require_tagvalue"] = 'タグの値が必要です';
$_lang["reset"] = 'リセット';
$_lang["reset_failedlogins"] = 'リセット';
$_lang["resolve_hostnames_message"] = '訪問者がこのサイトを訪れた時、MODxでIPアドレスからホスト名への解決を行いますか? ホスト名の解決を行うことによりサーバの負荷が多少増加します。しかし、ビジターがこのことに気付くことはありません。';
$_lang["resolve_hostnames_title"] = 'ホスト名解決';
$_lang["resource"] = 'リソース';
$_lang["resources"] = 'リソース';
$_lang["resource_categories"] = 'リソース一覧';
$_lang["resource_management"] = 'リソース管理';
$_lang["resource_name"] = 'リソース名';
$_lang["resource_selector_msg"] = '下のリストからリソースを選択して「挿入」ボタンをクリックします。';
$_lang["resource_selector_title"] = 'リソースセレクタ';
$_lang["role_about"] = '「MODxについて」ページの表示';
$_lang["role_access_persmissions"] = 'アクセス許可';
$_lang["role_actionok"] = '処理完了ページの表示';
$_lang["role_bk_manager"] = 'バックアップマネージャの使用';
$_lang["role_cache_refresh"] = 'キャッシュのクリア';
$_lang["role_change_password"] = 'パスワードの変更';
$_lang["role_chunk_management"] = 'Chunk Management';
$_lang["role_config_management"] = '設定管理';
$_lang["role_content_management"] = 'コンテンツ管理';
$_lang["role_create_chunk"] = 'チャンクの作成';
$_lang["role_create_doc"] = 'ドキュメントの作成';
$_lang["role_create_plugin"] = 'プラグインの作成';
$_lang["role_create_snippet"] = 'スニペットの作成';
$_lang["role_create_template"] = 'テンプレートの作成';
$_lang["role_credits"] = '著作権表示/謝辞の表示';
$_lang["role_delete_chunk"] = 'チャンクを削除';
$_lang["role_delete_doc"] = 'ドキュメントの削除';
$_lang["role_delete_eventlog"] = 'イベントログを削除';
$_lang["role_delete_module"] = 'モジュールの削除';
$_lang["role_delete_plugin"] = 'プラグインの削除';
$_lang["role_delete_role"] = '権限の削除';
$_lang["role_delete_snippet"] = 'スニペットの削除';
$_lang["role_delete_template"] = 'テンプレートの削除';
$_lang["role_delete_user"] = 'ユーザの削除';
$_lang["role_delete_web_user"] = 'ウェブユーザの削除';
$_lang["role_edit_chunk"] = 'チャンクを編集';
$_lang["role_edit_doc"] = 'ドキュメントの編集';
$_lang["role_edit_doc_metatags"] = 'METAタグとキーワードの編集';
$_lang["role_edit_module"] = 'モジュールの編集';
$_lang["role_edit_plugin"] = 'プラグインの編集';
$_lang["role_edit_role"] = '権限の編集';
$_lang["role_edit_settings"] = 'サイト設定の変更';
$_lang["role_edit_snippet"] = 'スニペットの編集';
$_lang["role_edit_template"] = 'テンプレートの編集';
$_lang["role_edit_user"] = 'ユーザの編集';
$_lang["role_edit_web_user"] = 'ウェブユーザの編集';
$_lang["role_errors"] = 'エラーダイアログの表示';
$_lang['role_export_static'] = '静的HTMLファイルとして書き出す';
$_lang["role_eventlog_management"] = 'イベントログ管理';
$_lang["role_file_manager"] = 'ファイルマネージャの使用';
$_lang["role_frames"] = 'マネージャフレームの要求';
$_lang["role_help"] = 'ヘルプページの表示';
$_lang["role_home"] = 'マネージャホームの要求';
$_lang['role_import_static'] = '静的HTMLファイルをインポート';
$_lang["role_logout"] = 'マネージャをログアウト';
$_lang["role_management_msg"] = '編集したい権限を選択してください';
$_lang["role_management_title"] = '権限管理';
$_lang["role_manage_metatags"] = 'サイト全体METAタグとキーワードの管理';
$_lang["role_messages"] = 'メッセージの表示および送信';
$_lang["role_module_management"] = 'モジュール管理';
$_lang["role_name"] = '権限名';
$_lang["role_new_module"] = 'モジュールの作成';
$_lang["role_new_role"] = '権限の作成';
$_lang["role_new_user"] = 'ユーザの作成';
$_lang["role_new_web_user"] = 'ウェブユーザの作成';
$_lang["role_plugin_management"] = 'プラグイン管理';
$_lang["role_publish_doc"] = 'ドキュメントの公開';
$_lang["role_role_management"] = '権限管理';
$_lang["role_run_module"] = 'モジュールの実行';
$_lang["role_save_chunk"] = 'Save chunks';
$_lang["role_save_doc"] = 'ドキュメントの保存';
$_lang["role_save_module"] = 'モジュールの保存';
$_lang["role_save_password"] = 'パスワードの保存';
$_lang["role_save_plugin"] = 'プラグインの保存';
$_lang["role_save_role"] = '権限の保存';
$_lang["role_save_snippet"] = 'スニペットの保存';
$_lang["role_save_template"] = 'テンプレートの保存';
$_lang["role_save_user"] = 'ユーザの保存';
$_lang["role_save_web_user"] = 'ウェブユーザの保存';
$_lang["role_snippet_management"] = 'スニペット管理';
$_lang["role_template_management"] = 'テンプレート管理';
$_lang["role_title"] = '権限の作成/編集';
$_lang["role_udperms"] = 'アクセス許可管理';
$_lang["role_user_management"] = 'ユーザ管理';
$_lang["role_view_docdata"] = 'ドキュメントデータの表示';
$_lang["role_view_eventlog"] = 'イベントログを見る';
$_lang["role_view_logs"] = 'システムログの閲覧';
$_lang["role_view_unpublished"] = '未公開のドキュメントの閲覧';
$_lang["role_web_access_persmissions"] = 'ウェブアクセス許可';
$_lang["role_web_user_management"] = 'ウェブユーザ管理';
$_lang["run_module"] = 'モジュールの実行';
$_lang["saturday"] = '土曜';
$_lang["save"] = '保存';
$_lang["save_all_changes"] = '全ての変更を保存';
$_lang["save_tag"] = 'タグ保存';
$_lang["saving"] = '保存中です。お待ちください ...';
$_lang["scroll_dn"] = '下へスクロール';
$_lang["scroll_up"] = '上へスクロール';
$_lang["search"] = '検索';
$_lang["search_criteria"] = '検索 条件';
$_lang["search_criteria_content"] = '内容で検索';
$_lang["search_criteria_content_msg"] = '入力されたテキストで全てのドキュメントの内容を検索します。';
$_lang["search_criteria_id"] = 'IDで検索';
$_lang["search_criteria_id_msg"] = 'ドキュメントを素早く特定するにはドキュメントIDを入力してください。';
$_lang["search_criteria_longtitle"] = '長いタイトルで検索';
$_lang["search_criteria_longtitle_msg"] = '入力されたテキストで全てのドキュメントの長いタイトルを検索します。';
$_lang["search_criteria_title"] = 'タイトルで検索';
$_lang["search_criteria_title_msg"] = '入力されたテキストで全てのドキュメントのタイトルを検索します。';
$_lang["search_empty"] = '指定したデータが見つかりませんでした。検索範囲を広げて再度検索してください。';
$_lang["search_item_deleted"] = 'このアイテムは削除されています';
$_lang["search_results"] = '検索結果';
$_lang["search_results_returned_desc"] = '説明';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = '<b>%s</b>件のデータが見つかりました。多くの検索結果が表示される場合は、検索範囲を更に狭くしてください。左側二つのカラムでは、ツリーでドキュメントを探したり、ドキュメントを表示したりすることができます。右側二つのカラムでは、 ドキュメントの削除状態および公開状態が各々表示されます。<p />';
$_lang["search_results_returned_title"] = 'タイトル';
$_lang["search_view_docdata"] = 'このアイテムを表示';
$_lang["security"] = 'セキュリティ';
$_lang["select_date"] = '日付を選択';
$_lang["send"] = '送信';
$_lang["servertime"] = 'サーバ時刻';
$_lang["serveroffset"] = 'サーバオフセット';
$_lang["serveroffset_message"] = 'サーバ設置場所とあなたの居場所の時差を選択してください。サーバの現在時刻は<b>[%s]</b>です。オフセットを使用したサーバの現在時刻は<b>[%s]</b>です。';
$_lang["serveroffset_title"] = 'サーバオフセットタイム:';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'このサイトがSSL接続を使用している場合は、httpsを選択してください。';
$_lang["server_protocol_title"] = 'サーバタイプ:';
$_lang["settings_after_install"] = 'これは新しくインストールされたシステムですので、設定を行い保存する必要があります。変更したい設定を行ってください。設定を変更した後、データベースを更新するために「保存」ボタンをクリックしてください。<br /><br />';
$_lang["settings_config"] = '設定';
$_lang["settings_dependencies"] = '依存性';
$_lang["settings_events"] = 'システムイベント';
$_lang["settings_furls"] = 'フレンドリーURL';
$_lang["settings_general"] = '全般';
$_lang["settings_misc"] = 'ファイルマネージャ';
$_lang["settings_page_settings"] = 'ページ設定';
$_lang["settings_photo"] = '写真';
$_lang["settings_properties"] = 'プロパティ';
$_lang["settings_site"] = 'サイト';
$_lang["settings_snippets"] = 'スニペット';
$_lang["settings_strip_image_paths_message"] = 'この設定を「No」にした場合、MODxはファイルブラウザで選択したリソース（画像、ファイル、フラッシュなど）のsrc指定を絶対パスで書き出します。それに対し相対パスは、インストール済みのMODxを移動したい時に大変便利です(例えば、開発サイトから正式サイトへの移行とか)。このことが何を意味しているのか理解できない場合は「Yes」にしておくことをお勧めします。';
$_lang["settings_strip_image_paths_title"] = 'ブラウザパスの書換え?';
$_lang["settings_templvars"] = 'テンプレート変数';
$_lang["settings_title"] = 'MODx 設定';
$_lang["settings_ui"] = 'インターフェースとその他の機能';
$_lang["settings_users"] = 'ユーザ';
$_lang["showing"] = '表示中';
$_lang["show_preview"] = 'プレビューウィンドウの表示';
$_lang["show_tree"] = 'ツリーの表示';
$_lang["signupemail_message"] = 'ユーザアカウントを作成した時に、ユーザに送信されるメッセージを設定してください。MODxはユーザ名とパスワードを記載したメールを送信します。<b>注意:</b> 下記の差し込み語は送信時にMODxによって置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイトのeメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザのログイン名, <br />[+pwd+] - ユーザのパスワード, <br />[+ufn+] - ユーザのフルネーム. <br /><br /><b>[+uid+]と[+pwd+]は残しておきましょう。削除してしまうとメールに記述されないため、ユーザはログイン名やパスワードを確認する機会をなくしてしまいます!</b>';
$_lang["signupemail_title"] = 'サインアップメール:';
$_lang["site"] = 'サイト';
$_lang["sitename_message"] = 'サイト名を入力してください。';
$_lang["sitename_title"] = 'サイト名:';
$_lang["sitestart_message"] = 'ホームページとして使用するドキュメントのIDを入力してください。<b>注意: 既に存在するドキュメントのIDを入力してください。ドキュメントは公開されている必要があります!</b>';
$_lang["sitestart_title"] = 'サイトスタート:';
$_lang["sitestatus_message"] = 'このサイトをウェブ上に公開するには「オンライン」を選択してください。「オフライン」を選択した場合、訪問者には「サイト閉鎖中メッセージ」が表示され、サイトを閲覧することができません。';
$_lang["sitestatus_title"] = 'サイトステータス:';
$_lang["siteunavailable_message"] = 'サイトがオフラインまたはエラー発生時に表示するメッセージです。<b>注意: このメッセージはサイト閉鎖中ページが設定されていないときのみ表示されます。</b>';
$_lang["siteunavailable_page_message"] = 'サイト閉鎖中に表示するドキュメントのIDをここに入力してください。<b>注意: 入力するIDは既に存在するドキュメントのものでないといけません。また公開中であるものに限ります。</b>';
$_lang["siteunavailable_page_title"] = 'サイト閉鎖中ページ:';
$_lang["siteunavailable_title"] = 'サイト閉鎖中メッセージ:';
$_lang["site_schedule"] = '公開スケジュール';
$_lang["snippet"] = 'スニペット';
$_lang["snippets_availabe"] = 'ページで利用可能なスニペット';
$_lang["snippet_code"] = 'スニペット コード (php)';
$_lang["snippet_desc"] = '説明';
$_lang["snippet_execonsave"] = '保存後にスニペットを実行';
$_lang["snippet_management_msg"] = '<h3 style="font-weight:bold;">スニペットの管理</h3><p>編集したいスニペットを選択してください。</p>';
$_lang["snippet_msg"] = 'スニペットを追加・編集することができます。スニペットは「生の」PHPコードです。スニペットの出力をテンプレートの特定の場所に表示したい場合は、テンプレート内にスニペット名を記述する必要があります - 基本的に、スニペットのアウトプットはスニペット自身と同じ名前で保存された変数を必要とします。';
$_lang["snippet_name"] = 'スニペット名';
$_lang["snippet_properties"] = '既定のプロパティ';
$_lang["snippet_title"] = 'スニペットの作成/編集';
$_lang["sort_asc"] = '昇順';
$_lang["sort_desc"] = '降順';
$_lang["sort_tree"] = 'ツリーのソート';
$_lang["source"] = '元';
$_lang["stay"] = '保存後に続けて編集';
$_lang["stay_new"] = '次の作成';
$_lang["submit"] = '実行';
$_lang["sunday"] = '日曜';
$_lang["sysinfo_activity_message"] = 'どのドキュメントが最近ユーザによって編集されたかを表示します。';
$_lang["sysinfo_userid"] = 'ユーザ';
$_lang["system_email_signup"] = 'こんにちは [+uid+] さん\n\n「[+sname+] ([+surl+])」のコンテント管理システムへのあなたのログイン情報について下記のとおりお知らせします。\n\nログインユーザ名: [+uid+]\nパスワード: [+pwd+]\n\nコンテント管理システムへログインすれば、自分のパスワードは自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より';
$_lang["system_email_webreminder"] = 'こんにちは [+uid+] さん\n\n新しいパスワードを有効にするためには、下記のリンクをクリックしてください。\n\n[+surl+]\n\n処理完了後、下記のパスワードをログインに使用できるようになります。\n\nパスワード:[+pwd+]\n\nもしこのメールに覚えが無いときは、ただ単に無視してこのメールを破棄して下さい。\n\n以上、よろしくお願いします。\nサイト管理者より';
$_lang["system_email_websignup"] = 'こんにちは [+uid+] さん\n\n「[+sname+] ([+surl+])」へのあなたのログイン情報について下記のとおりお知らせします。\n\nログインユーザ名: [+uid+]\nパスワード: [+pwd+]\n\n [+sname+]へログインすれば、自分のパスワードは自由に変更できます。\n\n以上、よろしくお願いします。\nサイト管理者より';
$_lang["sys_alert"] = 'システム警告';
$_lang["table_hoverinfo"] = 'テーブル名にマウスをかざすとテーブルの機能について簡単な説明を見ることができます（全てのテーブルに<i>説明</i>があるわけではありません）。';
$_lang["table_prefix"] = 'テーブル接頭辞';
$_lang["tag"] = 'タグ';
$_lang["template"] = 'テンプレート';
$_lang["template_assignedtv_tab"] = '定義されているテンプレート変数';
$_lang["template_code"] = 'テンプレート コード (html)';
$_lang["template_desc"] = '説明';
$_lang["template_edit_tab"] = 'テンプレートの編集';
$_lang["template_locked_message"] = 'このテンプレートはロックされています';
$_lang["template_management_msg"] = '<h3 style="font-weight:bold;">テンプレートデザインの管理</h3><p>テンプレートはいくつでも作成でき、ドキュメントごとに自由に割り当てることができます。</p>';
$_lang["template_msg"] = 'テンプレートを作成/編集できます。作成・変更されたテンプレートは、キャッシュがクリアされるまで見れないかもしれません。しかし、プレビュー機能を使用してテンプレートの動作を確認することができます。';
$_lang["template_name"] = 'テンプレート名';
$_lang["template_no_tv"] = 'テンプレート変数は定義されていません。';
$_lang["template_reset_all"] = '全てのドキュメントが既定のテンプレートを使用するようにリセットする';
$_lang["template_reset_specific"] = '「%s」を使用しているドキュメントのみリセットする';
$_lang["template_title"] = 'テンプレートの作成/編集';
$_lang["template_tv_edit"] = 'テンプレート変数の順序を書き換え';
$_lang["template_tv_msg"] = 'このテンプレートに定義されているテンプレート変数は下記のリストのとおりです。';
$_lang["thursday"] = '木曜';
$_lang["tmplvars"] = 'テンプレート変数';
$_lang["tmplvars_binding_msg"] = 'このフィールドは@コマンドを使ってのデータソースへのバインドをサポートします。';
$_lang["tmplvars_caption"] = '見出し';
$_lang["tmplvars_default"] = '既定値';
$_lang["tmplvars_description"] = '説明';
$_lang["tmplvars_elements"] = '入力時のオプション値';
$_lang["tmplvars_management_msg"] = '<h3 style="font-weight:bold;">テンプレート変数の管理</h3><p>ドキュメントに使用する追加のカスタムフィールド(テンプレート変数)を管理できます。「タイトル」や「内容」などの既定の項目に加え、自由に項目を追加できます。</p>';
$_lang["tmplvars_msg"] = 'テンプレート変数の作成や編集ができます。スニペットやドキュメントからテンプレート変数にアクセスするためにはテンプレートにおいてテンプレート変数を実行可能にしなければなりません。';
$_lang["tmplvars_name"] = '変数名';
$_lang["tmplvars_novars"] = 'テンプレート変数は見つかりません。';
$_lang["tmplvars_rank"] = '並べ替え順';
$_lang["tmplvars_reset_params"] = 'パラメータのリセット';
$_lang["tmplvars_type"] = '入力タイプ';
$_lang["tmplvars_widget"] = 'ウィジェット';
$_lang["tmplvars_widget_prop"] = 'Widget プロパティ';
$_lang["tmplvar_access_msg"] = 'この変数に対して内容や値の変更を許可するドキュメントグループを選択してください。';
$_lang["tmplvar_change_template_msg"] = 'このテンプレートを変更すると、このページのテンプレート変数をリロードします。保存していない変更は失われます。\n\n ほんとうにこのテンプレートを変更しますか?';
$_lang["tmplvar_inuse"] = '下記のドキュメントはこのテンプレート変数を現在使用しています。削除処理を続けるには「削除」ボタンを、やめるときは「キャンセル」ボタンをクリックしてください。';
$_lang["tmplvar_tmpl_access"] = 'テンプレートへのアクセス';
$_lang["tmplvar_tmpl_access_msg"] = 'この変数へのアクセスや処理を許可するテンプレートを選択してください。';
$_lang["to"] = '-';
$_lang["tools"] = 'ツール';
$_lang["top_howmany_message"] = '訪問レポートの「トップ ...」に何件表示するか指定します。';
$_lang["top_howmany_title"] = 'トップ 表示件数';
$_lang["total"] = '合計';
$_lang["track_visitors_message"] = '訪問の記録を取ることにより、このサイトの利用統計を見ることができます。しかし、訪問の記録を取ることでサイトのレスポンスが若干遅くなります。訪問者の統計を気にしないのでしたら、このオプションを停止して若干のスピードアップを楽しんでも問題ありません。';
$_lang["track_visitors_title"] = '訪問の記録';
$_lang["tree_show_protected"] = '保護されたページの表示';
$_lang["tree_show_protected_message"] = '「No」にセットするとドキュメントツリーの中で保護されたページは表示されなくなります（親ドキュメントが保護されている場合は子ドキュメントも表示されません）。"No" is the legacy setting for MODx.';
$_lang["truncate_table"] = 'このテーブルの内容を全削除するにはここをクリック';
$_lang["tuesday"] = '火曜';
$_lang["tv"] = 'テンプレート変数';
$_lang["type"] = 'タイプ';
$_lang["udperms_allowroot_message"] = 'サイトのルートディレクトリにユーザがドキュメント/フォルダを作成できるようにしますか? ';
$_lang["udperms_allowroot_title"] = 'ルートの使用許可:';
$_lang["udperms_message"] = 'アクセス許可機能を設定することで、どのページをユーザが編集できるかを指定することができます。まず、ユーザをユーザグループに、ドキュメントをドキュメントグループに割り当ててください。それから、ユーザグループがアクセスできるドキュメントグループを指定してください。この設定を「Yes」にした場合、最初は管理者のみが全てのドキュメントを編集することができます。';
$_lang["udperms_title"] = 'アクセス許可機能の使用:';
$_lang["unable_set_link"] = 'リンクを設定できません!';
$_lang["unable_set_parent"] = '新しい親ドキュメントを設定できません!';
$_lang["unauthorizedpage_message"] = 'ユーザがアクセスを許可されていないドキュメントを要求したとき表示するドキュメントのIDを入力してください。 <b>注意: 入力するIDは既に存在するドキュメントのものでないといけません。また公開中でしかもPublicなアクセスが可能であるものに限ります!</b>';
$_lang["unauthorizedpage_title"] = '権限外告知のページ:';
$_lang["unblock_message"] = 'ユーザデータを保存した後、このユーザのアクセス拒否は解除されます。';
$_lang["undelete_document"] = 'ドキュメントの復活';
$_lang["unpublish_date"] = '非公開日時';
$_lang["unpublish_document"] = 'ドキュメント公開取消';
$_lang["unpublish_events"] = '公開取消予定のドキュメント一覧';
$_lang["untitled_document"] = '無題のドキュメント';
$_lang["untitled_weblink"] = '無題のウェブリンク';
$_lang["update_params"] = 'パラメータ表示の更新';
$_lang["uploadable_files_message"] = 'ファイルマネージャを使用してアップロードできるファイルタイプの一覧を入力してください。ファイルタイプの拡張子をカンマで区切って入力してください。';
$_lang["uploadable_files_title"] = 'アップロード可能なファイルタイプ:';
$_lang["uploadable_flash_message"] = 'リソースマネージャを使用して\'assets/flash/\'にアップロードできるフラッシュファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_flash_title"] = 'アップロード可能なフラッシュ:';
$_lang["uploadable_images_message"] = 'リソースマネージャを使用して\'assets/images/\'にアップロードできる画像ファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_images_title"] = 'アップロード可能な画像タイプ:';
$_lang["uploadable_media_message"] = 'リソースマネージャを使用して\'assets/media/\'にアップロードできるマルチメディアファイルの一覧を入力してください。拡張子をカンマで区切って入力してください。';
$_lang["uploadable_media_title"] = 'アップロード可能なマルチメディアタイプ:';
$_lang["upload_maxsize_message"] = 'ファイルマネージャを通じてアップロード可能な最大サイズを入力してください。サイズはバイト単位で入力します。<b>注意: 大きなサイズのアップロードには長時間を要するかもしれません!</b>';
$_lang["upload_maxsize_title"] = 'アップロードサイズの上限';
$_lang["user"] = 'ユーザ';
$_lang["username"] = 'ユーザ名';
$_lang["users"] = 'ユーザ';
$_lang["user_block"] = 'アクセス拒否';
$_lang["user_blockedafter"] = 'この日から拒否';
$_lang["user_blockeduntil"] = 'この日まで拒否';
$_lang["user_changeddata"] = 'ユーザ情報が変更されました。もう一度ログインしなおしてください。';
$_lang["user_country"] = '国';
$_lang["user_dob"] = '誕生日';
$_lang["user_doesnt_exist"] = 'ユーザ登録がありません';
$_lang["user_edit_self_msg"] = 'ユーザ情報を変更した場合は、変更を反映させるためにログアウトして再度ログインしてください。</b><br>新しいパスワードの作成をチェックした場合、新しいパスワードがメール送信されます。';
$_lang["user_email"] = 'メールアドレス';
$_lang["user_failedlogincount"] = 'ログイン失敗';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = '女性';
$_lang["user_full_name"] = 'フルネーム';
$_lang["user_gender"] = '性別';
$_lang["user_is_blocked"] = 'このユーザはアクセス拒否されています!';
$_lang["user_logincount"] = 'ログイン回数';
$_lang["user_male"] = '男性';
$_lang["user_management_msg"] = '編集したいマネージャのユーザを選択してください。マネージャユーザはこのMODxマネージャにログインできるユーザです。';
$_lang["user_management_title"] = 'ユーザ管理';
$_lang["user_mobile"] = '携帯電話番号';
$_lang["user_phone"] = '電話番号';
$_lang["user_photo"] = 'ユーザの写真';
$_lang["user_photo_message"] = 'このユーザの写真イメージファイルのURLを入力してください。か、挿入ボタンをクリックします。ファイルマネージャでファイルを選択したり、イメージファイルをサーバにアップロードしたりできます。';
$_lang["user_prevlogin"] = '最終ログイン';
$_lang["user_role"] = 'ユーザ権限';
$_lang["user_state"] = '県/州';
$_lang["user_title"] = 'ユーザの作成/編集';
$_lang["user_upload_message"] = ' このユーザに対してこのカテゴリに含まれるファイルタイプのアップロードを禁じたい場合、「MODx設定を使用」をチェックせず、このフィールドをブランクにしておいてください。';
$_lang["user_use_config"] = 'MODx設定を使用';
$_lang["user_zip"] = '郵便番号';
$_lang["use_alias_path_message"] = 'このオプションを「Yes」に設定すると、ドキュメントのエイリアスがパスとして表示されます。例えば、「child」というエイリアスを持ったドキュメント「parent」というエイリアスのフォルダの下に配置されていると、エイリアスパスは「/parent/child.html」になります。<br /><b>注意: このオプションが「Yes」にするとき、即ちエイリアスパスを使用するときは、ドキュメントから参照するものは全て（画像とかCSSとかJavaScriptなど）絶対パスで指定する必要があります。例えば、assets/imagesに対しては/assets/imagesと指定しなければなりません。そうしないとエイリアスパスからの相対パスとなり、期待した参照にはなりません。</b>';
$_lang["use_alias_path_title"] = 'エイリアスパスを使用:';
$_lang["use_editor_message"] = 'リッチテキストエディタを使用しますか? HTMLを直接書いた方が良いのでしたら「No」を選択してエディタを使わない設定にすることもできます。この設定は全てのドキュメントおよび全てのユーザに適用されますので注意してください!';
$_lang["use_editor_title"] = 'エディタの使用:';
$_lang["value"] = '値';
$_lang["version_codename"] = "コードネーム";
$_lang["view"] = 'ここをクリック';
$_lang["view_child_documents_in_container"] = "子ドキュメントを表示";
$_lang["view_document"] = 'ドキュメントの表示';
$_lang["view_log"] = 'ログを見る';
$_lang["view_logging"] = '監査ログ';
$_lang["view_sysinfo"] = 'システム情報';
$_lang["warning"] = '警告!';
$_lang["warning_not_saved"] = '変更が保存されていません。変更を保存するためには「キャンセル」をクリックして現在のページに戻ってください。また、「OK」をクリックして全ての変更を破棄することもできます。';
$_lang["weblink"] = 'ウェブリンク';
$_lang["weblink_message"] = 'ウェブリンクは、インターネット上のオブジェクトに対する参照です。オブジェクトは、MODx内のドキュメント、他のサイトのページや画像、インターネット上の他のファイルです。<p>';
$_lang["webpwdreminder_message"] = 'ウェブユーザからメールで新パスワードの要求があった時に、ユーザに送信されるメッセージを設定してください。MODx新パスワードとアクティベーション方法を記載したメールを送信します。<b>注意:</b> 下記の差し込み語は送信時にMODxによって置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイトのeメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザのログイン名, <br />[+pwd+] - ユーザのパスワード, <br />[+ufn+] - ユーザのフルネーム. <br /><br /><b>[+uid+]と[+pwd+]は残しておきましょう。削除してしまうとメールに記述されないため、ユーザはログイン名やパスワードを確認する機会をなくしてしまいます!</b>';
$_lang["webpwdreminder_title"] = 'ウェブリクエストメール:';
$_lang["websignupemail_message"] = 'ウェブユーザアカウントを作成した時に、ユーザに送信されるメッセージを設定してください。MODxはユーザ名とパスワードを記載したメールを送信します。<b>注意:</b> 下記の差し込み語は送信時にMODxによって置き換えられます。<br /><br />[+sname+] - サイトの名前, <br />[+saddr+] - サイトのeメールアドレス, <br />[+surl+] - サイトのURL, <br />[+uid+] - ユーザのログイン名, <br />[+pwd+] - ユーザのパスワード, <br />[+ufn+] - ユーザのフルネーム. <br /><br /><b>[+uid+]と[+pwd+]は残しておきましょう。削除してしまうとメールに記述されないため、ユーザはログイン名やパスワードを確認する機会をなくしてしまいます!</b>';
$_lang["websignupemail_title"] = 'ウェブサインアップメール:';
$_lang["web_access_permissions"] = 'ウェブアクセス許可';
$_lang["web_access_permissions_user_group"] = 'ウェブユーザグループ:';
$_lang["web_access_permissions_user_groups"] = 'ウェブユーザグループ';
$_lang["web_access_permissions_user_group_access"] = 'このユーザがアクセスするドキュメントグループ:';
$_lang["web_permissions"] = 'ウェブからのアクセス許可';
$_lang["web_users"] = 'ウェブユーザ';
$_lang["web_user_management_msg"] = '編集したいウェブユーザを選択します。ウェブユーザはウェブサイトにのみログインできるユーザを意味します。';
$_lang["web_user_management_title"] = 'ウェブユーザ';
$_lang["web_user_title"] = 'ウェブユーザの作成･編集';
$_lang["wednesday"] = '水曜';
$_lang["welcome_messages"] = '受信トレイに <b>%d</b> 件のメッセージが入っています。<b>%s</b> 件が未読です。';
$_lang["welcome_title"] = 'MODx マネージャへようこそ';
$_lang["which_editor_message"] = '使用するリッチテキストエディタを選択してください(※MODxのダウンロードページには追加でインストールできるリッチテキストエディタがあります)。';
$_lang["which_editor_title"] = '使用エディタ:';
$_lang["working"] = '処理中 ...';
$_lang["wrap_lines"] = '行の折り返し';
$_lang["xhtml_urls_title"] = 'XHTML URLs';
$_lang["xhtml_urls_message"] = '「yes」を設定すると、アンパーサンド (&) を自動的に文字実態参照 (&<!-- -->amp;) に置き換えます。';
$_lang["yes"] = 'Yes';
$_lang["yourinfo_message"] = '自分自身に関する情報を表示しています:';
$_lang["yourinfo_previous_login"] = '最終ログイン日時は:';
$_lang["yourinfo_role"] = '権限は:';
$_lang["yourinfo_title"] = 'あなたの情報';
$_lang["yourinfo_total_logins"] = '合計ログイン回数は:';
$_lang["yourinfo_username"] = 'ログイン名は:';
$_lang["you_got_mail"] = 'メールが届いています';
?>
