<?php
/**
 * Filename:       includes/lang/english.inc.php
 * Function:       Language file.
 * Encoding:       UTF8
 * Author:         The MODx Project Team
 * Date:           03 Oct 2006
 * Version:        2.01
 * MODx version:   0.9.5
*/
// NOTE: Now alpha-sorted
$_lang["about_msg"] = 'MODx is a <a href="http://modxcms.com/what-is-modx.html" target="_blank">PHP Application Framework and Content Management System</a> licensed under the <a href="../assets/docs/license.txt">GNU GPL</a>.';
$_lang["about_title"] = 'About MODx';
$_lang["access_permissions"] = 'Access permissions';
$_lang["access_permissions_add_document_group"] = 'Create a new document group';
$_lang["access_permissions_add_user_group"] = 'Create a new user group';
$_lang["access_permissions_docs_message"] = 'Here you can select which document groups this document belongs to';
$_lang["access_permissions_documents_in_group"] = '<b>Documents in group:</b> ';
$_lang["access_permissions_documents_tab"] = 'Here you can see which document groups have been set up. You can also create new groups, rename groups, delete groups and see which documents are in the different groups (hover over the id of the document to see it\'s name). To add a document to a group or remove a document from a group, edit the document directly.';
$_lang["access_permissions_document_groups"] = 'Document groups';
$_lang["access_permissions_introtext"] = 'Here you can manage the user groups and document groups used for access permissions. To add a user to a user group, edit the user and select the groups (s)he should be a member of. To add a document to a user group, edit the document and select the groups it should belong to.';
$_lang["access_permissions_links"] = 'User/Document group links';
$_lang["access_permissions_links_tab"] = 'This is where we specify which user groups are given access (i.e. can edit or create children) for the document groups. To link a document group to a user group, select the group from the dropdown, and click on \'Link\'. To remove the link for a certain group, press \'Remove ->\'. This will immediately remove the link.';
$_lang["access_permissions_no_documents_in_group"] = 'None.';
$_lang["access_permissions_no_users_in_group"] = 'None.';
$_lang["access_permissions_off"] = '<span class="warning">Access Permissions are not activated.</span> This means any changes made here will not have any effect until Access Permissions are activated.';
$_lang["access_permissions_users_in_group"] = '<b>Users in group:</b> ';
$_lang["access_permissions_users_tab"] = 'Here you can see which user groups have been set up. You can also create new groups, rename groups, delete groups and see which users are members of the different groups. To add a new user to a group or to remove a user from a group, edit the user directly. Administrators (users who have been assigned the role with ID 1) always have access to all documents, so they don\'t need to be added to any groups.';
$_lang["access_permissions_user_group"] = 'User group:';
$_lang["access_permissions_user_groups"] = 'User groups';
$_lang["access_permissions_user_group_access"] = 'Document groups this user group has access to:';
$_lang["access_permissions_user_message"] = 'Here you can select which user groups this user belongs to:';
$_lang["access_permission_denied"] = 'You do not have the correct permissions for this document.';
$_lang["access_permission_parent_denied"] = 'You do not have permission to create or move a document here! Please choose another location.';
$_lang["account_email"] = 'Account email';
$_lang["actioncomplete"] = '<b>Action was completed successfully!</b><br /> - Please wait while MODx cleans up.';
$_lang["activity_message"] = 'This list shows the last documents you created or edited:';
$_lang["activity_title"] = 'Recently edited/created documents';
$_lang["add"] = 'Add';
$_lang["add_chunk"] = 'Add Chunk';
$_lang["add_doc"] = 'Add Document';
$_lang["add_document"] = 'New Document';
$_lang["add_folder"] = 'New Folder';
$_lang["add_plugin"] = 'Add Plugin';
$_lang["add_snippet"] = 'Add Snippet';
$_lang["add_tag"] = 'Add tag';
$_lang["add_template"] = 'Add Template';
$_lang["add_tv"] = 'Add TV';
$_lang["add_weblink"] = 'New Weblink';
$_lang["administrator_role_message"] = 'This role cannot be edited or deleted.';
$_lang["after_saving"] = 'After saving';
$_lang["alert_delete_self"] = 'You can\'t delete yourself!';
$_lang["alias"] = 'Alias';
$_lang["allow_mgr_access"] = 'Manager Interface Access';
$_lang["allow_mgr_access_message"] = 'Select this option to enable or disable access to the manager interface. <b>NOTE: If this option is set to no then the user will be redirected the the Manager Login Startup or Site Start web page.</b>';
$_lang["all_doc_groups"] = 'All Document Groups (Public)';
$_lang["all_events"] = 'All Events';
$_lang["all_usr_groups"] = 'All User Groups (Public)';
$_lang["already_deleted"] = 'has already been deleted.';
$_lang["attachment"] = 'Attachment';
$_lang["automatic_alias_message"] = 'Select \'yes\' to have the system automatically generate an alias based on the document\'s page title when saving.';
$_lang["automatic_alias_title"] = 'Automatically generate alias:';
$_lang["backup"] = 'Backup';
$_lang["bk_manager"] = 'Backup';
$_lang["blocked_minutes_message"] = 'Here you can enter the number of minutes that a user will be blocked for if they reach their maximum number of allowed failed login attempts. Please enter this value as numbers only (no commas, spaces etc.)';
$_lang["blocked_minutes_title"] = 'Blocked Minutes:';
$_lang["block_message"] = 'This user will be blocked after saving the user\'s data!';
$_lang["cache_files_deleted"] = 'The following files were deleted:';
$_lang["cancel"] = 'Cancel';
$_lang["captcha_code"] = 'Security code';
$_lang["captcha_message"] = 'Enable this to strengthen security by requiring users to enter a code which is unreadable by machines (and scriptkiddy hacking scripts).';
$_lang["captcha_title"] = 'Use CAPTCHA codes:';
$_lang["captcha_words_message"] = 'Here you can enter a list of CAPTCHA words to use if CAPTCHA is enabled. Separate the words with commas. This input field is limited to 255 characters.';
$_lang["captcha_words_title"] = 'CAPTCHA Words';
$_lang["category_heading"] = 'Category';
$_lang["category_msg"] = 'Here you can view and edit all resources grouped by category.';
$_lang["change_name"] = 'Change name';
$_lang["change_password"] = 'Change Password';
$_lang["change_password_confirm"] = 'Confirm password';
$_lang["change_password_message"] = 'Please enter your new password, and then enter it again to confirm. Your password needs to be between 6 and 15 characters long.';
$_lang["change_password_new"] = 'New password';
$_lang["charset_message"] = 'Please select which character encoding you wish to use in the manager. Please note that MODx has been tested with a number of these encodings, but not all of them. For most languages, the default setting of UTF-8 is preferrable.';
$_lang["charset_title"] = 'Character encoding:';
$_lang["chunk"] = 'Chunk';
$_lang["chunk_code"] = 'Chunk code (html)';
$_lang["cleaningup"] = 'Cleaning up';
$_lang["clear_log"] = 'Clear log';
$_lang["click_to_context"] = 'Click to access context menu';
$_lang["click_to_edit_title"] = 'Click here to edit this record';
$_lang["click_to_view_details"] = 'Click here to view details';
$_lang["close"] = 'Close';
$_lang["collapse_tree"] = 'Collapse tree';
$_lang["comment"] = 'Comment';
$_lang["address"] = 'Address';
$_lang["configcheck_admin"] = 'Please contact a systems administrator and warn them about this message!';
$_lang["configcheck_cache"] = 'cache directory not writable';
$_lang["configcheck_cache_msg"] = 'MODx cannot write to the cache directory. MODx will still function as expected, but no caching will take place. To solve this, make the /_cache/ directory writable.';
$_lang["configcheck_configinc"] = 'Config file still writable';
$_lang["configcheck_configinc_msg"] = 'Very naughty people could potentially wreak some havoc on your site and everything associated with it. <strong>Really.</strong> Please make your config file  (/manager/includes/config.inc.php) read only!';
$_lang["configcheck_default_msg"] = 'An unspecified warning was found. Which is strange.';
$_lang["configcheck_errorpage_unavailable"] = 'Your site\'s Error page is not available.';
$_lang["configcheck_errorpage_unavailable_msg"] = 'This means that your Error page is not accessible to normal web surfers or does not exist. This can lead to a recursive looping condition and many errors in your site logs. Make sure there are no webuser groups assigned to the page.';
$_lang["configcheck_errorpage_unpublished"] = 'Your site\'s Error page is not published or does not exist.';
$_lang["configcheck_errorpage_unpublished_msg"] = 'This means that your Error page is inaccessible to the general public. Publish the page or make sure it is assigned to an existing document in your site tree in the Tools &gt; Configuration menu.';
$_lang["configcheck_images"] = 'Images directory not writable';
$_lang["configcheck_images_msg"] = 'The images directory isn\'t writable, or doesn\'t exist. This means the Image Manager functions in the editor will not work!';
$_lang["configcheck_installer"] = 'Installer still present';
$_lang["configcheck_installer_msg"] = 'The install/ directory contains the installer for MODx. Just imagine what might happen if an evil person finds this folder and runs the installer! He\'d probably not get too far, because he\'ll need to enter some user information for the database, but it\'s still best to remove this folder from your server.';
$_lang["configcheck_lang_difference"] = 'Incorrect number of entries in language file';
$_lang["configcheck_lang_difference_msg"] = 'The currently selected language has a different number of entries than the default language. While not necessarily a problem, this may mean the language file needs to be updated.';
$_lang["configcheck_notok"] = 'One or more configuration details didn\'t check out OK: ';
$_lang["configcheck_ok"] = 'Check passed OK - no warnings to report.';
$_lang["configcheck_register_globals"] = 'register_globals is set to ON in your php.ini configuration file';
$_lang["configcheck_register_globals_msg"] = 'This configuration makes your site much more susceptible to Cross Site Scripting (XSS) attacks. You should speak to your host about what you can do to disable this setting.';
$_lang["configcheck_title"] = 'Configuration check';
$_lang["configcheck_unauthorizedpage_unavailable"] = 'Your site\'s Unauthorized page is not published or does not exist.';
$_lang["configcheck_unauthorizedpage_unavailable_msg"] = 'This means that your Unauthorized page is not accessible to normal web surfers or does not exist. This can lead to a recursive looping condition and many errors in your site logs. Make sure there are no webuser groups assigned to the page.';
$_lang["configcheck_unauthorizedpage_unpublished"] = 'The Unauthorized page defined in the site configuration settings is not published.';
$_lang["configcheck_unauthorizedpage_unpublished_msg"] = 'This means that your Unauthorized page is inaccessible to the general public. Publish the page or make sure it is assigned to an existing document in your site tree in the Tools &gt; Configuration menu.';
$_lang["configcheck_warning"] = 'Configuration warning:';
$_lang["configcheck_what"] = 'What does this mean?';
$_lang["confirm_block"] = 'Are you sure you want to block this user?';
$_lang["confirm_delete_document"] = 'Are you sure you want to delete this document?\nAny children documents will also be deleted.';
$_lang["confirm_delete_eventlog"] = 'Are you sure you want to delete this event log?';
$_lang["confirm_delete_file"] = 'Are you sure you want to delete the file?\n\nThis may stop your site from working properly! Only delete this file if you know for certain what you are doing will not break anything.';
$_lang["confirm_delete_htmlsnippet"] = 'Are you sure you want to delete this chunk?';
$_lang["confirm_delete_keywords"] = 'Are you sure you want to delete these keywords?';
$_lang["confirm_delete_module"] = 'Are you sure you want to delete this module?';
$_lang["confirm_delete_plugin"] = 'Are you sure you want to delete this plugin?';
$_lang["confirm_delete_record"] = 'Are you sure you want to delete the selected record(s)?';
$_lang["confirm_delete_role"] = 'Are you sure you want to delete this role?';
$_lang["confirm_delete_snippet"] = 'Are you sure you want to delete this snippet?';
$_lang["confirm_delete_tags"] = 'Are you sure you want to delete the selected META tags?';
$_lang["confirm_delete_template"] = 'Are you sure you want to delete this template?';
$_lang["confirm_delete_tmplvars"] = 'Are you sure you want to remove this variable and all stored values?';
$_lang["confirm_delete_user"] = 'Are you sure you want to delete this user?';
$_lang["confirm_duplicate_document"] = 'Are you sure you want to duplicate this document? Any item(s) it contains will also be duplicated.';
$_lang["confirm_duplicate_record"] = 'Are you sure you want to duplicate this record?';
$_lang["confirm_empty_trash"] = 'This will permanently remove ALL deleted documents?\n\nProceed?';
$_lang["confirm_load_depends"] = 'Are you sure you want to load the Manage Dependencies screen without saving your modifications?';
$_lang["confirm_name_change"] = 'Changing the user name can affect other applications that are linked to the Content Manager. \n\n Are you sure you want to change this user name?';
$_lang["confirm_publish"] = '\n\nPublishing this document now will remove any (un)publishing dates that may have been set. If you wish to set or keep publish or unpublish dates, please choose to \'edit\' the document instead.\n\nProceed?';
$_lang["confirm_remove_locks"] = 'Users sometimes close their browser while editing documents, templates, snippets or parsers, possibly leaving the item they were editing in locked state. By pressing OK you can remove ALL locks currently in place.\n\nProceed?';
$_lang["confirm_unblock"] = 'Are you sure you want to unblock this user?';
$_lang["confirm_undelete"] = '\n\nAny children documents deleted at the same time as this document will also be undeleted, but children documents deleted at an earlier time will still be deleted.';
$_lang["confirm_unpublish"] = '\n\nUn-publishing this document now will remove any (un)publishing dates that may have been set. If you wish to set or keep publish or unpublish dates, please choose to \'edit\' the document instead.\n\nProceed?';
$_lang["confirm_unzip_file"] = 'Are you sure you want to unzip this file?\n\nExisting files will be overwritten.';
$_lang["could_not_find_user"] = 'Could not find user';
$_lang["createdon"] = 'Creation date';
$_lang["create_document_here"] = 'Create document here';
$_lang["create_folder_here"] = 'Create folder here';
$_lang["create_weblink_here"] = 'Create weblink here';
$_lang["credits"] = 'Credits';
$_lang["credits_dTree"] = 'MODx uses the excellent dTree script from DestroyDrop.com!';
$_lang["credits_everaldo"] = 'MODx uses a number of icons from Everaldo\'s crystal icon set. Great icons!';
$_lang["credits_mysql"] = 'MODx is powered by MySQL!';
$_lang["credits_php"] = 'MODx is powered by PHP!';
$_lang["credits_shouts_msg"] = '
<ul>
<li><b>Raymond Irving, Ryan Thrash</b> - Project Founders</li>
<li><b>Jason Coward, Victor Brilon, Adam Crownoble, Jeff Whitfield, Remon Sijrier</b> - Core Architecture &amp; Design</li>
</ul>';
$_lang["credits_shouts_title"] = '<b>Additional thanks to:</b>';
$_lang["credits_webfx"] = 'MODx uses a number of JavaScripts from Webfx. Great stuff!';
$_lang["custom_contenttype_message"] = 'Here you can add custom content types to be used in your documents. To add a new entry, enter the content type in the text box then click the \'Add\' button.';
$_lang["custom_contenttype_title"] = 'Custom content types:';
$_lang["database_name"] = 'Database name';
$_lang["database_server"] = 'Database server';
$_lang["database_tables"] = 'Database tables';
$_lang["database_overhead"] = '<b style=\'color:#990033\'>Note:</b> Overhead is unused space reserved by MySQL. To free up this space, click on the table\'s overhead figure.';
$_lang["database_table_clickhere"] = 'Click here';
$_lang["database_table_clickbackup"] = 'to backup &amp; download the selected tables';
$_lang["database_table_datasize"] = 'Data size';
$_lang["database_table_droptablestatements"] = 'Generate DROP TABLE statements.';
$_lang["database_table_effectivesize"] = 'Effective size';
$_lang["database_table_indexsize"] = 'Index size';
$_lang["database_table_overhead"] = 'Overhead';
$_lang["database_table_records"] = 'Records';
$_lang["database_table_tablename"] = 'Table name';
$_lang["database_table_totalsize"] = 'Total size';
$_lang["database_table_totals"] = 'Totals:';
$_lang["date"] = 'Date';
$_lang["datechanged"] = 'Date changed';
$_lang["defaultcache_message"] = 'Select \'Yes\' to make all new documents cacheable by default.';
$_lang["defaultcache_title"] = 'Cacheable default';
$_lang["defaultmenuindex_message"] = 'Select \'Yes\' to turn on automatic menu index incrementing by default.';
$_lang["defaultmenuindex_title"] = 'Menu indexing default';
$_lang["defaultpublish_message"] = 'Select \'Yes\' to make all new documents published by default.';
$_lang["defaultpublish_title"] = 'Published default';
$_lang["defaultsearch_message"] = 'Select \'Yes\' to make all new documents searchable by default.';
$_lang["defaultsearch_title"] = 'Searchable default';
$_lang["defaulttemplate_message"] = 'Select the default template you wish to use for new documents. You can still select a different template in the document editor, this setting just pre-selects one of your templates for you.';
$_lang["defaulttemplate_title"] = 'Default template';
$_lang["delete"] = 'Delete';
$_lang["delete_document"] = 'Delete document';
$_lang["delete_tags"] = 'Delete tags';
$_lang["deleting_file"] = 'Deleting file `%s`: ';
$_lang["description"] = 'Description';
$_lang["deselect_keywords"] = 'Clear keywords';
$_lang["deselect_metatags"] = 'Clear META tags';
$_lang["disabled"] = 'Disabled';
$_lang["document"] = 'Document';
$_lang["document_alias"] = 'Document\'s alias';
$_lang["document_alias_help"] = 'Here you can select an alias for this document. This will make the document accessible using:\n\nhttp://yourserver/alias\n\nThis only works if you\'re using friendly URLs.';
$_lang["document_content"] = 'Document content';
$_lang["document_description"] = 'Description';
$_lang["document_description_help"] = 'You can enter an optional description of the document here.';
$_lang["document_long_title_help"] = 'Here you can enter a longer title for your document. This is handy for search engines, and might be more descriptive for your document.';
$_lang["document_metatag_help"] = 'Select the META tags or keywords you wish to assign to this document. Hold down the CTRL key to select multiple keywords or meta tags.';
$_lang["document_opt_contentdispo"] = 'Content Disposition';
$_lang["document_opt_contentdispo_help"] = 'Use the content disposition field to specify how this document will be handled by the web browser. For file downloads select the Attachment option.';
$_lang["document_opt_emptycache"] = 'Empty cache?';
$_lang["document_opt_emptycache_help"] = 'Leaving this field checked will make MODx empty the cache after you save the document. This way your visitors will not see an older version of the document.';
$_lang["document_opt_folder"] = 'Container?';
$_lang["document_opt_folder_help"] = 'Check this to make the document also act as a container for other documents. A \'container\' is like a folder, only it can also have content.';
$_lang["document_opt_menu_index"] = 'Menu index';
$_lang["document_opt_menu_index_help"] = 'Menu Index is a field you can use for sorting document in your menu snippet(s). You can also use it for any other purpose in your snippets.';
$_lang["document_opt_menu_title"] = 'Menu title';
$_lang["document_opt_menu_title_help"] = 'Menu title is a field you can use to display a short title for the document inside your menu snippet(s) or modules.';
$_lang["document_opt_published"] = 'Published?';
$_lang["document_opt_published_help"] = 'Check this field to have the document published immediately after saving it.';
$_lang["document_opt_richtext"] = 'Rich text?';
$_lang["document_opt_richtext_help"] = 'Leave this checked to use the rich text editor for editing documents. If your documents contain JavaScript and forms, uncheck this to edit in HTML mode and so that the editor doesn\'t screw your documents up.';
$_lang["document_opt_show_menu"] = 'Show in menu';
$_lang["document_opt_show_menu_help"] = 'Select this option to show document inside a web menu. Please note that some Menu Builders might choose to ignore this option.';
$_lang["document_opt_trackvisit_help"] = 'Log each visitor\'s visit to this page';
$_lang["document_overview"] = 'Document overview';
$_lang["document_parent"] = 'Document parent';
$_lang["document_parent_help"] = 'Click on the icon above to enable (or disable) selecting this document\'s parent. Next, click a document in the tree to set its new parent.';
$_lang["document_setting"] = 'Document setting';
$_lang["document_summary"] = 'Summary (introtext)';
$_lang["document_summary_help"] = 'Type a brief summary of the document';
$_lang["document_title"] = 'Title';
$_lang["document_title_help"] = 'Type the name/title of the document here. Try to avoid using backslashes in the name!';
$_lang["document_to_be_moved"] = 'Document to be moved';
$_lang["document_weblink_help"] = 'Type the address of the object you wish to reference with this weblink here.';
$_lang["documents_in_container"] = "documents in this container";
$_lang["documents_in_container_no"] = "This container does not have child-documents.";
$_lang["doc_data_title"] = 'View document data';
$_lang["duplicate"] = 'Duplicate';
$_lang["duplicate_alias_found"] = 'Document \'%s\' is already using the alias \'%s\'. Please enter a unique alias.';
$_lang["duplicate_alias_message"] = 'Here you can select \'yes\' to allow duplicate aliases to be saved. <b>NOTE: This option should be used with \'Friendly alias path\' option set to \'Yes\' in order to avoid problems when referencing a document.</b>';
$_lang["duplicate_alias_title"] = 'Allow duplicate aliases:';
$_lang["duplicate_document"] = 'Duplicate Document';
$_lang["edit"] = 'Edit';
$_lang["editedon"] = 'Edit date';
$_lang["editing_file"] = 'Editing file: ';
$_lang["editor_css_path_message"] = 'Enter the path to your CSS file that you wish to use within the editor. The best way to enter the path is to enter the path from the root of your server, for example: /assets/site/style.css. If you do not wish to load a style sheet into the editor, leave this field blank.';
$_lang["editor_css_path_title"] = 'Path to CSS file:';
$_lang["edit_document"] = 'Edit document';
$_lang["edit_document_title"] = 'Create/edit document';
$_lang["edit_settings"] = 'Configuration';
$_lang["email"] = 'Email';
$_lang["emailsender_message"] = 'Here you can specify the e-mail address used when sending users their usernames and passwords.';
$_lang["emailsender_title"] = 'E-mail address:';
$_lang["emailsubject_message"] = 'Here you can specify the value of the subject of the signup e-mail.';
$_lang["emailsubject_title"] = 'E-mail subject:';
$_lang["email_sent"] = 'Email sent';
$_lang["empty_folder"] = 'This folder is empty';
$_lang["empty_recycle_bin"] = 'Purge deleted documents';
$_lang["empty_recycle_bin_empty"] = 'There are no deleted documents to purge.';
$_lang["enabled"] = 'Enabled';
$_lang["enable_resource"] = 'Enable resource file.';
$_lang["enable_sharedparams"] = 'Enable parameter sharing';
$_lang["enable_sharedparams_msg"] = '<b>NOTE:</b> The above globally unique id (GUID) will be used to uniquely identify this module and it\'s shared parameters. The GUID is also used to form a link between the module and the plugins or snippets accessing the it\'s shared parameters. ';
$_lang["error"] = 'Error';
$_lang["errorpage_message"] = 'Enter the ID of the document you want to send users to if they request a document which doesn\'t actually exist. <b>NOTE: make sure this ID you enter belongs to an existing document, and that it has been published!</b>';
$_lang["errorpage_title"] = 'Error page:';
$_lang["error_sending_email"] = 'Error sending email';
$_lang["eventlog"] = 'Event log';
$_lang["eventlog_msg"] = 'The event log is used to display information, warning and error messages generated by the content manager. The \'source\' column shows the section of the content manager where the message occurred.';
$_lang["eventlog_viewer"] = 'System Events';
$_lang["event_id"] = 'Event Id';
$_lang["existing_category"] = 'Existing Category';
$_lang["expand_tree"] = 'Expand tree';
$_lang["export_site"] = 'Export Static HTML';
$_lang["export_site_cacheable"] = 'Include non-cacheable files:';
$_lang["export_site_exporting_document"] = 'Exporting file <b>%s</b> of <b>%s</b><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<small><i>%s</i>, id %s</small><br />&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
$_lang["export_site_failed"] = '<span style="color:#990000">Failed!</span>';
$_lang["export_site_html"] = 'Export site to HTML';
$_lang["export_site_maxtime"] = 'Max export time:';
$_lang["export_site_maxtime_message"] = 'Here you can specify the number of seconds MODx can take to export the site (overriding PHP settings). Enter 0 for unlimited time. Please note, setting 0 or a really high number can do weird things to your server and is not recommended.';
$_lang["export_site_message"] = '<p>Using this function you can export the entire site to HTML files. Please note, however, that you will lose a lot of the MODx functionality should you do so:</p><ul><li>Page reads on the exported files will not be recorded.</li><li>Interactive snippets will NOT work in exported files</li><li>Only regular documents will be exported, Weblinks will not be exported.</li><li>The export process may fail if your documents contain snippets which send redirection headers.</li><li>Depending on how you\'ve written your documents, style sheets and images, the design of your site may be broken. To fix this, you can save/move your exported files to the same directory where the main MODx index.php file is located.</li></ul><p>Please fill out the form and press \'Export\' to start the export process. The files created will be saved in the location you specify, using, where possible, the document\'s aliases as filenames. While exporting your site, it\'s best to have the MODx configuration item \'Friendly aliases\' set to \'yes\'. Depending on the size of your site, the export may take a while.</p><p><em>Any existing files will be overwritten by the new files if their names are identical!</em></p>';
$_lang["export_site_numberdocs"] = '<p><b>Found %s documents to export...</b></p>';
$_lang["export_site_prefix"] = 'File prefix:';
$_lang["export_site_start"] = 'Start export';
$_lang["export_site_success"] = '<span style="color:#009900">Success!</span>';
$_lang["export_site_suffix"] = 'File suffix:';
$_lang["export_site_target_unwritable"] = 'Target directory isn\'t writable. Please ensure the directory is writable, and try again.';
$_lang["export_site_time"] = 'Export finished. Export took %s seconds to complete.';
$_lang["failed_login_message"] = 'Here you can enter the number of failed login attempts that are allowed before a user is blocked.';
$_lang["failed_login_title"] = 'Failed Login Attempts:';
$_lang["fe_editor_lang_message"] = 'Choose a language for the editor to use when used as a front-end editor.';
$_lang["fe_editor_lang_title"] = 'Front-end Editor Language:';
$_lang["filemanager_path_message"] = 'IIS often does not populate the document_root setting properly, which is used by the file manager to determine what you can look at. If you\'re having problems using the file manager, make sure this path points to the root of your MODx installation.';
$_lang["filemanager_path_title"] = 'File Manager Path:';
$_lang["files_access_denied"] = 'Access denied!';
$_lang["files_data"] = 'Data';
$_lang["files_directories"] = 'Directories';
$_lang["files_dirwritable"] = 'Directory writable?';
$_lang["files_dir_listing"] = 'Directory listing for:';
$_lang["files_editfile"] = 'Edit file';
$_lang["files_filename"] = 'Filename';
$_lang["files_fileoptions"] = 'Options';
$_lang["files_files"] = 'Files';
$_lang["files_filesize"] = 'File size';
$_lang["files_filetype_notok"] = 'Uploading of this kind of file isn\'t allowed!';
$_lang["files_file_type"] = 'File type: ';
$_lang["files_modified"] = 'Modified';
$_lang["files_title"] = 'File browser';
$_lang["files_top_level"] = 'To top level';
$_lang["files_uploadfile"] = 'Upload file';
$_lang["files_uploadfile_msg"] = 'Select a file to upload:';
$_lang["files_uploading"] = 'Uploading <b>%s</b> to <b>%s/</b><br />';
$_lang["files_upload_copyfailed"] = 'Failed to copy file to destination directory - upload failed!';
$_lang["files_upload_error"] = 'Error';
$_lang["files_upload_error0"] = 'There was a problem with your upload.';
$_lang["files_upload_error1"] = 'The file you are trying to upload is too big.';
$_lang["files_upload_error2"] = 'The file you are trying to upload is too big.';
$_lang["files_upload_error3"] = 'The file you are trying upload was only partially uploaded.';
$_lang["files_upload_error4"] = 'You must select a file for upload.';
$_lang["files_upload_error5"] = 'There was a problem with your upload.';
$_lang["files_upload_inhibited_msg"] = '<b>Upload feature inhibited</b> - make sure uploads are supported and the directory is writable for PHP.<br />';
$_lang["files_upload_ok"] = 'File uploaded successfully!';
$_lang["files_up_level"] = 'Up one level';
$_lang["files_viewfile"] = 'View file';
$_lang["file_deleted"] = 'Success!';
$_lang["file_delete_file"] = 'Delete File';
$_lang["file_delete_folder"] = 'Delete Folder';
$_lang["file_download_file"] = 'Download File';
$_lang["file_download_unzip"] = 'Unzip File';
$_lang["file_folder_chmod_error"] = 'Unable to change permissions, you will need to change permissions outside of MODx.';
$_lang["file_folder_created"] = 'Folder created successfully!';
$_lang["file_folder_deleted"] = 'Folder was successfully deleted!';
$_lang["file_folder_not_created"] = 'Unable to create folder';
$_lang["file_folder_not_deleted"] = 'Unable to delete folder. Please make sure that the folder is empty before deleting it!';
$_lang["file_not_deleted"] = 'Failed!';
$_lang["file_not_saved"] = 'Cannot save file, please ensure target directory is writable!';
$_lang["file_saved"] = 'File updated successfully!';
$_lang["file_unzip"] = 'Unzip was successful!';
$_lang["file_unzip_fail"] = 'Unzip Failed!';
$_lang["folder"] = 'Folder';
$_lang["forgot_password_email_fine_print"] = '* The URL above will expire once you change your password or after today.';
$_lang["forgot_password_email_instructions"] = 'From there you will be able to change your password from the My Account menu.';
$_lang["forgot_password_email_intro"] = 'A request has been made to change the password on your account.';
$_lang["forgot_password_email_link"] = 'Click here to complete the process.';
$_lang["forgot_your_password"] = 'Forgot your password?';
$_lang["friday"] = 'Friday';
$_lang["friendlyurlsprefix_message"] = 'Here you can specify the prefix to use for friendly URLs. For example, a prefix setting of \'page\' will turn the URL /index.php?id=2 to the friendly URL /page2.html (assuming the suffix is set to .html). This way you can specify what your users (and search engines) see for links on your site.';
$_lang["friendlyurlsprefix_title"] = 'Prefix for friendly URLs:';
$_lang["friendlyurlsuffix_message"] = 'Here you can specify the suffix for Friendly URLs. Specifying \'.html\' will append .html to all your friendly URLs.';
$_lang["friendlyurlsuffix_title"] = 'Suffix for friendly URLs:';
$_lang["friendlyurls_message"] = 'This allows you to use search engine friendly URLs with MODx. Please note, this only works for MODx installations running on Apache, and you\'ll need to write a .htaccess file for this to work. See the .htaccess file included in the distribution for more info.';
$_lang["friendlyurls_title"] = 'Use friendly URLs:';
$_lang["friendly_alias_message"] = 'If you are using friendly URLs, and the document has an alias, the alias will always have precedence over the friendly URL. By setting this option to \'yes\', the friendly URL prefix and suffix will also be applied to the alias. For example, if your document with ID 1 has an alias of `introduction`, and you\'ve set a prefix of `` and a suffix of `.html`, setting this option to `yes` will generate `introduction.html`. If there\'s no alias, MODx will generate `1.html` as link.';
$_lang["friendly_alias_title"] = 'Use friendly aliases:';
$_lang["functionnotimpl"] = 'Sorry!';
$_lang["functionnotimpl_message"] = 'This function has not been implemented yet.';
$_lang["go"] = 'Go';
$_lang["group_access_permissions"] = 'User group access';
$_lang["guid"] = 'GUID';
$_lang["help"] = 'Help';
$_lang["help_msg"] = '<p>You can obtain free community support by <a href="http://modxcms.com/forums" target="_blank">visiting the MODx Forums</a>. There is also a growing body of <a href="http://modxcms.com/documentation" target="_blank">MODx Documentation and Guides</a> that touch on virtually every aspect of MODx.</p><p>We are planning to offer commercial support services for MODx as well. Please <a href="mailto:modx@vertexworks.com?subject=MODx Commercial Support Inquiry">email us if you\'re interested</a>.';
$_lang["help_title"] = 'Help';
$_lang["hide_tree"] = 'Hide tree';
$_lang["home"] = 'Home';
$_lang["htmlsnippet_desc"] = 'Description';
$_lang["htmlsnippet_management_msg"] = 'Here you can select which chunk you wish to edit.';
$_lang["htmlsnippet_msg"] = 'Here you can add/edit chunks. Remember, chunks are \'raw\' HTML code, so any PHP code won\'t be processed.';
$_lang["htmlsnippet_name"] = 'Chunk name';
$_lang["htmlsnippet_title"] = 'Create/edit chunk';
$_lang["icon"] = 'Icon';
$_lang["id"] = 'ID';
$_lang["illegal_parent_child"] = 'Parent Assignment:\n\nDocument is a child of the selected document.';
$_lang["illegal_parent_self"] = 'Parent Assignment:\n\nThe selected document cannot be assigned to itself.';
$_lang["import_files_found"] = '<b>Found %s documents for import...</b><p/>';
$_lang["import_params"] = 'Import module shared parameters';
$_lang["import_params_msg"] = 'You can import the parameters or settings of a module by selecting the name of the module from the above dropdown menu. <b>NOTE:</b> In order for modules to appear inside the menu, this plugin/snippet must be a part of the module\'s dependency listing and the module must have parameter sharing enabled. ';
$_lang["import_parent_document"] = 'Parent Document:';
$_lang["import_site"] = 'Import HTML';
$_lang["import_site_failed"] = '<span style="color:#990000">Failed!</span>';
$_lang["import_site_html"] = 'Import site from HTML';
$_lang["import_site_importing_document"] = 'Importing file <b>%s</b> ';
$_lang["import_site_maxtime"] = 'Max import time:';
$_lang["import_site_maxtime_message"] = 'Here you can specify the number of seconds the Content Manager can take to import the site (overriding PHP settings). Enter 0 for unlimited time. Please note, setting 0 or a really high number can do weird things to your server and is not recommended.';
$_lang["import_site_message"] = 'Using this function you can import an entire HTML site into the database. Please note that you will need to copy your html files and/or folders into the assets/import folder.<p />Please fill out the form and press \'Import\' to start the import process. The files imported will be saved into the selected location, using, where possible, the files name as the document\'s aliases, the page title as the document\'s title.';
$_lang["import_site_skip"] = '<span style="color:#990000">Skipped!</span>';
$_lang["import_site_start"] = 'Start Import';
$_lang["import_site_success"] = '<span style="color:#009900">Success!</span>';
$_lang["import_site_time"] = 'Import finished. Import took %s seconds to complete.';
$_lang["inbox"] = 'Inbox';
$_lang["info"] = 'Info';
$_lang["information"] = 'Information';
$_lang["inline"] = 'Inline';
$_lang["insert"] = 'Insert';
$_lang["insert_snippet"] = 'Insert snippet into document';
$_lang["keyword"] = 'Keyword';
$_lang["keywords"] = 'Keywords';
$_lang["keywords_intro"] = 'To edit a keyword, simply type in the new keyword in the text field next to the keyword you wish to change. To delete a keyword, check the \'delete\' box for that keyword. If you check the keyword\'s delete box, and also change it\'s name, it will be deleted, and the renaming of the keyword will not take place!';
$_lang["language_message"] = 'Select the language for the MODx Content Manager.';
$_lang["language_title"] = 'Language:';
$_lang["launch_site"] = 'View Site';
$_lang["link_attributes"] = 'Link Attributes';
$_lang["link_attributes_help"] = 'Here you can enter attributes for the link for this page, such as target= or rel=.';
$_lang["list_mode"] = 'Turn on/off list mode - used to list all records in the grid.';
$_lang["loading_doc_tree"] = 'Loading document tree...';
$_lang["loading_menu"] = 'Loading menu...';
$_lang["loading_page"] = 'Please wait while MODx loads the page...';
$_lang["localtime"] = 'Local Time';
$_lang["locked"] = 'Locked';
$_lang["lock_htmlsnippet"] = 'Lock chunk for editing';
$_lang["lock_htmlsnippet_msg"] = 'Only Administrators (Role ID 1) can edit this chunk.';
$_lang["lock_module"] = 'Lock module for editing';
$_lang["lock_module_msg"] = 'Only Administrators (Role ID 1) can edit this module.';
$_lang["lock_msg"] = '%s is currently editing this %s. Please wait until the other user has finished and try again.';
$_lang["lock_plugin"] = 'Lock plugin for editing';
$_lang["lock_plugin_msg"] = 'Only Administrators (Role ID 1) can edit this plugin.';
$_lang["lock_settings_msg"] = '%s is currently editing these settings. Please wait until the other user has finished and try again.';
$_lang["lock_snippet"] = 'Lock snippet for editing';
$_lang["lock_snippet_msg"] = 'Only Administrators (Role ID 1) can edit this snippet.';
$_lang["lock_template"] = 'Lock template for editing';
$_lang["lock_template_msg"] = 'Only Administrators (Role ID 1) can edit this template.';
$_lang["lock_tmplvars"] = 'Lock variable for editing';
$_lang["lock_tmplvars_msg"] = 'Only Administrators (Role ID 1) can edit this variable.';
$_lang["login_allowed_days"] = 'Allowed Days';
$_lang["login_allowed_days_message"] = 'Select the days that this user is allowed to login.';
$_lang["login_allowed_ip"] = 'Allowed IP Address';
$_lang["login_allowed_ip_message"] = 'Enter the IP addresses that this user is allowed to login from. <b>NOTE: Separate multiple IP addresses with a comma (,)</b>';
$_lang["login_button"] = 'Login';
$_lang["login_cancelled_install_in_progress"] = '<span style="font-weight: bold; color: red;">Install/update of this site is currently in progress. <br />Please retry in a couple of minutes!</span><br />';
$_lang["login_cancelled_site_was_updated"] = '<span style="font-weight: bold; color: red;">Install/update on this site was executed, please login again!</span><br />';
$_lang["login_captcha_message"] = 'Please enter the security code shown in the graphic. If you can\'t read the code, click the image to generate a new one or contact your site admin.';
$_lang["login_homepage"] = 'Login Home Page';
$_lang["login_homepage_message"] = 'Enter the ID of the document you want to send user to after he/she has logged in. <b>NOTE: make sure the ID you enter belongs to an existing document, and that it has been published and is accessible by this user!</b>';
$_lang["login_message"] = 'Please enter your login credentials to start your Manager session. Your username and password are case-sensitive, so please enter them carefully!';
$_lang["logout"] = 'Logout';
$_lang["logo_slogan"] = 'MODx Content Manager - \nCreate and do more with less';
$_lang["long_title"] = 'Long title';
$_lang["mail_check_timeperiod_title"] = 'Mail Check Time Period:';
$_lang["mail_check_timeperiod_message"] = 'How often to check for new mail messages in the Manager, in seconds.';
$_lang["manager"] = 'Manager';
$_lang["manager_direction_message"] = 'Choose the direction that the text will be rendered in the Manager, left to right or right to left.';
$_lang["manager_direction_title"] = 'Manager Text Direction:';
$_lang["manager_lockout_message"] = 'You are currently logged into the Content Manager. If you would like to close your login session please click the "Logout" button. <p />To go to your startup or home page click the "Home" button.';
$_lang["manager_permissions"] = 'Manager Permissions';
$_lang["manager_theme"] = 'Manager Theme:';
$_lang["manager_theme_message"] = 'Select the Theme for the Content Manager.';
$_lang["manage_depends"] = 'Manage Dependencies';
$_lang["manage_files"] = 'Manage Files';
$_lang["manage_htmlsnippets"] = 'Chunks';
$_lang["manager_lang_attribute_message"] = 'Enter the language code that best fits with your chosen manager language, this will ensure that the browser can present content in the best format for you.';
$_lang["manager_lang_attribute_title"] = 'Manager HTML and XML Language Attribute:';
$_lang["manage_metatags"] = 'Manage META tags and Keywords';
$_lang["manage_modules"] = 'Manage Modules';
$_lang["manage_plugins"] = 'Plugins';
$_lang["manage_snippets"] = 'Snippets';
$_lang["manage_templates"] = 'Templates';
$_lang["messages"] = 'Messages';
$_lang["messages_all"] = 'Everyone';
$_lang["messages_compose"] = 'Compose a message';
$_lang["messages_forward"] = 'Forward';
$_lang["messages_from"] = 'From';
$_lang["messages_group"] = 'A group';
$_lang["messages_inbox"] = 'Inbox';
$_lang["messages_message"] = 'Message';
$_lang["messages_not_allowed_to_read"] = 'You\'re not allowed to read this message!';
$_lang["messages_no_messages"] = 'No messages in Inbox.';
$_lang["messages_private"] = 'Private';
$_lang["messages_read_message"] = 'Read message';
$_lang["messages_reply"] = 'Reply';
$_lang["messages_select_group"] = 'Select a group';
$_lang["messages_select_user"] = 'Select a user';
$_lang["messages_send"] = 'Send';
$_lang["messages_send_to"] = 'Send to';
$_lang["messages_sent"] = 'Sent on';
$_lang["messages_subject"] = 'Subject';
$_lang["messages_system_user"] = '[System]';
$_lang["messages_title"] = 'Messages';
$_lang["messages_user"] = 'A user';
$_lang["metatags"] = 'META tags';
$_lang["metatags_and_keywords"] = 'META tags and Keywords';
$_lang["metatag_intro"] = 'On this page you can delete, create or edit META tags. To link META tags to documents, click on the <u>META Keywords</u> tab when editing the document, and select the desired META tags and keywords. To add a new tag enter the name and value and click the \'Add tag\' button. To edit the tag click on the name of the tag from within the data grid.';
$_lang["metatag_notice"] = 'You may wish to reference the <a href="http://www.html-reference.com/META.htm" target="_blank">HTML Reference Guide</a> site for more information. This is not a complete list of possible Meta Tags.';
$_lang["meta_keywords"] = 'META Keywords';
$_lang["mgr_access_permissions"] = 'Manager access permissions';
$_lang["mgr_login_start"] = 'Manager Login Startup';
$_lang["mgr_login_start_message"] = 'Enter the ID of the document you want to send the user to after he/she has logged into the manager. <b>NOTE: make sure the ID you\'ve enter belongs to an existing document, and that it has been published and is accessible by this user!</b>';
$_lang["mgrlog_action"] = 'Action';
$_lang["mgrlog_actionid"] = 'Action ID';
$_lang["mgrlog_anyall"] = 'Any/All';
$_lang["mgrlog_datecheckfalse"] = 'checkdate() returned false.';
$_lang["mgrlog_datefr"] = 'Date from';
$_lang["mgrlog_dateinvalid"] = 'Invalid date format.';
$_lang["mgrlog_dateto"] = 'Date to';
$_lang["mgrlog_emptysrch"] = 'Your search query returned an empty result set (i.e. not matching logs found).';
$_lang["mgrlog_field"] = 'Field';
$_lang["mgrlog_itemid"] = 'Item ID';
$_lang["mgrlog_itemname"] = 'Item name';
$_lang["mgrlog_msg"] = 'Message';
$_lang["mgrlog_noquery"] = 'No search query entered yet.';
$_lang["mgrlog_query_msg"] = 'Please make a selection for viewing the logs. You can select log entries by date, but be aware that the dates you enter are not inclusive - to select every log entry for 01-01-2004, set \'date from\' to 01-01-2004 and \'date to\' to 02-01-2004.<br /><br />
Message and action are usually the same. If you\'re searching for a specific message, it\'s best to set action to \'Any/All\'.';
$_lang["mgrlog_results"] = 'No. of results';
$_lang["mgrlog_qresults"] = 'Query results';
$_lang["mgrlog_searchlogs"] = 'Search logs';
$_lang["mgrlog_sortinst"] = 'You can sort the table by clicking on the column headers. If the logs are becoming too large, you can <a href="index.php?a=55">empty</a> the logs. This will remove all log entries up to now, and cannot be undone!';
$_lang["mgrlog_query"] = 'Query logging';
$_lang["mgrlog_time"] = 'Time';
$_lang["mgrlog_user"] = 'User';
$_lang["mgrlog_username"] = 'Username';
$_lang["mgrlog_value"] = 'Value';
$_lang["mgrlog_view"] = 'View manager logs';
$_lang["modules"] = 'Modules';
$_lang["module_code"] = 'Module code (php)';
$_lang["module_config"] = 'Module configuration';
$_lang["module_desc"] = 'Description';
$_lang["module_disabled"] = 'Module disabled';
$_lang["module_edit_click_title"] = 'Click here to edit this module';
$_lang["module_group_access_msg"] = 'Select the user groups that are allowed to execute this module from within the Content Manager.';
$_lang["module_management"] = 'Manage Modules';
$_lang["module_management_msg"] = 'Here you can choose the module you would like to execute or modify. To run the module click on the icon in the grid. To modify the module click on the name of the module.';
$_lang["module_msg"] = 'Here you can add/edit Modules. A Module is a collection of resources (e.g. plugins, snippets, etc).';
$_lang["module_name"] = 'Module name';
$_lang["module_resource_msg"] = 'Here you can add or remove resources that this module depends on. To add a new resource click on the one of the add buttons below.';
$_lang["module_resource_title"] = 'Module Dependencies';
$_lang["module_title"] = 'Create/edit Module';
$_lang["module_viewdepend_msg"] = 'Here you can view the assigned resources that the module depends on. Click on the \'Manager Dependencies\' button to modify the dependencies';
$_lang["modx_version"] = "MODx version";
$_lang["monday"] = 'Monday';
$_lang["move"] = 'Move';
$_lang["move_document"] = 'Move document';
$_lang["move_document_message"] = 'You can move a document and all it\'s children by selecting a new parent in the tree. If you select a document that is not already a container, it will be changed into one. Please click on the new parent in the tree.';
$_lang["move_document_new_parent"] = 'Please select a new parent in the document tree.';
$_lang["move_document_title"] = 'Move document';
$_lang["name"] = 'Name';
$_lang["new_category"] = 'New Category';
$_lang["new_file_permissions_message"] = 'When uploading a new file in the File Manager, the File Manager will attempt to change the file permissions to those entered in this setting. This may not work on some setups, such as IIS, in which case you will need to manually change the permissions.';
$_lang["new_file_permissions_title"] = 'New File Permissions';
$_lang["new_folder_permissions_message"] = 'When creating a new folder in the File Manager, the File Manager will attempt to change the folder permissions to those entered in this setting. This may not work on some setups, such as IIS, in which case you will need to manually change the permissions.';
$_lang["new_folder_permissions_title"] = 'New Folder Permissions';
$_lang["new_htmlsnippet"] = 'New chunk';
$_lang["new_keyword"] = 'Add new keyword:';
$_lang["new_module"] = 'New Module';
$_lang["new_parent"] = 'New parent';
$_lang["new_plugin"] = 'New plugin';
$_lang["new_role"] = 'Create a new role';
$_lang["new_snippet"] = 'New snippet';
$_lang["new_template"] = 'New template';
$_lang["new_tmplvars"] = 'New Template Variable';
$_lang["new_user"] = 'New user';
$_lang["new_web_user"] = 'New web user';
$_lang["no"] = 'No';
$_lang["nologentries_message"] = 'Enter the number of log entries shown per page when you browse the Audit trail.';
$_lang["nologentries_title"] = 'Number of log entries:';
$_lang["nomessages_message"] = 'Enter the number of messages to show in inbox when viewing messages.';
$_lang["nomessages_title"] = 'Number of messages:';
$_lang["none"] = 'None';
$_lang["noresults_message"] = 'Enter the number of results to show in the data grid when viewing listings and search results.';
$_lang["noresults_title"] = 'Number of Results:';
$_lang["notset"] = 'Not set';
$_lang["not_deleted"] = 'has not been deleted.';
$_lang["not_set"] = 'Not set';
$_lang["no_activity_message"] = 'You have not yet created or edited any documents.';
$_lang["no_category"] = 'uncategorized';
$_lang["no_docs_pending_publishing"] = 'No documents pending publishing.';
$_lang["no_docs_pending_pubunpub"] = 'No Events Found';
$_lang["no_docs_pending_unpublishing"] = 'No documents pending unpublising.';
$_lang["no_groups_found"] = 'No groups found.';
$_lang["no_keywords_found"] = 'There are currently no keywords.';
$_lang["no_records_found"] = 'No records found.';
$_lang["no_results"] = 'No results found';
$_lang["offline"] = 'Offline';
$_lang["online"] = 'Online';
$_lang["onlineusers_action"] = 'Action';
$_lang["onlineusers_actionid"] = 'Action-ID';
$_lang["onlineusers_ipaddress"] = 'User\'s IP address';
$_lang["onlineusers_lasthit"] = 'Last hit';
$_lang["onlineusers_message"] = 'This list shows all users active within the last 20 minutes (current time is ';
$_lang["onlineusers_title"] = 'Online users';
$_lang["onlineusers_user"] = 'User';
$_lang["onlineusers_userid"] = 'User\'s ID';
$_lang["optimize_table"] = 'Click here to optimize this table';
$_lang["pagetitle"] = 'Document\'s title';
$_lang["page_data_cacheable"] = 'Cacheable';
$_lang["page_data_cacheable_help"] = 'Leaving this field checked will allow the document to be saved to cache. If your document contains snippets, make sure this field is unchecked.';
$_lang["page_data_cached"] = '<b>Source retrieved from cache:</b>';
$_lang["page_data_changes"] = 'Changes';
$_lang["page_data_contentType"] = 'Content Type';
$_lang["page_data_contentType_help"] = 'Select the content type for this document. If you\'re not sure which content type the document should have, just leave it as text/html.';
$_lang["page_data_created"] = 'Created';
$_lang["page_data_edited"] = 'Edited';
$_lang["page_data_editor"] = 'Edit using rich text editor';
$_lang["page_data_folder"] = 'Document is container';
$_lang["page_data_general"] = 'General';
$_lang["page_data_markup"] = 'Markup/structure';
$_lang["page_data_mgr_access"] = 'Manager access';
$_lang["page_data_notcached"] = 'This document has not (yet) been cached.';
$_lang["page_data_publishdate"] = 'Publish date';
$_lang["page_data_publishdate_help"] = 'If you set a publish date, the document will be published as soon as the publish date is reached. Click on the calender icon to select a date, or on the icon next to it to remove the publish date. This will then mean the document is never automatically published.';
$_lang["page_data_published"] = 'Published';
$_lang["page_data_searchable"] = 'Searchable';
$_lang["page_data_searchable_help"] = 'Checking this field will allow the document to be searched. You can also use this field for other purposes in your snippets.';
$_lang["page_data_source"] = 'Source';
$_lang["page_data_status"] = 'Status';
$_lang["page_data_template"] = 'Uses template';
$_lang["page_data_template_help"] = 'Here you can select which template the document uses.';
$_lang["page_data_title"] = 'Page data';
$_lang["page_data_unpublishdate"] = 'Un-publish date';
$_lang["page_data_unpublishdate_help"] = 'If you set an unpublish date, the document will be unpublished as soon as the unpublish date is reached. Click on the calender icon to select a date, or on the icon next to it to remove the unpublish date. This will then mean the document is never automatically unpublished.';
$_lang["page_data_unpublished"] = 'Un-published';
$_lang["page_data_web_access"] = 'Web access';
$_lang["pagination_table_first"] = "First";
$_lang["pagination_table_last"] = "Last";
$_lang["pagination_table_gotopage"] = "Go to page";
$_lang["paging_first"] = 'first';
$_lang["paging_last"] = 'last';
$_lang["paging_next"] = 'next';
$_lang["paging_prev"] = 'prev';
$_lang["paging_showing"] = 'Showing';
$_lang["paging_to"] = 'to';
$_lang["paging_total"] = 'total';
$_lang["parameter"] = 'Parameter';
$_lang["password"] = 'Password';
$_lang["password_change_request"] = 'Password change request';
$_lang["password_gen_gen"] = 'Let MODx generate a password.';
$_lang["password_gen_length"] = 'The password you specify needs to be at least 6 characters long.';
$_lang["password_gen_method"] = 'New password method';
$_lang["password_gen_specify"] = 'Let me specify the password:';
$_lang["password_method"] = 'Password notification method';
$_lang["password_method_email"] = 'Send the new password by e-mail.';
$_lang["password_method_screen"] = 'Show the new password on screen.';
$_lang["password_msg"] = 'The new password for <b>%s</b> is <b>%s</b>.';
$_lang["php_version_check"] = 'MODx is compatible with PHP version 4.0.3 and higher. Please upgrade your PHP installation!';
$_lang["plugin"] = 'Plugin';
$_lang["plugin_code"] = 'Plugin code (php)';
$_lang["plugin_config"] = 'Plugin configuration';
$_lang["plugin_desc"] = 'Description';
$_lang["plugin_disabled"] = 'Plugin Disabled';
$_lang["plugin_event_msg"] = 'Select the events that you would like this plugin to listen to.';
$_lang["plugin_locked_message"] = 'This plugin is locked.';
$_lang["plugin_management_msg"] = 'Here you can choose which plugin you wish to edit.';
$_lang["plugin_msg"] = 'Here you can add/edit plugins. Plugins are \'raw\' PHP codes that are invoked whenever the selected System Events are triggered.';
$_lang["plugin_name"] = 'Plugin name';
$_lang["plugin_priority"] = 'Edit Plugin Execution Order by Event';
$_lang["plugin_title"] = 'Create/edit plugin';
$_lang["preview"] = 'Preview';
$_lang["preview_document"] = 'Preview document';
$_lang["preview_msg"] = 'This is a preview of your last saved changes. Click here to <a href="#" onclick="saveRefreshPreview();">Save and Refresh</a> your current changes';
$_lang["private"] = 'Private';
$_lang["public"] = 'Public';
$_lang["publish_date"] = 'Publish Date';
$_lang["publish_document"] = 'Publish document';
$_lang["publish_events"] = 'Publish Events';
$_lang["rb_base_dir_message"] = 'Enter the physical path to the resource directory. This setting is usually automatically generated. If you\'re using IIS, however, MODx may not be able to work the path out on its own, causing the Resource Browser to show an error. In that case, you can enter the path to the images directory here (the path as you\'d see it in Windows Explorer). <b>NOTE:</b> The resource directory must contain the subfolders images, files, flash and media in order for the resource browser to function correctly.';
$_lang["rb_base_dir_title"] = 'Resource path:';
$_lang["rb_base_url_message"] = 'Enter the virtual path to resource directory. This setting is usually automatically generated. If you\'re using IIS, however, MODx may not be able to work the URL out on it\'s own, causing the Resource Browser to show an error. In that case, you can enter the URL to the images directory here (the URL as you\'d enter it on Internet Explorer).';
$_lang["rb_base_url_title"] = 'Resource URL:';
$_lang["rb_message"] = 'Select yes to enable the resource browser. This will allow your users to browse and upload resources such as images, flash and media files on the server.';
$_lang["rb_title"] = 'Enable Resource Browser:';
$_lang["recent_docs"] = 'Recent documents';
$_lang["refresh_cache"] = 'Cache: Found <b>%s</b> files in cache directory and deleted <b>%d</b> cache files.<p>New cache files will be created when pages are requested.';
$_lang["refresh_published"] = '<b>%s</b> documents were published.';
$_lang["refresh_site"] = 'Clear Cache';
$_lang["refresh_title"] = 'Refresh site';
$_lang["refresh_tree"] = 'Refresh tree';
$_lang["refresh_unpublished"] = '<b>%s</b> documents were unpublished.';
$_lang["remember_username"] = 'Remember me';
$_lang["remove"] = 'Remove';
$_lang["remove_date"] = 'Remove date';
$_lang["remove_locks"] = 'Remove Locks';
$_lang["rename"] = 'Rename';
$_lang["reports"] = 'Reports';
$_lang["require_tagname"] = 'A tag name is required';
$_lang["require_tagvalue"] = 'A tag value is required';
$_lang["reset"] = 'Reset';
$_lang["reset_failedlogins"] = 'reset';
$_lang["resolve_hostnames_message"] = 'Do you want MODx to try to resolve your visitors\' hostnames when they visit your site? Resolving hostnames may create some extra server load, although your visitors won\'t notice this in any way.';
$_lang["resolve_hostnames_title"] = 'Resolve hostnames';
$_lang["resource"] = 'Resource';
$_lang["resources"] = 'Resources';
$_lang["resource_categories"] = 'Combined View';
$_lang["resource_management"] = 'Manage resources';
$_lang["resource_name"] = 'Resource name';
$_lang["resource_selector_msg"] = 'Select the resource(s) from the list below and click the \'Insert\' button.';
$_lang["resource_selector_title"] = 'Resource Selector';
$_lang["role_about"] = 'View the about page';
$_lang["role_access_persmissions"] = 'Access permissions';
$_lang["role_actionok"] = 'View action completed screen';
$_lang["role_bk_manager"] = 'Use the Backup Manager';
$_lang["role_cache_refresh"] = 'Empty the site\'s cache';
$_lang["role_change_password"] = 'Change password';
$_lang["role_chunk_management"] = 'Chunk Management';
$_lang["role_config_management"] = 'Configuration management';
$_lang["role_content_management"] = 'Content management';
$_lang["role_create_chunk"] = 'Create new chunks';
$_lang["role_create_doc"] = 'Create new documents';
$_lang["role_create_plugin"] = 'Create new plugins';
$_lang["role_create_snippet"] = 'Create new snippets';
$_lang["role_create_template"] = 'Create new site templates';
$_lang["role_credits"] = 'View credits';
$_lang["role_delete_chunk"] = 'Delete chunks';
$_lang["role_delete_doc"] = 'Delete documents';
$_lang["role_delete_eventlog"] = 'Delete event log';
$_lang["role_delete_module"] = 'Delete module';
$_lang["role_delete_plugin"] = 'Delete plugins';
$_lang["role_delete_role"] = 'Delete roles';
$_lang["role_delete_snippet"] = 'Delete snippets';
$_lang["role_delete_template"] = 'Delete templates';
$_lang["role_delete_user"] = 'Delete users';
$_lang["role_delete_web_user"] = 'Delete web users';
$_lang["role_edit_chunk"] = 'Edit chunks';
$_lang["role_edit_doc"] = 'Edit a document';
$_lang["role_edit_doc_metatags"] = 'Edit document META tags and keywords';
$_lang["role_edit_module"] = 'Edit module';
$_lang["role_edit_plugin"] = 'Edit plugins';
$_lang["role_edit_role"] = 'Edit roles';
$_lang["role_edit_settings"] = 'Change site settings';
$_lang["role_edit_snippet"] = 'Edit snippets';
$_lang["role_edit_template"] = 'Edit site templates';
$_lang["role_edit_user"] = 'Edit users';
$_lang["role_edit_web_user"] = 'Edit web users';
$_lang["role_errors"] = 'View error dialog';
$_lang['role_export_static'] = 'Export Static HTML';
$_lang["role_eventlog_management"] = 'Event log management';
$_lang["role_file_manager"] = 'Use the file manager';
$_lang["role_frames"] = 'Request manager frames';
$_lang["role_help"] = 'View help pages';
$_lang["role_home"] = 'Request manager intro page';
$_lang['role_import_static'] = 'Import HTML';
$_lang["role_logout"] = 'Log out of the manager';
$_lang["role_management_msg"] = 'Here you can choose which role you wish to edit.';
$_lang["role_management_title"] = 'Roles';
$_lang["role_manage_metatags"] = 'Manage site META tags and keywords';
$_lang["role_messages"] = 'View and send messages';
$_lang["role_module_management"] = 'Module management';
$_lang["role_name"] = 'Role name';
$_lang["role_new_module"] = 'Create new module';
$_lang["role_new_role"] = 'Create new roles';
$_lang["role_new_user"] = 'Create new users';
$_lang["role_new_web_user"] = 'Create new web users';
$_lang["role_plugin_management"] = 'Plugin management';
$_lang["role_publish_doc"] = 'Publish documents';
$_lang["role_role_management"] = 'Roles';
$_lang["role_run_module"] = 'Run module';
$_lang["role_save_chunk"] = 'Save chunks';
$_lang["role_save_doc"] = 'Save documents';
$_lang["role_save_module"] = 'Save module';
$_lang["role_save_password"] = 'Save password';
$_lang["role_save_plugin"] = 'Save plugins';
$_lang["role_save_role"] = 'Save roles';
$_lang["role_save_snippet"] = 'Save snippets';
$_lang["role_save_template"] = 'Save templates';
$_lang["role_save_user"] = 'Save users';
$_lang["role_save_web_user"] = 'Save web users';
$_lang["role_snippet_management"] = 'Snippet management';
$_lang["role_template_management"] = 'Template management';
$_lang["role_title"] = 'Create/edit role';
$_lang["role_udperms"] = 'Permissions management';
$_lang["role_user_management"] = 'User management';
$_lang["role_view_docdata"] = 'View a document\'s data';
$_lang["role_view_eventlog"] = 'View event log';
$_lang["role_view_logs"] = 'View system logs';
$_lang["role_view_unpublished"] = 'View Unpublished Documents';
$_lang["role_web_access_persmissions"] = 'Web access permissions';
$_lang["role_web_user_management"] = 'Web user management';
$_lang["run_module"] = 'Run module';
$_lang["saturday"] = 'Saturday';
$_lang["save"] = 'Save';
$_lang["save_all_changes"] = 'Save all changes';
$_lang["save_tag"] = 'Save tag';
$_lang["saving"] = 'Saving, please wait...';
$_lang["scroll_dn"] = 'Scroll down';
$_lang["scroll_up"] = 'Scroll up';
$_lang["search"] = 'Search';
$_lang["search_criteria"] = 'Search criteria';
$_lang["search_criteria_content"] = 'Search by content';
$_lang["search_criteria_content_msg"] = 'Find all documents with the entered text in their content.';
$_lang["search_criteria_id"] = 'Search by ID';
$_lang["search_criteria_id_msg"] = 'Enter a document\'s ID to quickly locate that document.';
$_lang["search_criteria_longtitle"] = 'Search by long title';
$_lang["search_criteria_longtitle_msg"] = 'Find all documents with the entered text in their long title.';
$_lang["search_criteria_title"] = 'Search by title';
$_lang["search_criteria_title_msg"] = 'Find all documents with the entered text in their title.';
$_lang["search_empty"] = 'Your search returned no results. Please broaden your search criteria and try again.';
$_lang["search_item_deleted"] = 'This item has been deleted';
$_lang["search_results"] = 'Search results';
$_lang["search_results_returned_desc"] = 'Description';
$_lang["search_results_returned_id"] = 'ID';
$_lang["search_results_returned_msg"] = 'Your search criteria returned <b>%s</b> documents. If a lot of results are being returned, try to enter a more specific search. The two left-most columns will allow you to find the document in the tree or view the document. The two right most columns show, respectively, if a document has been deleted and what it\'s published status is.<p />';
$_lang["search_results_returned_title"] = 'Title';
$_lang["search_view_docdata"] = 'View this item';
$_lang["security"] = 'Security';
$_lang["select_date"] = 'Select a date';
$_lang["send"] = 'Send';
$_lang["servertime"] = 'Server Time';
$_lang["serveroffset"] = 'Server Offset';
$_lang["serveroffset_message"] = 'Select the number of hours time difference between where you are and where the server is. Current time on server is <b>[%s]</b>, current time on server using the currently saved offset is <b>[%s]</b>.';
$_lang["serveroffset_title"] = 'Server offset time:';
$_lang["server_protocol_http"] = 'http';
$_lang["server_protocol_https"] = 'https';
$_lang["server_protocol_message"] = 'If your site is on a https connection, please specify so here.';
$_lang["server_protocol_title"] = 'Server type:';
$_lang["settings_after_install"] = 'As this is a new install, you are required to control these settings, and change any that you may wish to. After you\'ve controlled the settings, press \'Save\' to update the settings database.<br /><br />';
$_lang["settings_config"] = 'Configuration';
$_lang["settings_dependencies"] = 'Dependencies';
$_lang["settings_events"] = 'System Events';
$_lang["settings_furls"] = 'Friendly URLs';
$_lang["settings_general"] = 'General';
$_lang["settings_misc"] = 'File Manager';
$_lang["settings_page_settings"] = 'Page Settings';
$_lang["settings_photo"] = 'Photo';
$_lang["settings_properties"] = 'Properties';
$_lang["settings_site"] = 'Site';
$_lang["settings_snippets"] = 'Snippets';
$_lang["settings_strip_image_paths_message"] = 'If this is set to \'No\', MODx  will write file browser resource src\'s (images, files, flash, etc.) as absolute URLs. Relative URLs are helpful should you wish to move your MODx install, e.g., from a staging site to a production site. If you have no idea what this means, it\'s best just to leave it set to \'Yes\'.';
$_lang["settings_strip_image_paths_title"] = 'Rewrite browser paths?';
$_lang["settings_templvars"] = 'Template Variables';
$_lang["settings_title"] = 'System configuration';
$_lang["settings_ui"] = 'Interface &amp; Features';
$_lang["settings_users"] = 'User';
$_lang["showing"] = 'Showing';
$_lang["show_preview"] = 'Show Preview Window';
$_lang["show_tree"] = 'Show tree';
$_lang["signupemail_message"] = 'Here you can set the message sent to your users when you create an account for them and let MODx send them an e-mail containing their username and password. <br /><b>Note:</b> The following placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your users won\'t know their username or password!</b>';
$_lang["signupemail_title"] = 'Signup e-mail:';
$_lang["site"] = 'Site';
$_lang["sitename_message"] = 'Enter the name of your site here.';
$_lang["sitename_title"] = 'Site name:';
$_lang["sitestart_message"] = 'Enter the ID of the document you want to use as homepage here. <b>NOTE: make sure this ID you enter belongs to an existing document, and that it has been published!</b>';
$_lang["sitestart_title"] = 'Site start:';
$_lang["sitestatus_message"] = 'Select \'Online\' to publish your site on the web. If you select \'Offline\', your visitors will see the \'Site unavailable message\', and won\'t be able to browse the site.';
$_lang["sitestatus_title"] = 'Site status:';
$_lang["siteunavailable_message"] = 'Message to show when the site is offline or if an error occurs. <b>Note: This message will only be displayed if the Site unavailable page option is not set.</b>';
$_lang["siteunavailable_page_message"] = 'Enter the ID of the document you want to use as an offline page here. <b>NOTE: make sure this ID you enter belongs to an existing document, and that it has been published!</b>';
$_lang["siteunavailable_page_title"] = 'Site unavailable page:';
$_lang["siteunavailable_title"] = 'Site unavailable message:';
$_lang["site_schedule"] = 'Schedule';
$_lang["snippet"] = 'Snippet';
$_lang["snippets_availabe"] = 'Snippets available for you to include in your page';
$_lang["snippet_code"] = 'Snippet code (php)';
$_lang["snippet_desc"] = 'Description';
$_lang["snippet_execonsave"] = 'Execute snippet after saving.';
$_lang["snippet_management_msg"] = 'Here you can choose which snippet you wish to edit.';
$_lang["snippet_msg"] = 'Here you can add/edit snippets. Remember, snippets are \'raw\' PHP code, and if you expect the output of the snippet to be shown at a certain point within the template, you need to return a value from within the snippet.';
$_lang["snippet_name"] = 'Snippet name';
$_lang["snippet_properties"] = 'Default Properties';
$_lang["snippet_title"] = 'Create/edit snippet';
$_lang["sort_asc"] = 'Ascending';
$_lang["sort_desc"] = 'Descending';
$_lang["sort_tree"] = 'Sort the tree';
$_lang["source"] = 'Source';
$_lang["stay"] = 'Continue editing';
$_lang["stay_new"] = 'Add another';
$_lang["submit"] = 'Submit';
$_lang["sunday"] = 'Sunday';
$_lang["sysinfo_activity_message"] = 'This list show which documents have been recently edited by your users.';
$_lang["sysinfo_userid"] = 'User';
$_lang["system_email_signup"] = 'Hello [+uid+] \n\nHere are your login details for [+sname+] Content Manager:\n\nUsername: [+uid+]\nPassword: [+pwd+]\n\nOnce you log into the Content Manager ([+surl+]), you can change your password.\n\nRegards,\nSite Administrator';
$_lang["system_email_webreminder"] = 'Hello [+uid+]\n\nTo activate your new password click the following link:\n\n[+surl+]\n\nIf successful you can use the following password to login:\n\nPassword:[+pwd+]\n\nIf you did not request this email then please ignore it.\n\nRegrads,\nSite Administrator';
$_lang["system_email_websignup"] = 'Hello [+uid+] \n\nHere are your login details for [+sname+]:\n\nUsername: [+uid+]\nPassword: [+pwd+]\n\nOnce you log into [+sname+] ([+surl+]), you can change your password.\n\nRegards,\nSite Administrator';
$_lang["sys_alert"] = 'System Alert';
$_lang["table_hoverinfo"] = 'Hover the mouse cursor over a table\'s name to see a short description of the table\'s function (not all tables have <i>comments</i> set).';
$_lang["table_prefix"] = 'Table prefix';
$_lang["tag"] = 'Tag';
$_lang["template"] = 'Template';
$_lang["template_assignedtv_tab"] = 'Assigned Template Variables';
$_lang["template_code"] = 'Template code (html)';
$_lang["template_desc"] = 'Description';
$_lang["template_edit_tab"] = 'Edit Template';
$_lang["template_locked_message"] = 'This template is locked.';
$_lang["template_management_msg"] = 'Here you can choose which template you wish to edit.';
$_lang["template_msg"] = 'Create and edit templates. Changed or new templates won\'t be visible in your site\'s cached pages until the cache is emptied, however, you can use the preview function on a page to see the template in action.';
$_lang["template_name"] = 'Template name';
$_lang["template_no_tv"] = 'No template variables have been assigned to this template yet.';
$_lang["template_reset_all"] = 'Reset all pages to use Default template';
$_lang["template_reset_specific"] = 'Reset only \'%s\' pages';
$_lang["template_title"] = 'Create/edit template';
$_lang["template_tv_edit"] = 'Edit the sort order of the template variables';
$_lang["template_tv_msg"] = 'The template variables assigned to this template are listed below.';
$_lang["thursday"] = 'Thursday';
$_lang["tmplvars"] = 'Template Variables';
$_lang["tmplvars_binding_msg"] = 'This field supports data source bindings using the @ commands';
$_lang["tmplvars_caption"] = 'Caption';
$_lang["tmplvars_default"] = 'Default Value';
$_lang["tmplvars_description"] = 'Description';
$_lang["tmplvars_elements"] = 'Input Option Values';
$_lang["tmplvars_management_msg"] = 'Manage additional custom content fields (Template Variables) for your documents.';
$_lang["tmplvars_msg"] = 'Add or edit template variables here. Template Variables must be assigned to templates in order to access them from snippets and documents.';
$_lang["tmplvars_name"] = 'Variable Name';
$_lang["tmplvars_novars"] = 'No Template Variables found';
$_lang["tmplvars_rank"] = 'Sort Order';
$_lang["tmplvars_reset_params"] = 'Reset parameters';
$_lang["tmplvars_type"] = 'Input Type';
$_lang["tmplvars_widget"] = 'Widget';
$_lang["tmplvars_widget_prop"] = 'Widget Properties';
$_lang["tmplvar_access_msg"] = 'Select the document groups that are allowed to modify the content or value of this variable';
$_lang["tmplvar_change_template_msg"] = 'Changing this template will cause the page to reload the Template Variables, losing any unsaved changes.\n\n Are you sure you want to change this template?';
$_lang["tmplvar_inuse"] = 'The following document(s) are currently using this Template Variable. To continue with the delete operation click the Delete button otherwise click the Cancel button.';
$_lang["tmplvar_tmpl_access"] = 'Template Access';
$_lang["tmplvar_tmpl_access_msg"] = 'Select the templates that are allowed to access/process this variable';
$_lang["to"] = 'to';
$_lang["tools"] = 'Tools';
$_lang["top_howmany_message"] = 'When viewing reports, how large should the \'Top ...\' lists be?';
$_lang["top_howmany_title"] = 'Top how many';
$_lang["total"] = 'total';
$_lang["track_visitors_message"] = 'This setting has no effect unless you have a visitor tracking or statistics resource installed that supports this setting. Logging visits will allow you to view your site\'s website usage statistics.';
$_lang["track_visitors_title"] = 'Log visits (stats)';
$_lang["tree_show_protected"] = 'Show protected pages';
$_lang["tree_show_protected_message"] = 'When set to "No", Protected Pages (and all their child-documents) do not appear in the document tree menu. "No" is the legacy setting for MODx.';
$_lang["truncate_table"] = 'Click here to truncate this table';
$_lang["tuesday"] = 'Tuesday';
$_lang["tv"] = 'TV';
$_lang["type"] = 'Type';
$_lang["udperms_allowroot_message"] = 'Do you want to allow your users to create new documents in the root of the site? ';
$_lang["udperms_allowroot_title"] = 'Allow root:';
$_lang["udperms_message"] = 'Access permissions allow you to specify which pages your users are allowed to edit. You\'ll need to assign your users to user groups, your documents to document groups, and then you\'ll need to specify which user groups are allowed to access which document groups. When you first turn this on, only administrators will be allowed to edit any documents.';
$_lang["udperms_title"] = 'Use access permissions:';
$_lang["unable_set_link"] = 'Unable to set the link!';
$_lang["unable_set_parent"] = 'Unable to set new parent!';
$_lang["unauthorizedpage_message"] = 'Enter the ID of the document you want to send users to if they have requested a secured or unauthorized document. <b>NOTE: make sure the ID you enter belongs to an existing document, and that it has been published and is publicly accessible!</b>';
$_lang["unauthorizedpage_title"] = 'Unauthorized page:';
$_lang["unblock_message"] = 'This user will not be blocked after saving the user\'s data.';
$_lang["undelete_document"] = 'Undelete document';
$_lang["unpublish_date"] = 'Unpublish Date';
$_lang["unpublish_document"] = 'Un-publish document';
$_lang["unpublish_events"] = 'Un-publish Events';
$_lang["untitled_document"] = 'Untitled document';
$_lang["untitled_weblink"] = 'Untitled weblink';
$_lang["update_params"] = 'Update parameter display';
$_lang["uploadable_files_message"] = 'Here you can enter a list of files that can be uploaded into \'assets/files/\' using the Resource Manager. Please enter the extensions for the filetypes, seperated by commas.';
$_lang["uploadable_files_title"] = 'Uploadable File Types:';
$_lang["uploadable_flash_message"] = 'Here you can enter a list of files that can be uploaded into \'assets/flash/\' using the Resource Manager. Please enter the extensions for the flash types, separated by commas.';
$_lang["uploadable_flash_title"] = 'Uploadable Flash Types:';
$_lang["uploadable_images_message"] = 'Here you can enter a list of files that can be uploaded into \'assets/images/\' using the Resource Manager. Please enter the extensions for the image types, separated by commas.';
$_lang["uploadable_images_title"] = 'Uploadable Image Types:';
$_lang["uploadable_media_message"] = 'Here you can enter a list of files that can be uploaded into \'assets/media/\' using the Resource Manager. Please enter the extensions for the media types, separated by commas.';
$_lang["uploadable_media_title"] = 'Uploadable Media Types:';
$_lang["upload_maxsize_message"] = 'Enter the maximum file size that can be uploaded via the file manager. Upload file size must be entered in bytes. <b>NOTE: Large files can take a very long time to upload!</b>';
$_lang["upload_maxsize_title"] = 'Maximum upload size';
$_lang["user"] = 'User';
$_lang["username"] = 'Username';
$_lang["users"] = 'Security';
$_lang["user_block"] = 'Blocked';
$_lang["user_blockedafter"] = 'Blocked After';
$_lang["user_blockeduntil"] = 'Blocked Until';
$_lang["user_changeddata"] = 'Your data has been changed. Please log in again.';
$_lang["user_country"] = 'Country';
$_lang["user_dob"] = 'Date of birth';
$_lang["user_doesnt_exist"] = 'User does not exist';
$_lang["user_edit_self_msg"] = 'You may need to log out and log in again after saving to fully update your information.</b><br>Also, should you choose to generate a new password for yourself, it will be sent to you through e-mail.';
$_lang["user_email"] = 'E-mail address';
$_lang["user_failedlogincount"] = 'Failed logins';
$_lang["user_fax"] = 'Fax';
$_lang["user_female"] = 'Female';
$_lang["user_full_name"] = 'Full name';
$_lang["user_gender"] = 'Gender';
$_lang["user_is_blocked"] = 'This user is blocked!';
$_lang["user_logincount"] = 'Number of logins';
$_lang["user_male"] = 'Male';
$_lang["user_management_msg"] = 'Here you can choose which Content Manager user you wish to edit. Content Manager users are those users who are allowed to log into the Content Manager';
$_lang["user_management_title"] = 'Manager Users';
$_lang["user_mobile"] = 'Mobile phone number';
$_lang["user_phone"] = 'Phone number';
$_lang["user_photo"] = 'User Photo';
$_lang["user_photo_message"] = 'Enter the image url for the this user or use the insert button to selected or upload an image file on the server.';
$_lang["user_prevlogin"] = 'Last login';
$_lang["user_role"] = 'User\'s role';
$_lang["user_state"] = 'State';
$_lang["user_title"] = 'Create/Edit user';
$_lang["user_upload_message"] = ' If you wish to stop this user uploading any filetypes in this category, make sure that the \'Use Main Configuration Setting\' checkbox is not ticked and leave the field blank.';
$_lang["user_use_config"] = 'Use System Configuration Setting';
$_lang["user_zip"] = 'Zip';
$_lang["use_alias_path_message"] = 'Setting this option to \'yes\' will display the full path to the document if the document has an alias. For example, if a document with an alias called \'child\' is located inside a container document with an alias called \'parent\', then the full alias path to the document will be displayed as \'/parent/child.html\'.<br /><b>NOTE: When setting this option to \'Yes\' (turning on alias paths), reference items (such as images, css, javascripts, etc) using the absolute path: e.g., \'/assets/images\' as oppose to \'assets/images\'. By doing so you will prevent the browser (or web server) from appending the relative path to the alias path.</b>';
$_lang["use_alias_path_title"] = 'Use friendly alias path:';
$_lang["use_editor_message"] = 'Do you want to enable the rich text editor? If you\'re more comfortable writing HTML, then you can turn the editor off using this setting. Note that this setting applies to all documents and all users!';
$_lang["use_editor_title"] = 'Enable editor:';
$_lang["value"] = 'Value';
$_lang["version_codename"] = "Version codename";
$_lang["view"] = 'View';
$_lang["view_child_documents_in_container"] = "View children";
$_lang["view_document"] = 'View document';
$_lang["view_log"] = 'View log';
$_lang["view_logging"] = 'Manager Actions';
$_lang["view_sysinfo"] = 'System Info';
$_lang["warning"] = 'Warning!';
$_lang["warning_not_saved"] = 'The changes you have made have not been saved yet. You can choose to stay on the current page in order to save the changes (\'Cancel\'), or you can leave this page, losing any changes you have made (\'OK\').';
$_lang["weblink"] = 'Weblink';
$_lang["weblink_message"] = 'A weblink is a reference to an object on the internet. This could be a document within MODx, a page on another site or an image or other file on the internet.<p>';
$_lang["webpwdreminder_message"] = 'Enter a message to be sent to your web users whenever they request a new password via email. The Content Manager will send an e-mail containing their new password and activation information. <br /><b>Note:</b> The following placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your users won\'t know their username or password!</b>';
$_lang["webpwdreminder_title"] = 'Web Reminder Email:';
$_lang["websignupemail_message"] = 'Here you can set the message sent to your web users when you create a web account for them and let the Content Manager send them an e-mail containing their username and password. <br /><b>Note:</b> The following placeholders are replaced by the Content Manager when the message is sent: <br /><br />[+sname+] - Name of your web site, <br />[+saddr+] - Your web site email address, <br />[+surl+] - Your site url, <br />[+uid+] - User\'s Login name or id, <br />[+pwd+] - User\'s password, <br />[+ufn+] - User\'s full name. <br /><br /><b>Leave the [+uid+] and [+pwd+] in the e-mail, or else the username and password won\'t be sent in the mail and your users won\'t know their username or password!</b>';
$_lang["websignupemail_title"] = 'Web Signup e-mail:';
$_lang["web_access_permissions"] = 'Web access permissions';
$_lang["web_access_permissions_user_group"] = 'Web User group:';
$_lang["web_access_permissions_user_groups"] = 'Web User groups';
$_lang["web_access_permissions_user_group_access"] = 'Document groups this user group has access to:';
$_lang["web_permissions"] = 'Web Permissions';
$_lang["web_users"] = 'Web users';
$_lang["web_user_management_msg"] = 'Here you can choose which web user you wish to edit. Web users are those users who are only allowed to log into the the web site';
$_lang["web_user_management_title"] = 'Web Users';
$_lang["web_user_title"] = 'Create/edit web user';
$_lang["wednesday"] = 'Wednesday';
$_lang["welcome_messages"] = 'Your Inbox contains <strong>%d</strong> message(s), of which <strong>%s</strong> are unread.';
$_lang["welcome_title"] = 'Welcome to your MODx Content Manager';
$_lang["which_editor_message"] = 'Here you can select which rich text editor you wish to use. You can download and install additional Rich Text editors from the MODx download page.';
$_lang["which_editor_title"] = 'Editor to use:';
$_lang["working"] = 'Working...';
$_lang["wrap_lines"] = 'Wrap lines';
$_lang["xhtml_urls_title"] = 'XHTML URLs';
$_lang["xhtml_urls_message"] = 'Replaces ampersand (&amp;) characters in urls that are generated by MODx with the validating &amp;<!-- -->amp; htmlentity';
$_lang["yes"] = 'Yes';
$_lang["yourinfo_message"] = 'This section shows some information about you:';
$_lang["yourinfo_previous_login"] = 'Your last login:';
$_lang["yourinfo_role"] = 'Your role is:';
$_lang["yourinfo_title"] = 'Your info';
$_lang["yourinfo_total_logins"] = 'Total number of logins:';
$_lang["yourinfo_username"] = 'You are logged in as:';
$_lang["you_got_mail"] = 'You got mail';
?>